package com.xebialabs.deployit.core.api;

import java.util.List;

import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;

import org.jboss.resteasy.annotations.ClientResponseType;

import com.xebialabs.deployit.core.api.dto.RepositoryObjects;
import com.xebialabs.deployit.core.api.dto.Steps;

/**
 */
@Path("/deployit/deployment")
@Consumes(MediaType.APPLICATION_XML)
@Produces(MediaType.APPLICATION_XML)
public interface DeploymentProxy {

    @GET
    @Path("mappings")
    @ClientResponseType(entityType = RepositoryObjects.class)
    Response generateMappings(@QueryParam("source") String sourceId, @QueryParam("target") String targetId);

    @GET
    @Path("partial-mappings")
    @ClientResponseType(entityType = RepositoryObjects.class)
    Response generatePartialMappings(@QueryParam("partialSource") List<String> partialSourceIds, @QueryParam("target") String targetId, @QueryParam("mappingtype") String mappingType);

    @POST
    @ClientResponseType(entityType = Steps.class)
    Response prepare(@QueryParam("source") String sourceId, @QueryParam("target") String targetId, RepositoryObjects mappings);

    @POST
    @Path("validate")
    @ClientResponseType(entityType = RepositoryObjects.class)
    Response validate(@QueryParam("source") String sourceId, @QueryParam("target") String targetId, RepositoryObjects mappings);
}
