package com.xebialabs.deployit.core.api;

import ai.digital.deploy.sql.model.AddUserProfile;
import ai.digital.deploy.sql.model.UserProfileView;
import com.xebialabs.deployit.engine.api.dto.Ordering;
import com.xebialabs.deployit.engine.api.dto.Paging;
import com.xebialabs.deployit.security.model.XldUserProfile;
import org.springframework.web.bind.annotation.RequestBody;

import jakarta.ws.rs.*;
import jakarta.ws.rs.core.MediaType;

import java.util.List;

@Path("user/profiles")
@Produces({MediaType.APPLICATION_XML, MediaType.APPLICATION_JSON})
public interface XldUserProfileService {

    @GET
    @Path("{username}")
    UserProfileView getUserProfile(@PathParam("username") String username, @QueryParam("credentials") @DefaultValue("true") Boolean loadCredentials);

    @PUT
    @Path("{username}")
    void createOrUpdateUserProfile(@PathParam("username") String username, @RequestBody AddUserProfile userProfile);

    @GET
    List<XldUserProfile> listAllUserProfiles(
            @QueryParam("username") String username,
            @QueryParam("fullName") String fullName,
            @QueryParam("email") String email,
            @BeanParam Paging paging,
            @QueryParam("order") Ordering order);
}
