package com.xebialabs.deployit.core.api;

import ai.digital.deploy.sql.model.AddUserProfile;
import ai.digital.deploy.sql.model.UserProfileView;
import org.springframework.web.bind.annotation.RequestBody;

import javax.ws.rs.*;
import javax.ws.rs.core.MediaType;

@Path("user/profiles")
@Produces({MediaType.APPLICATION_XML, MediaType.APPLICATION_JSON})
public interface XldUserProfileService {

    @GET
    @Path("{username}")
    UserProfileView getUserProfile(@PathParam("username") String username, @QueryParam("credentials") @DefaultValue("true") Boolean loadCredentials);

    @PUT
    @Path("{username}")
    void createOrUpdateUserProfile(@PathParam("username") String username, @RequestBody AddUserProfile userProfile);
}
