/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.core.rest.api;

import com.google.common.collect.Sets;
import com.xebialabs.deployit.core.api.dto.ReportLine;
import com.xebialabs.deployit.core.api.resteasy.Date;
import com.xebialabs.deployit.core.converters.ControlTaskReportLineConverter$;
import com.xebialabs.deployit.core.converters.ControlTaskReportLineField$;
import com.xebialabs.deployit.core.converters.DeploymentReportLineField$;
import com.xebialabs.deployit.core.converters.DeploymentTaskReportLineConverter$;
import com.xebialabs.deployit.core.rest.api.DownloadResource;
import com.xebialabs.deployit.core.rest.api.SearchParametersFactory;
import com.xebialabs.deployit.core.rest.api.reports.ReportUtils;
import com.xebialabs.deployit.core.rest.resteasy.Workdir;
import com.xebialabs.deployit.core.rest.secured.AbstractSecuredResource;
import com.xebialabs.deployit.core.service.PaginationService;
import com.xebialabs.deployit.core.service.ReportGenerator;
import com.xebialabs.deployit.core.util.TaskFilterUtils$;
import com.xebialabs.deployit.engine.api.ReportService;
import com.xebialabs.deployit.engine.api.dto.ConfigurationItemId;
import com.xebialabs.deployit.engine.api.dto.ControlTaskReportLine;
import com.xebialabs.deployit.engine.api.dto.DeploymentTaskReportLine;
import com.xebialabs.deployit.engine.api.dto.Paging;
import com.xebialabs.deployit.engine.api.execution.FetchMode;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.Application;
import com.xebialabs.deployit.plugin.api.udm.Environment;
import com.xebialabs.deployit.repository.SearchParameters;
import com.xebialabs.deployit.repository.sql.CiRepository;
import com.xebialabs.deployit.repository.sql.ConfigurationItemDataWithInternalId;
import com.xebialabs.deployit.security.permission.PlatformPermissions;
import com.xebialabs.deployit.task.ArchivedTaskSearchParameters;
import com.xebialabs.deployit.task.TaskType;
import com.xebialabs.deployit.task.archive.TaskArchive;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import java.util.EnumSet;
import java.util.Set;
import java.util.stream.Stream;
import javax.ws.rs.core.Context;
import org.jboss.resteasy.spi.HttpResponse;
import org.joda.time.ReadableInstant;
import org.slf4j.Marker;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.transaction.annotation.Transactional;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenSet;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.convert.ImplicitConversions$;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer$;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@Controller
@Autowired
@ScalaSignature(bytes="\u0006\u0001\r-d\u0001\u0002\r\u001a\u0001\u0019B\u0001\u0002\u0010\u0001\u0003\u0002\u0003\u0006I!\u0010\u0005\t\u0007\u0002\u0011\t\u0011)A\u0005\t\"Aq\t\u0001B\u0001B\u0003%\u0001\n\u0003\u0005Q\u0001\t\u0005\t\u0015!\u0003R\u0011!I\u0006A!A!\u0002\u0013Q\u0006\"\u00020\u0001\t\u0003y\u0006\"\u00034\u0001\u0001\u0004\u0005\r\u0011\"\u0003h\u0011%!\b\u00011AA\u0002\u0013%Q\u000fC\u0005\u007f\u0001\u0001\u0007\t\u0011)Q\u0005Q\"9\u0011q\u0003\u0001\u0005\u0002\u0005e\u0001bBA\u000f\u0001\u0011%\u0011q\u0004\u0005\b\u0003\u001b\u0002A\u0011BA(\u0011\u001d\tI\u000b\u0001C\u0005\u0003WCqAa\b\u0001\t\u0003\u0012\t\u0003C\u0004\u0003<\u0001!\tE!\u0010\t\u000f\tM\u0005\u0001\"\u0003\u0003\u0016\"9!q\u0018\u0001\u0005B\t\u0005\u0007b\u0002Bl\u0001\u0011\u0005#\u0011\u001c\u0005\b\u0005_\u0004A\u0011\u0002By\u0011\u001d\u0019Y\u0003\u0001C\u0005\u0007[Aqaa\u000f\u0001\t\u0003\u001ai\u0004C\u0004\u0004@\u0001!\te!\u0010\t\u000f\r\u0005\u0003\u0001\"\u0011\u0004D\t\t\"+\u001a9peR\u001cVM\u001d<jG\u0016LU\u000e\u001d7\u000b\u0005iY\u0012aA1qS*\u0011A$H\u0001\u0005e\u0016\u001cHO\u0003\u0002\u001f?\u0005!1m\u001c:f\u0015\t\u0001\u0013%\u0001\u0005eKBdw._5u\u0015\t\u00113%A\u0005yK\nL\u0017\r\\1cg*\tA%A\u0002d_6\u001c\u0001a\u0005\u0003\u0001O5\"\u0004C\u0001\u0015,\u001b\u0005I#B\u0001\u0016\u001c\u0003\u001d\u0019XmY;sK\u0012L!\u0001L\u0015\u0003/\u0005\u00137\u000f\u001e:bGR\u001cVmY;sK\u0012\u0014Vm]8ve\u000e,\u0007C\u0001\u00183\u001b\u0005y#B\u0001\u000e1\u0015\t\tt$\u0001\u0004f]\u001eLg.Z\u0005\u0003g=\u0012QBU3q_J$8+\u001a:wS\u000e,\u0007CA\u001b;\u001b\u00051$BA\u001c9\u0003\u0015\u0019HN\u001a\u001bk\u0015\u0005I\u0014\u0001C4sSjTH.\u001a3\n\u0005m2$a\u0002'pO\u001eLgnZ\u0001\u0010e\u0016\u0004xN\u001d;HK:,'/\u0019;peB\u0011a(Q\u0007\u0002\u007f)\u0011\u0001)H\u0001\bg\u0016\u0014h/[2f\u0013\t\u0011uHA\bSKB|'\u000f^$f]\u0016\u0014\u0018\r^8s\u0003E\u0001\u0018mZ5oCRLwN\\*feZL7-\u001a\t\u0003}\u0015K!AR \u0003#A\u000bw-\u001b8bi&|gnU3sm&\u001cW-\u0001\u0007dSJ+\u0007o\\:ji>\u0014\u0018\u0010\u0005\u0002J\u001d6\t!J\u0003\u0002L\u0019\u0006\u00191/\u001d7\u000b\u00055{\u0012A\u0003:fa>\u001c\u0018\u000e^8ss&\u0011qJ\u0013\u0002\r\u0007&\u0014V\r]8tSR|'/_\u0001\fi\u0006\u001c8.\u0011:dQ&4X\r\u0005\u0002S/6\t1K\u0003\u0002U+\u00069\u0011M]2iSZ,'B\u0001, \u0003\u0011!\u0018m]6\n\u0005a\u001b&a\u0003+bg.\f%o\u00195jm\u0016\f\u0001\u0003Z8x]2|\u0017\r\u001a*fg>,(oY3\u0011\u0005mcV\"A\r\n\u0005uK\"\u0001\u0005#po:dw.\u00193SKN|WO]2f\u0003\u0019a\u0014N\\5u}Q1\u0001-\u00192dI\u0016\u0004\"a\u0017\u0001\t\u000bq2\u0001\u0019A\u001f\t\u000b\r3\u0001\u0019\u0001#\t\u000b\u001d3\u0001\u0019\u0001%\t\u000bA3\u0001\u0019A)\t\u000be3\u0001\u0019\u0001.\u0002\u0011I,7\u000f]8og\u0016,\u0012\u0001\u001b\t\u0003SJl\u0011A\u001b\u0006\u0003W2\f1a\u001d9j\u0015\tig.\u0001\u0005sKN$X-Y:z\u0015\ty\u0007/A\u0003kE>\u001c8OC\u0001r\u0003\ry'oZ\u0005\u0003g*\u0014A\u0002\u0013;uaJ+7\u000f]8og\u0016\fAB]3ta>t7/Z0%KF$\"A\u001e?\u0011\u0005]TX\"\u0001=\u000b\u0003e\fQa]2bY\u0006L!a\u001f=\u0003\tUs\u0017\u000e\u001e\u0005\b{\"\t\t\u00111\u0001i\u0003\rAH%M\u0001\ne\u0016\u001c\bo\u001c8tK\u0002B3!CA\u0001!\u0011\t\u0019!a\u0005\u000e\u0005\u0005\u0015!b\u0001\u0010\u0002\b)!\u0011\u0011BA\u0006\u0003\t\u00118O\u0003\u0003\u0002\u000e\u0005=\u0011AA<t\u0015\t\t\t\"A\u0003kCZ\f\u00070\u0003\u0003\u0002\u0016\u0005\u0015!aB\"p]R,\u0007\u0010^\u0001\fg\u0016$(+Z:q_:\u001cX\rF\u0002w\u00037AQA\u001a\u0006A\u0002!\fAb]3u\u0007&4\u0015\u000e\u001c;feN$RA^A\u0011\u0003[Aq!a\t\f\u0001\u0004\t)#\u0001\ttK\u0006\u00148\r\u001b)be\u0006lW\r^3sgB!\u0011qEA\u0015\u001b\u0005)\u0016bAA\u0016+\na\u0012I]2iSZ,G\rV1tWN+\u0017M]2i!\u0006\u0014\u0018-\\3uKJ\u001c\bbBA\u0018\u0017\u0001\u0007\u0011\u0011G\u0001\u0015G>tg-[4ve\u0006$\u0018n\u001c8Ji\u0016l\u0017\nZ:\u0011\r\u0005M\u0012QHA!\u001b\t\t)D\u0003\u0003\u00028\u0005e\u0012\u0001B;uS2T!!a\u000f\u0002\t)\fg/Y\u0005\u0005\u0003\u007f\t)D\u0001\u0003MSN$\b\u0003BA\"\u0003\u0013j!!!\u0012\u000b\u0007\u0005\u001ds&A\u0002ei>LA!a\u0013\u0002F\t\u00192i\u001c8gS\u001e,(/\u0019;j_:LE/Z7JI\u0006a1\u000f\u001e:fC6\u0014V\r]8siV!\u0011\u0011KA2)!\t\u0019&!\u001e\u0002\u0006\u0006=\u0005CBA+\u00037\ny&\u0004\u0002\u0002X)!\u0011\u0011LA\u001b\u0003\u0019\u0019HO]3b[&!\u0011QLA,\u0005\u0019\u0019FO]3b[B!\u0011\u0011MA2\u0019\u0001!q!!\u001a\r\u0005\u0004\t9GA\u0001U#\u0011\tI'a\u001c\u0011\u0007]\fY'C\u0002\u0002na\u0014qAT8uQ&tw\rE\u0002x\u0003cJ1!a\u001dy\u0005\r\te.\u001f\u0005\b\u0003ob\u0001\u0019AA=\u0003\u0019\u0001\u0018mZ5oOB)q/a\u001f\u0002\u0000%\u0019\u0011Q\u0010=\u0003\r=\u0003H/[8o!\u0011\t\u0019%!!\n\t\u0005\r\u0015Q\t\u0002\u0007!\u0006<\u0017N\\4\t\u000f\u0005\u001dE\u00021\u0001\u0002\n\u0006Y!-^5mIB\u000b'/Y7t!\u001d9\u00181RA@\u0003KI1!!$y\u0005%1UO\\2uS>t\u0017\u0007C\u0004\u0002Z1\u0001\r!!%\u0011\u000f]\fY)!\n\u0002T!:A\"!&\u0002\"\u0006\r\u0006\u0003BAL\u0003;k!!!'\u000b\t\u0005m\u0015\u0011H\u0001\u0005Y\u0006tw-\u0003\u0003\u0002 \u0006e%\u0001E*vaB\u0014Xm]:XCJt\u0017N\\4t\u0003\u00151\u0018\r\\;fY\t\t)+\t\u0002\u0002(\u0006\u0019\u0011\r\u001c7\u00025M$(/Z1n\t\u0016\u0004Hn\\=nK:$H+Y:l%\u0016\u0004xN\u001d;\u00155\u00055\u0016QWAc\u0003\u0013\fY-a6\u0002t\u0006]\u00181 B\u0006\u0005\u001f\u0011IB!\b\u0011\r\u0005U\u00131LAX!\u0011\t\u0019%!-\n\t\u0005M\u0016Q\t\u0002\u0019\t\u0016\u0004Hn\\=nK:$H+Y:l%\u0016\u0004xN\u001d;MS:,\u0007bBA\\\u001b\u0001\u0007\u0011\u0011X\u0001\u0006E\u0016<\u0017N\u001c\t\u0005\u0003w\u000b\t-\u0004\u0002\u0002>*\u0019Q.a0\u000b\u0005ii\u0012\u0002BAb\u0003{\u0013A\u0001R1uK\"9\u0011qY\u0007A\u0002\u0005e\u0016aA3oI\"9\u0011qO\u0007A\u0002\u0005e\u0004bBAg\u001b\u0001\u0007\u0011qZ\u0001\u0006_J$WM\u001d\t\u0007\u0003g\ti$!5\u0011\t\u0005\r\u00131[\u0005\u0005\u0003+\f)E\u0001\u0005Pe\u0012,'/\u001b8h\u0011\u001d\tI.\u0004a\u0001\u00037\fQ!^:feN\u0004b!a\r\u0002>\u0005u\u0007\u0003BAp\u0003[tA!!9\u0002jB\u0019\u00111\u001d=\u000e\u0005\u0005\u0015(bAAtK\u00051AH]8pizJ1!a;y\u0003\u0019\u0001&/\u001a3fM&!\u0011q^Ay\u0005\u0019\u0019FO]5oO*\u0019\u00111\u001e=\t\u000f\u0005UX\u00021\u0001\u0002\\\u0006QA/Y:l'R\fG/Z:\t\u000f\u0005eX\u00021\u0001\u0002\\\u0006IA/Y:l)f\u0004Xm\u001d\u0005\b\u0003{l\u0001\u0019AA\u0000\u0003%1W\r^2i\u001b>$W\r\u0005\u0003\u0003\u0002\t\u001dQB\u0001B\u0002\u0015\r\u0011)aL\u0001\nKb,7-\u001e;j_:LAA!\u0003\u0003\u0004\tIa)\u001a;dQ6{G-\u001a\u0005\b\u0005\u001bi\u0001\u0019AAo\u0003\u0019!\u0018m]6JI\"9!\u0011C\u0007A\u0002\tM\u0011AD8oYf\u001cVoY2fgN4W\u000f\u001c\t\u0004o\nU\u0011b\u0001B\fq\n9!i\\8mK\u0006t\u0007b\u0002B\u000e\u001b\u0001\u0007\u0011Q\\\u0001\u000bo>\u00148.\u001a:OC6,\u0007bBA\u0018\u001b\u0001\u0007\u0011\u0011G\u0001\u000eO\u0016$H+Y:l%\u0016\u0004xN\u001d;\u00155\u00055&1\u0005B\u0013\u0005O\u0011ICa\u000b\u0003.\t=\"\u0011\u0007B\u001a\u0005k\u00119D!\u000f\t\u000f\u0005]f\u00021\u0001\u0002:\"9\u0011q\u0019\bA\u0002\u0005e\u0006bBA<\u001d\u0001\u0007\u0011q\u0010\u0005\b\u0003\u001bt\u0001\u0019AAh\u0011\u001d\tIN\u0004a\u0001\u00037Dq!!>\u000f\u0001\u0004\tY\u000eC\u0004\u0002z:\u0001\r!a7\t\u000f\u0005uh\u00021\u0001\u0002\u0000\"9!Q\u0002\bA\u0002\u0005u\u0007b\u0002B\t\u001d\u0001\u0007!1\u0003\u0005\b\u00057q\u0001\u0019AAo\u0011\u001d\tyC\u0004a\u0001\u0003c\t!\u0003Z8x]2|\u0017\r\u001a+bg.\u0014V\r]8siR1\u0012Q\u001cB \u0005\u0003\u0012\u0019E!\u0012\u0003H\t%#1\nB'\u0005\u001f\u0012\t\u0006C\u0004\u00028>\u0001\r!!/\t\u000f\u0005\u001dw\u00021\u0001\u0002:\"9\u0011QZ\bA\u0002\u0005=\u0007bBAm\u001f\u0001\u0007\u00111\u001c\u0005\b\u0003k|\u0001\u0019AAn\u0011\u001d\tIp\u0004a\u0001\u00037DqA!\u0004\u0010\u0001\u0004\ti\u000eC\u0004\u0003\u0012=\u0001\rAa\u0005\t\u000f\tmq\u00021\u0001\u0002^\"9\u0011qF\bA\u0002\u0005E\u0002fC\b\u0003V\u0005\u0005&\u0011\u000eB7\u0005_\u0002BAa\u0016\u0003f5\u0011!\u0011\f\u0006\u0005\u00057\u0012i&\u0001\u0006b]:|G/\u0019;j_:TAAa\u0018\u0003b\u0005YAO]1og\u0006\u001cG/[8o\u0015\r\u0011\u0019\u0007]\u0001\u0010gB\u0014\u0018N\\4ge\u0006lWm^8sW&!!q\rB-\u00055!&/\u00198tC\u000e$\u0018n\u001c8bY\u0006\u0012!1N\u0001\u001ce\u0016\u0004xN\u001d;j]\u001e$&/\u00198tC\u000e$\u0018n\u001c8NC:\fw-\u001a:\u0002\u0011I,\u0017\rZ(oYfL\u0012!\u0001\u0015\f\u001f\tM$Q\u0010B@\u0005\u0007\u0013)\t\u0005\u0003\u0003v\teTB\u0001B<\u0015\ti7$\u0003\u0003\u0003|\t]$aB,pe.$\u0017N]\u0001\u0007aJ,g-\u001b=\"\u0005\t\u0005\u0015\u0001\u00033po:dw.\u00193\u0002\u000b\rdW-\u00198%\u0005\t\u001d\u0015\u0002\u0002BE\u0005\u0017\u000ba!\u0011'X\u0003f\u001b&\u0002\u0002BG\u0005\u001f\u000bQa\u00117fC:TAA!%\u0003x\u00059qk\u001c:lI&\u0014\u0018aF:ue\u0016\fWnQ8oiJ|G\u000eV1tWJ+\u0007o\u001c:u)Y\u00119Ja(\u0003\"\n\r&q\u0015BV\u0005[\u0013yK!-\u00034\nU\u0006CBA+\u00037\u0012I\n\u0005\u0003\u0002D\tm\u0015\u0002\u0002BO\u0003\u000b\u0012QcQ8oiJ|G\u000eV1tWJ+\u0007o\u001c:u\u0019&tW\rC\u0004\u00028B\u0001\r!!/\t\u000f\u0005\u001d\u0007\u00031\u0001\u0002:\"9!Q\u0015\tA\u0002\u0005m\u0017AB:uCR,7\u000fC\u0004\u0003*B\u0001\r!!8\u0002\u0011Q\f7o\u001b(b[\u0016Dq!!@\u0011\u0001\u0004\ty\u0010C\u0004\u0002ZB\u0001\r!a7\t\u000f\u00055\u0007\u00031\u0001\u0002P\"9!1\u0004\tA\u0002\u0005u\u0007bBA<!\u0001\u0007\u0011\u0011\u0010\u0005\b\u0005o\u0003\u0002\u0019\u0001B]\u0003\u001d!\u0018M]4fiN\u0004b!a\r\u0003<\u0006u\u0017\u0002\u0002B_\u0003k\u00111aU3u\u0003U9W\r^\"p]R\u0014x\u000e\u001c+bg.\u001c(+\u001a9peR$bCa&\u0003D\n\u0015'q\u0019Be\u0005\u0017\u0014iMa4\u0003R\nM'Q\u001b\u0005\b\u0003o\u000b\u0002\u0019AA]\u0011\u001d\t9-\u0005a\u0001\u0003sCqA!*\u0012\u0001\u0004\tY\u000eC\u0004\u0003*F\u0001\r!!8\t\u000f\u0005u\u0018\u00031\u0001\u0002\u0000\"9\u0011\u0011\\\tA\u0002\u0005m\u0007bBAg#\u0001\u0007\u0011q\u001a\u0005\b\u00057\t\u0002\u0019AAo\u0011\u001d\t9(\u0005a\u0001\u0003\u007fBqAa.\u0012\u0001\u0004\u0011I,\u0001\u000ee_^tGn\\1e\u0007>tGO]8m)\u0006\u001c8n\u001d*fa>\u0014H\u000f\u0006\n\u0002^\nm'Q\u001cBp\u0005C\u0014\u0019O!:\u0003h\n%\bbBA\\%\u0001\u0007\u0011\u0011\u0018\u0005\b\u0003\u000f\u0014\u0002\u0019AA]\u0011\u001d\u0011)K\u0005a\u0001\u00037DqA!+\u0013\u0001\u0004\ti\u000eC\u0004\u0002ZJ\u0001\r!a7\t\u000f\u00055'\u00031\u0001\u0002P\"9!1\u0004\nA\u0002\u0005u\u0007b\u0002B\\%\u0001\u0007!\u0011\u0018\u0015\f%\tU\u0013\u0011\u0015B5\u0005[\u0012y\u0007K\u0006\u0013\u0005g\u0012iHa \u0003\u0004\n\u0015\u0015a\u00067jgR\fE\u000e\\\"jg>3G+\u001f9f\u000fJ|W\u000f]3e)\u0019\u0011\u0019p!\u0003\u0004 AA!Q\u001fB\u0000\u0007\u0007\ti.\u0004\u0002\u0003x*!!\u0011 B~\u0003%IW.\\;uC\ndWMC\u0002\u0003~b\f!bY8mY\u0016\u001cG/[8o\u0013\u0011\u0019\tAa>\u0003\u00075\u000b\u0007\u000f\u0005\u0003\u0002\u0018\u000e\u0015\u0011\u0002BB\u0004\u00033\u0013q!\u00138uK\u001e,'\u000fC\u0004\u0004\fM\u0001\ra!\u0004\u0002\r\rLG+\u001f9f!\u0011\u0019yaa\u0007\u000e\u0005\rE!\u0002BB\n\u0007+\tqA]3gY\u0016\u001cGOC\u0002\u001b\u0007/Q1a!\u0007 \u0003\u0019\u0001H.^4j]&!1QDB\t\u0005\u0011!\u0016\u0010]3\t\u000f\r\u00052\u00031\u0001\u0004$\u0005Aq-\u001a;MC\n,G\u000eE\u0004x\u0003\u0017\u001b)#!8\u0011\u0007%\u001b9#C\u0002\u0004*)\u00131eQ8oM&<WO]1uS>t\u0017\n^3n\t\u0006$\u0018mV5uQ&sG/\u001a:oC2LE-A\u0007mSN$H+\u001f9f!\u0006$\bn\u001d\u000b\t\u0003c\u0019yca\u000e\u0004:!91\u0011\u0007\u000bA\u0002\rM\u0012aC1sG\"Lg/\u001a3DSN\u0004\u0002\"a8\u00046\r\r\u00111\\\u0005\u0005\u0007\u0003\t\t\u0010C\u0004\u0004\"Q\u0001\raa\t\t\u000f\r-A\u00031\u0001\u0004\u000e\u0005\u0001B.[:u\u000b:4\u0018N]8o[\u0016tGo\u001d\u000b\u0003\u0003c\t\u0001\u0003\\5ti\u0006\u0003\b\u000f\\5dCRLwN\\:\u0002'\u0011|wO\u001c7pC\u0012\fU\u000fZ5u%\u0016\u0004xN\u001d;\u0015\u0005\u0005u\u0007fC\f\u0003V\u0005\u0005&\u0011\u000eB7\u0005_B3b\u0006B:\u0005{\u0012yHa!\u0003\u0006\"\u001a\u0001aa\u0013\u0011\t\r53\u0011L\u0007\u0003\u0007\u001fRAAa\u0017\u0004R)!11KB+\u0003\u001d1\u0017m\u0019;pefTAaa\u0016\u0003b\u0005)!-Z1og&!11LB(\u0005%\tU\u000f^8xSJ,G\rK\u0002\u0001\u0007?\u0002Ba!\u0019\u0004h5\u001111\r\u0006\u0005\u0007K\u0012\t'\u0001\u0006ti\u0016\u0014Xm\u001c;za\u0016LAa!\u001b\u0004d\tQ1i\u001c8ue>dG.\u001a:")
public class ReportServiceImpl
extends AbstractSecuredResource
implements ReportService,
Logging {
    private final ReportGenerator reportGenerator;
    private final PaginationService paginationService;
    private final CiRepository ciRepository;
    private final TaskArchive taskArchive;
    private final DownloadResource downloadResource;
    @Context
    private HttpResponse response;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        ReportServiceImpl reportServiceImpl = this;
        synchronized (reportServiceImpl) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        return !this.bitmap$trans$0 ? this.grizzled$slf4j$Logging$$_logger$lzycompute() : this.grizzled$slf4j$Logging$$_logger;
    }

    private HttpResponse response() {
        return this.response;
    }

    private void response_$eq(HttpResponse x$1) {
        this.response = x$1;
    }

    public void setResponse(HttpResponse response) {
        this.response_$eq(response);
    }

    private void setCiFilters(ArchivedTaskSearchParameters searchParameters, java.util.List<ConfigurationItemId> configurationItemIds) {
        Tuple2<List<String>, List<String>> tuple2 = TaskFilterUtils$.MODULE$.parseCiFilters((List<ConfigurationItemId>)((List)Option$.MODULE$.apply(configurationItemIds).toList().flatten((Function1 & Serializable & scala.Serializable)l -> ImplicitConversions$.MODULE$.list$u0020asScalaBuffer(l))));
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        List applications = (List)tuple2._1();
        List environments = (List)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)applications, (Object)environments);
        Tuple2 tuple23 = tuple22;
        List applications2 = (List)tuple23._1();
        List environments2 = (List)tuple23._2();
        applications2.foreach((Function1 & Serializable & scala.Serializable)x$1 -> searchParameters.forApplication(x$1));
        environments2.foreach((Function1 & Serializable & scala.Serializable)x$1 -> searchParameters.forEnvironment(x$1));
    }

    private <T> Stream<T> streamReport(Option<Paging> paging, Function1<Paging, ArchivedTaskSearchParameters> buildParams, Function1<ArchivedTaskSearchParameters, Stream<T>> stream) {
        Option limited = paging.map((Function1 & Serializable & scala.Serializable)input -> $this.paginationService.getLimitedPaging((Paging)input));
        ArchivedTaskSearchParameters searchParameters = (ArchivedTaskSearchParameters)buildParams.apply(limited.getOrElse((Function0 & Serializable & scala.Serializable)() -> new Paging()));
        limited.foreach((Function1 & Serializable & scala.Serializable)x$2 -> {
            this.paginationService.addPagingHeaderIfNeeded((Paging)paging.get(), x$2, this.paginationService.toSetHeader(this.response()), () -> Predef$.MODULE$.int2Integer($this.taskArchive.countTotalResults(searchParameters$2)));
            return BoxedUnit.UNIT;
        });
        return (Stream)stream.apply((Object)searchParameters);
    }

    private Stream<DeploymentTaskReportLine> streamDeploymentTaskReport(Date begin, Date end, Option<Paging> paging, java.util.List<com.xebialabs.deployit.engine.api.dto.Ordering> order, java.util.List<String> users, java.util.List<String> taskStates, java.util.List<String> taskTypes, FetchMode fetchMode, String taskId, boolean onlySuccessful, String workerName, java.util.List<ConfigurationItemId> configurationItemIds) {
        return this.streamReport(paging, (Function1<Paging, ArchivedTaskSearchParameters>)(Function1 & Serializable & scala.Serializable)limited -> {
            ArchivedTaskSearchParameters params = $this.reportGenerator.buildFilteredTaskSearchParameters(begin, end, (Paging)limited, order, null, users, taskStates, taskTypes, fetchMode, taskId, ImplicitConversions$.MODULE$.seq$u0020AsJavaList((Seq)Nil$.MODULE$), ReportGenerator.DEPLOYMENT_ALLOWED_SORT_FIELDS, onlySuccessful, workerName);
            this.setCiFilters(params, configurationItemIds);
            return params;
        }, (Function1 & Serializable & scala.Serializable)searchParameters -> $this.reportGenerator.streamTaskReport((ArchivedTaskSearchParameters)searchParameters));
    }

    public Stream<DeploymentTaskReportLine> getTaskReport(Date begin, Date end, Paging paging, java.util.List<com.xebialabs.deployit.engine.api.dto.Ordering> order, java.util.List<String> users, java.util.List<String> taskStates, java.util.List<String> taskTypes, FetchMode fetchMode, String taskId, boolean onlySuccessful, String workerName, java.util.List<ConfigurationItemId> configurationItemIds) {
        return this.streamDeploymentTaskReport(begin, end, (Option<Paging>)Option$.MODULE$.apply((Object)paging), order, users, taskStates, taskTypes, fetchMode, taskId, onlySuccessful, workerName, configurationItemIds);
    }

    @Workdir(prefix="download", clean=Workdir.Clean.ALWAYS)
    @Transactional(value="reportingTransactionManager", readOnly=true)
    public String downloadTaskReport(Date begin, Date end, java.util.List<com.xebialabs.deployit.engine.api.dto.Ordering> order, java.util.List<String> users, java.util.List<String> taskStates, java.util.List<String> taskTypes, String taskId, boolean onlySuccessful, String workerName, java.util.List<ConfigurationItemId> configurationItemIds) {
        Stream<ReportLine> stream = this.streamDeploymentTaskReport(begin, end, (Option<Paging>)None$.MODULE$, order, users, taskStates, taskTypes, FetchMode.SUMMARY, taskId, onlySuccessful, workerName, configurationItemIds).map(line -> DeploymentTaskReportLineConverter$.MODULE$.toReportLine((DeploymentTaskReportLine)line));
        String fileName = String.format("tasks-%s-%s.csv", ReportUtils.DATE_FORMAT.print((ReadableInstant)begin.asDateTime()), ReportUtils.DATE_FORMAT.print((ReadableInstant)end.asDateTime()));
        return ReportUtils.createDownloadToken(this.downloadResource, (Set)JavaConverters$.MODULE$.setAsJavaSetConverter(DeploymentReportLineField$.MODULE$.allFields()).asJava(), stream, fileName);
    }

    private Stream<ControlTaskReportLine> streamControlTaskReport(Date begin, Date end, java.util.List<String> states, String taskName, FetchMode fetchMode, java.util.List<String> users, java.util.List<com.xebialabs.deployit.engine.api.dto.Ordering> order, String workerName, Option<Paging> paging, Set<String> targets) {
        return this.streamReport(paging, (Function1<Paging, ArchivedTaskSearchParameters>)(Function1 & Serializable & scala.Serializable)limited -> {
            ArchivedTaskSearchParameters params = $this.reportGenerator.buildTaskSearchParameters((Paging)limited, order, EnumSet.of(TaskType.CONTROL), ReportGenerator.CONTROL_ALLOWED_SORT_FIELDS);
            params.withTargets(targets);
            params.withTaskStates(states);
            params.withTaskName(taskName);
            params.withFetchMode(fetchMode);
            params.withWorkerName(workerName);
            params.inDateTimeRange($this.reportGenerator.safeDateTime(begin, null), $this.reportGenerator.safeDateTime(end, null));
            Object object = users != null && ImplicitConversions$.MODULE$.list$u0020asScalaBuffer(users).nonEmpty() ? params.forUsers((Set)Sets.newHashSet((Iterable)users)) : BoxedUnit.UNIT;
            return params;
        }, (Function1 & Serializable & scala.Serializable)searchParameters -> $this.reportGenerator.streamControlTasksReport((ArchivedTaskSearchParameters)searchParameters));
    }

    public Stream<ControlTaskReportLine> getControlTasksReport(Date begin, Date end, java.util.List<String> states, String taskName, FetchMode fetchMode, java.util.List<String> users, java.util.List<com.xebialabs.deployit.engine.api.dto.Ordering> order, String workerName, Paging paging, Set<String> targets) {
        return this.streamControlTaskReport(begin, end, states, taskName, fetchMode, users, order, workerName, (Option<Paging>)Option$.MODULE$.apply((Object)paging), targets);
    }

    @Workdir(prefix="download", clean=Workdir.Clean.ALWAYS)
    @Transactional(value="reportingTransactionManager", readOnly=true)
    public String downloadControlTasksReport(Date begin, Date end, java.util.List<String> states, String taskName, java.util.List<String> users, java.util.List<com.xebialabs.deployit.engine.api.dto.Ordering> order, String workerName, Set<String> targets) {
        Stream<ReportLine> report = this.streamControlTaskReport(begin, end, states, taskName, FetchMode.SUMMARY, users, order, workerName, (Option<Paging>)None$.MODULE$, targets).map(line -> ControlTaskReportLineConverter$.MODULE$.toReportLine((ControlTaskReportLine)line));
        return ReportUtils.createDownloadToken(this.downloadResource, ImplicitConversions$.MODULE$.set$u0020AsJavaSet(ControlTaskReportLineField$.MODULE$.allFields()), report, this.reportGenerator.buildControlTaskReportFileName(begin, end));
    }

    private Map<Integer, String> listAllCisOfTypeGrouped(Type ciType, Function1<ConfigurationItemDataWithInternalId, String> getLabel) {
        SearchParameters params = SearchParametersFactory.createSearchParams((Type)ciType, (long)0L, (long)-1L);
        PlatformPermissions.READ.getPermissionHandler().applyPermission(params);
        return ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(this.ciRepository.listInternal(params)).asScala()).map((Function1 & Serializable & scala.Serializable)item -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)item.internalId()), getLabel.apply(item)), Buffer$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
    }

    private java.util.List<ConfigurationItemId> listTypePaths(Map<Integer, java.util.List<String>> archivedCis, Function1<ConfigurationItemDataWithInternalId, String> getLabel, Type ciType) {
        List list;
        this.checkPermission(PlatformPermissions.REPORT_VIEW);
        Map<Integer, String> cisInRepository = this.listAllCisOfTypeGrouped(ciType, getLabel);
        scala.collection.immutable.Set matchedIds = (scala.collection.immutable.Set)archivedCis.keySet().intersect((GenSet)cisInRepository.keySet());
        List onlyInArchive = ((TraversableOnce)archivedCis.flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Integer id = (Integer)tuple2._1();
            java.util.List paths = (java.util.List)tuple2._2();
            Nil$ nil$ = matchedIds.contains((Object)id) ? (Seq)ImplicitConversions$.MODULE$.list$u0020asScalaBuffer(paths).filter((Function1 & Serializable & scala.Serializable)path -> BoxesRunTime.boxToBoolean((boolean)ReportServiceImpl.$anonfun$listTypePaths$2(cisInRepository, id, path))) : Nil$.MODULE$;
            return nil$;
        }, Iterable$.MODULE$.canBuildFrom())).toList();
        List list2 = cisInRepository.values().toList();
        List inArchiveAndRepository = onlyInArchive.$colon$colon$colon(list2);
        if (this.hasPermission(PlatformPermissions.REPORT_VIEW)) {
            List list3 = inArchiveAndRepository;
            list = ((TraversableOnce)archivedCis.filterKeys((Function1 & Serializable & scala.Serializable)id -> BoxesRunTime.boxToBoolean((boolean)ReportServiceImpl.$anonfun$listTypePaths$3(cisInRepository, id))).values().flatten((Function1 & Serializable & scala.Serializable)l -> ImplicitConversions$.MODULE$.list$u0020asScalaBuffer(l))).toList().$colon$colon$colon(list3);
        } else {
            list = inArchiveAndRepository;
        }
        List result = list;
        return ImplicitConversions$.MODULE$.seq$u0020AsJavaList((Seq)((List)((SeqLike)result.distinct()).sorted((Ordering)Ordering.String$.MODULE$)).map((Function1 & Serializable & scala.Serializable)x$5 -> new ConfigurationItemId(x$5, ciType), List$.MODULE$.canBuildFrom()));
    }

    public java.util.List<ConfigurationItemId> listEnvironments() {
        return this.listTypePaths((Map<Integer, java.util.List<String>>)ImplicitConversions$.MODULE$.map$u0020AsScala(this.reportGenerator.getEnvironments()).toMap(Predef$.MODULE$.$conforms()), (Function1<ConfigurationItemDataWithInternalId, String>)(Function1 & Serializable & scala.Serializable)x$6 -> x$6.id(), Type.valueOf(Environment.class));
    }

    public java.util.List<ConfigurationItemId> listApplications() {
        return this.listTypePaths((Map<Integer, java.util.List<String>>)ImplicitConversions$.MODULE$.map$u0020AsScala(this.reportGenerator.getApplications()).toMap(Predef$.MODULE$.$conforms()), (Function1<ConfigurationItemDataWithInternalId, String>)(Function1 & Serializable & scala.Serializable)x$7 -> x$7.name(), Type.valueOf(Application.class));
    }

    @Workdir(prefix="download", clean=Workdir.Clean.ALWAYS)
    @Transactional(value="reportingTransactionManager", readOnly=true)
    public String downloadAuditReport() {
        return this.reportGenerator.generateAuditReport(this.downloadResource);
    }

    public static final /* synthetic */ boolean $anonfun$listTypePaths$2(Map cisInRepository$1, Integer id$1, String path) {
        Object object = cisInRepository$1.apply((Object)id$1);
        String string = path;
        return object == null ? string != null : !object.equals(string);
    }

    public static final /* synthetic */ boolean $anonfun$listTypePaths$3(Map cisInRepository$1, Integer id) {
        return !cisInRepository$1.keySet().contains((Object)id);
    }

    public ReportServiceImpl(ReportGenerator reportGenerator, PaginationService paginationService, CiRepository ciRepository, TaskArchive taskArchive, DownloadResource downloadResource) {
        this.reportGenerator = reportGenerator;
        this.paginationService = paginationService;
        this.ciRepository = ciRepository;
        this.taskArchive = taskArchive;
        this.downloadResource = downloadResource;
        Logging.$init$((Logging)this);
    }
}

