/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.core.service;

import com.google.common.base.Strings;
import com.google.common.collect.Sets;
import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.core.TypeConversions;
import com.xebialabs.deployit.core.api.resteasy.Date;
import com.xebialabs.deployit.core.rest.api.DownloadResource;
import com.xebialabs.deployit.core.rest.api.reports.ReportUtils;
import com.xebialabs.deployit.core.rest.secured.AbstractSecuredResource;
import com.xebialabs.deployit.core.util.TaskFilterUtils;
import com.xebialabs.deployit.engine.api.dto.ConfigurationItemId;
import com.xebialabs.deployit.engine.api.dto.ControlTaskReportLine;
import com.xebialabs.deployit.engine.api.dto.DeploymentTaskReportLine;
import com.xebialabs.deployit.engine.api.dto.Ordering;
import com.xebialabs.deployit.engine.api.dto.Paging;
import com.xebialabs.deployit.engine.api.execution.FetchMode;
import com.xebialabs.deployit.report.audit.AuditReportRepository;
import com.xebialabs.deployit.security.permission.DeployitPermissions;
import com.xebialabs.deployit.security.permission.PermissionHandler;
import com.xebialabs.deployit.security.permission.PermissionHelper;
import com.xebialabs.deployit.security.permission.PlatformPermissions;
import com.xebialabs.deployit.task.ArchivedTaskSearchParameters;
import com.xebialabs.deployit.task.FilterType;
import com.xebialabs.deployit.task.TaskType;
import com.xebialabs.deployit.task.archive.TaskArchive;
import com.xebialabs.deployit.task.archive.sql.CachingTaskReader;
import com.xebialabs.deployit.task.archive.sql.schema.ArchivedControlTasks;
import com.xebialabs.deployit.task.archive.sql.schema.ArchivedDeploymentTasks;
import com.xebialabs.deployit.task.archive.sql.schema.ArchivedTasks;
import com.xebialabs.deployit.task.archive.sql.schema.ArchivedTasksShared;
import java.io.Reader;
import java.io.StringReader;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ReportGenerator
extends AbstractSecuredResource {
    private TaskArchive taskArchive;
    private AuditReportRepository sqlAuditReportRepository;
    public static final Set<String> DEPLOYMENT_ALLOWED_SORT_FIELDS = new HashSet<String>(Arrays.asList("id", "failures", "owner", "state", "startDate", "completionDate", "application", "environment_id", "taskType"));
    public static final Set<String> CONTROL_ALLOWED_SORT_FIELDS = new HashSet<String>(Arrays.asList("id", "failures", "owner", "state", "startDate", "completionDate", "description", "controlTaskTargetCI", "taskName"));
    public static final EnumSet<TaskType> ALLOWED_TASK_TYPE_FILTER_VALUES = EnumSet.of(TaskType.INITIAL, new TaskType[]{TaskType.UPGRADE, TaskType.UNDEPLOY, TaskType.ROLLBACK, TaskType.INSPECTION, TaskType.CONTROL});

    @Autowired
    public ReportGenerator(TaskArchive taskArchive, AuditReportRepository sqlAuditReportRepository) {
        this.taskArchive = taskArchive;
        this.sqlAuditReportRepository = sqlAuditReportRepository;
    }

    public ArchivedTaskSearchParameters buildFilteredTaskSearchParameters(Date begin, Date end, Paging paging, List<Ordering> order, String filterType, List<String> users, List<String> taskStates, List<String> taskTypes, FetchMode fetchMode, String taskId, List<ConfigurationItemId> configurationItemIds, Set<String> allowedSortFields, boolean onlySuccessful, String workerName) {
        FilterType filter;
        Checks.checkNotNull((Object)begin, (String)"begin");
        Checks.checkNotNull((Object)end, (String)"end");
        EnumSet<TaskType> types = EnumSet.noneOf(TaskType.class);
        types.addAll(TaskFilterUtils.buildTaskTypesFilter(taskTypes, onlySuccessful));
        TaskFilterUtils.validateTaskTypesFilter(types, ALLOWED_TASK_TYPE_FILTER_VALUES);
        ArchivedTaskSearchParameters searchParameters = this.buildTaskSearchParameters(paging, order, types, allowedSortFields);
        searchParameters.createdBetween(begin.asDateTime(), end.asDateTime());
        searchParameters.forSuccessfulOnly(onlySuccessful);
        searchParameters.withFetchMode(fetchMode);
        searchParameters.withUniqueId(taskId);
        searchParameters.withWorkerName(workerName);
        if (filterType != null && (filter = FilterType.valueOf((String)filterType.toUpperCase())) != FilterType.NONE) {
            searchParameters.forFilterType(filter, configurationItemIds);
        }
        if (!users.isEmpty()) {
            searchParameters.forUsers((Set)Sets.newHashSet(users));
        }
        if (!taskStates.isEmpty()) {
            searchParameters.withTaskStates(taskStates);
        }
        if (!PermissionHelper.isCurrentUserAdmin()) {
            searchParameters.applySecurityParameters(PlatformPermissions.READ.getPermissionHandler().getRolesPermissionsPair());
        }
        return searchParameters;
    }

    public ArchivedTaskSearchParameters buildTaskSearchParameters(Paging paging, List<Ordering> order, EnumSet<TaskType> taskTypes, Set<String> allowedSortFields) {
        paging.validate();
        for (Ordering ordering : order) {
            ordering.validate(allowedSortFields);
        }
        ArchivedTaskSearchParameters searchParameters = new ArchivedTaskSearchParameters();
        searchParameters.thatAreOfType(taskTypes);
        if (order.isEmpty()) {
            searchParameters.orderBy("startDate", false);
        } else {
            for (Ordering ordering : order) {
                searchParameters.orderBy(ordering.field(), ordering.isAscending());
            }
        }
        if (!PermissionHelper.isCurrentUserAdmin()) {
            searchParameters.applySecurityParameters(PlatformPermissions.READ.getPermissionHandler().getRolesPermissionsPair());
        }
        searchParameters.showPage(paging.page(), paging.resultsPerPage());
        return searchParameters;
    }

    private Boolean controlTaskFilter(Map<String, Object> line) {
        PermissionHandler permissionHandler = DeployitPermissions.CONTROLTASK_EXECUTE.getPermissionHandler();
        String targetCI = (String)line.get("target_ci");
        return permissionHandler.isCurrentUserAdmin() || !Strings.isNullOrEmpty((String)targetCI) && permissionHandler.hasPermission(targetCI);
    }

    public Stream<DeploymentTaskReportLine> streamTaskReport(ArchivedTaskSearchParameters searchParameters) {
        this.checkPermission(DeployitPermissions.REPORT_VIEW);
        return this.taskArchive.searchForMaps(searchParameters, true).map(this::asDeploymentTaskReportLine);
    }

    public Stream<ControlTaskReportLine> streamControlTasksReport(ArchivedTaskSearchParameters searchParameters) {
        this.checkPermission(PlatformPermissions.REPORT_VIEW);
        return this.taskArchive.searchForMaps(searchParameters, true).filter(this::controlTaskFilter).map(this::asControlTaskReportLine);
    }

    public Map<Integer, List<String>> getEnvironments() {
        this.checkPermission(DeployitPermissions.REPORT_VIEW);
        return this.taskArchive.getAllArchivedEnvironmentsWithIds();
    }

    public Map<Integer, List<String>> getApplications() {
        this.checkPermission(DeployitPermissions.REPORT_VIEW);
        return this.taskArchive.getAllArchivedApplicationsWithIds();
    }

    private DeploymentTaskReportLine asDeploymentTaskReportLine(Map<String, Object> map) {
        DeploymentTaskReportLine line = new DeploymentTaskReportLine();
        line.setTaskId((String)map.get(ArchivedTasksShared.task_id().name()));
        line.setStartDate((DateTime)map.get(ArchivedTasksShared.start_date().name()));
        line.setCompletionDate((DateTime)map.get(ArchivedDeploymentTasks.end_date().name()));
        line.setStatus((String)map.get(ArchivedDeploymentTasks.status().name()));
        line.setTaskType(this.transformTaskType(TaskType.valueOf((String)((String)map.get(ArchivedDeploymentTasks.task_type().name())))));
        line.setUser((String)map.get(ArchivedDeploymentTasks.owner().name()));
        String environment = (String)map.get(ArchivedDeploymentTasks.environment().name());
        line.setEnvironment(environment.substring(environment.lastIndexOf(47) + 1));
        line.setEnvironmentId(environment);
        line.setEnvironmentIdWithoutRoot(environment.substring(environment.indexOf(47) + 1));
        line.setDeploymentPackage((String)map.get(ArchivedDeploymentTasks.packages().name()));
        line.setRolledBack(TypeConversions.enforceBoolean((Object)map.get(ArchivedDeploymentTasks.rolled_back().name())));
        if (map.containsKey(ArchivedTasks.task_details().name())) {
            CachingTaskReader reader = new CachingTaskReader((Reader)new StringReader((String)map.get(ArchivedTasks.task_details().name())));
            line.setBlock(reader.withoutSteps().getBlock());
        }
        line.setWorkerName((String)map.get(ArchivedTasks.worker_name().name()));
        return line;
    }

    private ControlTaskReportLine asControlTaskReportLine(Map<String, Object> map) {
        ControlTaskReportLine line = new ControlTaskReportLine();
        line.setTaskId((String)map.get(ArchivedControlTasks.task_id().name()));
        line.setStarted((DateTime)map.get(ArchivedControlTasks.start_date().name()));
        line.setFinished((DateTime)map.get(ArchivedControlTasks.end_date().name()));
        line.setState((String)map.get(ArchivedControlTasks.status().name()));
        line.setOwner((String)map.get(ArchivedControlTasks.owner().name()));
        line.setTaskName((String)map.get(ArchivedControlTasks.control_task_name().name()));
        line.setControlTaskTargetCI((String)map.get(ArchivedControlTasks.target_ci().name()));
        line.setDescription((String)map.get(ArchivedControlTasks.description().name()));
        if (map.containsKey(ArchivedTasks.task_details().name())) {
            CachingTaskReader reader = new CachingTaskReader((Reader)new StringReader((String)map.get(ArchivedTasks.task_details().name())));
            line.setBlock(reader.withoutSteps().getBlock());
        }
        line.setWorkerName((String)map.get(ArchivedTasks.worker_name().name()));
        return line;
    }

    public DateTime safeDateTime(Date date, DateTime defaultValue) {
        return date == null ? defaultValue : date.asDateTime();
    }

    public String buildControlTaskReportFileName(Date begin, Date end) {
        DateTime theBeginningOfTime = new DateTime(1, 1, 1, 0, 0, 0);
        DateTime beginDT = this.safeDateTime(begin, theBeginningOfTime);
        DateTime endDT = this.safeDateTime(end, new DateTime());
        return String.format("tasks-%s-%s.csv", ReportUtils.DATE_FORMAT.print((ReadableInstant)beginDT), ReportUtils.DATE_FORMAT.print((ReadableInstant)endDT));
    }

    private String transformTaskType(TaskType taskType) {
        switch (taskType) {
            case INITIAL: {
                return "Initial";
            }
            case UPGRADE: {
                return "Update";
            }
            case UNDEPLOY: {
                return "Undeployment";
            }
            case ROLLBACK: {
                return "Rollback";
            }
        }
        return "Unknown";
    }

    public String generateAuditReport(DownloadResource downloadResource) {
        this.checkPermission(PlatformPermissions.ADMIN);
        List globalAuditReport = this.sqlAuditReportRepository.getGlobalAuditReport();
        List folderAuditReport = this.sqlAuditReportRepository.getFolderAuditReport();
        return ReportUtils.createAuditReport(downloadResource, globalAuditReport, folderAuditReport);
    }
}

