/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.core.rest.api;

import com.google.common.collect.Sets;
import com.xebialabs.deployit.core.api.ReportService;
import com.xebialabs.deployit.core.api.dto.ControlTaskReportLine;
import com.xebialabs.deployit.core.api.dto.DeploymentTaskReportLine;
import com.xebialabs.deployit.core.api.dto.ReportLine;
import com.xebialabs.deployit.core.api.resteasy.Date;
import com.xebialabs.deployit.core.rest.api.DownloadResource;
import com.xebialabs.deployit.core.rest.api.SearchParametersFactory;
import com.xebialabs.deployit.core.rest.api.reports.ReportUtils;
import com.xebialabs.deployit.core.rest.resteasy.Workdir;
import com.xebialabs.deployit.core.rest.secured.AbstractSecuredResource;
import com.xebialabs.deployit.core.service.PaginationService;
import com.xebialabs.deployit.core.service.ReportGenerator;
import com.xebialabs.deployit.core.util.TaskFilterUtils$;
import com.xebialabs.deployit.engine.api.dto.ConfigurationItemId;
import com.xebialabs.deployit.engine.api.dto.Paging;
import com.xebialabs.deployit.engine.api.execution.FetchMode;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.Application;
import com.xebialabs.deployit.plugin.api.udm.Environment;
import com.xebialabs.deployit.repository.SearchParameters;
import com.xebialabs.deployit.repository.sql.CiRepository;
import com.xebialabs.deployit.repository.sql.ConfigurationItemDataWithInternalId;
import com.xebialabs.deployit.security.permission.PlatformPermissions;
import com.xebialabs.deployit.task.ArchivedTaskSearchParameters;
import com.xebialabs.deployit.task.TaskType;
import com.xebialabs.deployit.task.archive.TaskArchive;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import java.util.EnumSet;
import java.util.Set;
import java.util.stream.Stream;
import javax.ws.rs.core.Context;
import org.jboss.resteasy.spi.HttpResponse;
import org.joda.time.ReadableInstant;
import org.slf4j.Marker;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.transaction.annotation.Transactional;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenSet;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.convert.ImplicitConversions$;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer$;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@Controller
@Autowired
@ScalaSignature(bytes="\u0006\u0001\r]c\u0001B\f\u0019\u0001\u0015B\u0001\"\u000f\u0001\u0003\u0002\u0003\u0006IA\u000f\u0005\t\u0001\u0002\u0011\t\u0011)A\u0005\u0003\"AA\t\u0001B\u0001B\u0003%Q\t\u0003\u0005N\u0001\t\u0005\t\u0015!\u0003O\u0011!1\u0006A!A!\u0002\u00139\u0006\"B.\u0001\t\u0003a\u0006\"C2\u0001\u0001\u0004\u0005\r\u0011\"\u0003e\u0011%\t\b\u00011AA\u0002\u0013%!\u000fC\u0005|\u0001\u0001\u0007\t\u0011)Q\u0005K\"9\u0011\u0011\u0003\u0001\u0005\u0002\u0005M\u0001bBA\f\u0001\u0011%\u0011\u0011\u0004\u0005\b\u0003\u001b\u0002A\u0011BA(\u0011\u001d\tI\u000b\u0001C\u0005\u0003WCqA!\b\u0001\t\u0003\u0012y\u0002C\u0004\u00038\u0001!\tE!\u000f\t\u000f\t5\u0005\u0001\"\u0003\u0003\u0010\"9!q\u0017\u0001\u0005B\te\u0006b\u0002Bg\u0001\u0011\u0005#q\u001a\u0005\b\u0005G\u0004A\u0011\u0002Bs\u0011\u001d\u0019y\u0002\u0001C\u0005\u0007CAqaa\f\u0001\t\u0003\u001a\t\u0004C\u0004\u00044\u0001!\te!\r\u0003#I+\u0007o\u001c:u'\u0016\u0014h/[2f\u00136\u0004HN\u0003\u0002\u001a5\u0005\u0019\u0011\r]5\u000b\u0005ma\u0012\u0001\u0002:fgRT!!\b\u0010\u0002\t\r|'/\u001a\u0006\u0003?\u0001\n\u0001\u0002Z3qY>L\u0018\u000e\u001e\u0006\u0003C\t\n\u0011\u0002_3cS\u0006d\u0017MY:\u000b\u0003\r\n1aY8n\u0007\u0001\u0019B\u0001\u0001\u0014-cA\u0011qEK\u0007\u0002Q)\u0011\u0011FG\u0001\bg\u0016\u001cWO]3e\u0013\tY\u0003FA\fBEN$(/Y2u'\u0016\u001cWO]3e%\u0016\u001cx.\u001e:dKB\u0011QfL\u0007\u0002])\u0011\u0011\u0004H\u0005\u0003a9\u0012QBU3q_J$8+\u001a:wS\u000e,\u0007C\u0001\u001a8\u001b\u0005\u0019$B\u0001\u001b6\u0003\u0015\u0019HN\u001a\u001bk\u0015\u00051\u0014\u0001C4sSjTH.\u001a3\n\u0005a\u001a$a\u0002'pO\u001eLgnZ\u0001\u0010e\u0016\u0004xN\u001d;HK:,'/\u0019;peB\u00111HP\u0007\u0002y)\u0011Q\bH\u0001\bg\u0016\u0014h/[2f\u0013\tyDHA\bSKB|'\u000f^$f]\u0016\u0014\u0018\r^8s\u0003E\u0001\u0018mZ5oCRLwN\\*feZL7-\u001a\t\u0003w\tK!a\u0011\u001f\u0003#A\u000bw-\u001b8bi&|gnU3sm&\u001cW-\u0001\u0007dSJ+\u0007o\\:ji>\u0014\u0018\u0010\u0005\u0002G\u00176\tqI\u0003\u0002I\u0013\u0006\u00191/\u001d7\u000b\u0005)s\u0012A\u0003:fa>\u001c\u0018\u000e^8ss&\u0011Aj\u0012\u0002\r\u0007&\u0014V\r]8tSR|'/_\u0001\fi\u0006\u001c8.\u0011:dQ&4X\r\u0005\u0002P)6\t\u0001K\u0003\u0002R%\u00069\u0011M]2iSZ,'BA*\u001f\u0003\u0011!\u0018m]6\n\u0005U\u0003&a\u0003+bg.\f%o\u00195jm\u0016\f\u0001\u0003Z8x]2|\u0017\r\u001a*fg>,(oY3\u0011\u0005aKV\"\u0001\r\n\u0005iC\"\u0001\u0005#po:dw.\u00193SKN|WO]2f\u0003\u0019a\u0014N\\5u}Q1QLX0aC\n\u0004\"\u0001\u0017\u0001\t\u000be2\u0001\u0019\u0001\u001e\t\u000b\u00013\u0001\u0019A!\t\u000b\u00113\u0001\u0019A#\t\u000b53\u0001\u0019\u0001(\t\u000bY3\u0001\u0019A,\u0002\u0011I,7\u000f]8og\u0016,\u0012!\u001a\t\u0003M>l\u0011a\u001a\u0006\u0003Q&\f1a\u001d9j\u0015\tQ7.\u0001\u0005sKN$X-Y:z\u0015\taW.A\u0003kE>\u001c8OC\u0001o\u0003\ry'oZ\u0005\u0003a\u001e\u0014A\u0002\u0013;uaJ+7\u000f]8og\u0016\fAB]3ta>t7/Z0%KF$\"a]=\u0011\u0005Q<X\"A;\u000b\u0003Y\fQa]2bY\u0006L!\u0001_;\u0003\tUs\u0017\u000e\u001e\u0005\bu\"\t\t\u00111\u0001f\u0003\rAH%M\u0001\ne\u0016\u001c\bo\u001c8tK\u0002B#!C?\u0011\u0007y\fi!D\u0001\u0000\u0015\ri\u0012\u0011\u0001\u0006\u0005\u0003\u0007\t)!\u0001\u0002sg*!\u0011qAA\u0005\u0003\t98O\u0003\u0002\u0002\f\u0005)!.\u0019<bq&\u0019\u0011qB@\u0003\u000f\r{g\u000e^3yi\u0006Y1/\u001a;SKN\u0004xN\\:f)\r\u0019\u0018Q\u0003\u0005\u0006G*\u0001\r!Z\u0001\rg\u0016$8)\u001b$jYR,'o\u001d\u000b\u0006g\u0006m\u0011q\u0005\u0005\b\u0003;Y\u0001\u0019AA\u0010\u0003A\u0019X-\u0019:dQB\u000b'/Y7fi\u0016\u00148\u000f\u0005\u0003\u0002\"\u0005\rR\"\u0001*\n\u0007\u0005\u0015\"K\u0001\u000fBe\u000eD\u0017N^3e)\u0006\u001c8nU3be\u000eD\u0007+\u0019:b[\u0016$XM]:\t\u000f\u0005%2\u00021\u0001\u0002,\u0005!2m\u001c8gS\u001e,(/\u0019;j_:LE/Z7JIN\u0004b!!\f\u00028\u0005mRBAA\u0018\u0015\u0011\t\t$a\r\u0002\tU$\u0018\u000e\u001c\u0006\u0003\u0003k\tAA[1wC&!\u0011\u0011HA\u0018\u0005\u0011a\u0015n\u001d;\u0011\t\u0005u\u0012\u0011J\u0007\u0003\u0003\u007fQA!!\u0011\u0002D\u0005\u0019A\r^8\u000b\u0007e\t)EC\u0002\u0002Hy\ta!\u001a8hS:,\u0017\u0002BA&\u0003\u007f\u00111cQ8oM&<WO]1uS>t\u0017\n^3n\u0013\u0012\fAb\u001d;sK\u0006l'+\u001a9peR,B!!\u0015\u0002dQA\u00111KA;\u0003\u000b\u000by\t\u0005\u0004\u0002V\u0005m\u0013qL\u0007\u0003\u0003/RA!!\u0017\u00020\u000511\u000f\u001e:fC6LA!!\u0018\u0002X\t11\u000b\u001e:fC6\u0004B!!\u0019\u0002d1\u0001AaBA3\u0019\t\u0007\u0011q\r\u0002\u0002)F!\u0011\u0011NA8!\r!\u00181N\u0005\u0004\u0003[*(a\u0002(pi\"Lgn\u001a\t\u0004i\u0006E\u0014bAA:k\n\u0019\u0011I\\=\t\u000f\u0005]D\u00021\u0001\u0002z\u00051\u0001/Y4j]\u001e\u0004R\u0001^A>\u0003\u007fJ1!! v\u0005\u0019y\u0005\u000f^5p]B!\u0011QHAA\u0013\u0011\t\u0019)a\u0010\u0003\rA\u000bw-\u001b8h\u0011\u001d\t9\t\u0004a\u0001\u0003\u0013\u000b1BY;jY\u0012\u0004\u0016M]1ngB9A/a#\u0002\u0000\u0005}\u0011bAAGk\nIa)\u001e8di&|g.\r\u0005\b\u00033b\u0001\u0019AAI!\u001d!\u00181RA\u0010\u0003'Bs\u0001DAK\u0003C\u000b\u0019\u000b\u0005\u0003\u0002\u0018\u0006uUBAAM\u0015\u0011\tY*a\r\u0002\t1\fgnZ\u0005\u0005\u0003?\u000bIJ\u0001\tTkB\u0004(/Z:t/\u0006\u0014h.\u001b8hg\u0006)a/\u00197vK2\u0012\u0011QU\u0011\u0003\u0003O\u000b1!\u00197m\u0003i\u0019HO]3b[\u0012+\u0007\u000f\\8z[\u0016tG\u000fV1tWJ+\u0007o\u001c:u)a\ti+!/\u0002H\u0006-\u0017QZAm\u0003k\fI0!@\u0003\u000e\tE!1\u0004\t\u0007\u0003+\nY&a,\u0011\t\u0005E\u0016QW\u0007\u0003\u0003gS1!!\u0011/\u0013\u0011\t9,a-\u00031\u0011+\u0007\u000f\\8z[\u0016tG\u000fV1tWJ+\u0007o\u001c:u\u0019&tW\rC\u0004\u0002<6\u0001\r!!0\u0002\u000b\t,w-\u001b8\u0011\t\u0005}\u00161Y\u0007\u0003\u0003\u0003T!A\u001b\u0018\n\t\u0005\u0015\u0017\u0011\u0019\u0002\u0005\t\u0006$X\rC\u0004\u0002J6\u0001\r!!0\u0002\u0007\u0015tG\rC\u0004\u0002x5\u0001\r!!\u001f\t\u000f\u0005=W\u00021\u0001\u0002R\u0006)qN\u001d3feB1\u0011QFA\u001c\u0003'\u0004B!!\u0010\u0002V&!\u0011q[A \u0005!y%\u000fZ3sS:<\u0007bBAn\u001b\u0001\u0007\u0011Q\\\u0001\u0006kN,'o\u001d\t\u0007\u0003[\t9$a8\u0011\t\u0005\u0005\u0018q\u001e\b\u0005\u0003G\fY\u000fE\u0002\u0002fVl!!a:\u000b\u0007\u0005%H%\u0001\u0004=e>|GOP\u0005\u0004\u0003[,\u0018A\u0002)sK\u0012,g-\u0003\u0003\u0002r\u0006M(AB*ue&twMC\u0002\u0002nVDq!a>\u000e\u0001\u0004\ti.\u0001\u0006uCN\\7\u000b^1uKNDq!a?\u000e\u0001\u0004\ti.A\u0005uCN\\G+\u001f9fg\"9\u0011q`\u0007A\u0002\t\u0005\u0011!\u00034fi\u000eDWj\u001c3f!\u0011\u0011\u0019A!\u0003\u000e\u0005\t\u0015!\u0002\u0002B\u0004\u0003\u0007\n\u0011\"\u001a=fGV$\u0018n\u001c8\n\t\t-!Q\u0001\u0002\n\r\u0016$8\r['pI\u0016DqAa\u0004\u000e\u0001\u0004\ty.\u0001\u0004uCN\\\u0017\n\u001a\u0005\b\u0005'i\u0001\u0019\u0001B\u000b\u00039yg\u000e\\=Tk\u000e\u001cWm]:gk2\u00042\u0001\u001eB\f\u0013\r\u0011I\"\u001e\u0002\b\u0005>|G.Z1o\u0011\u001d\tI#\u0004a\u0001\u0003W\tQbZ3u)\u0006\u001c8NU3q_J$H\u0003GAW\u0005C\u0011\u0019C!\n\u0003(\t%\"1\u0006B\u0017\u0005_\u0011\tDa\r\u00036!9\u00111\u0018\bA\u0002\u0005u\u0006bBAe\u001d\u0001\u0007\u0011Q\u0018\u0005\b\u0003or\u0001\u0019AA@\u0011\u001d\tyM\u0004a\u0001\u0003#Dq!a7\u000f\u0001\u0004\ti\u000eC\u0004\u0002x:\u0001\r!!8\t\u000f\u0005mh\u00021\u0001\u0002^\"9\u0011q \bA\u0002\t\u0005\u0001b\u0002B\b\u001d\u0001\u0007\u0011q\u001c\u0005\b\u0005'q\u0001\u0019\u0001B\u000b\u0011\u001d\tIC\u0004a\u0001\u0003W\t!\u0003Z8x]2|\u0017\r\u001a+bg.\u0014V\r]8siR!\u0012q\u001cB\u001e\u0005{\u0011yD!\u0011\u0003D\t\u0015#q\tB%\u0005\u0017Bq!a/\u0010\u0001\u0004\ti\fC\u0004\u0002J>\u0001\r!!0\t\u000f\u0005=w\u00021\u0001\u0002R\"9\u00111\\\bA\u0002\u0005u\u0007bBA|\u001f\u0001\u0007\u0011Q\u001c\u0005\b\u0003w|\u0001\u0019AAo\u0011\u001d\u0011ya\u0004a\u0001\u0003?DqAa\u0005\u0010\u0001\u0004\u0011)\u0002C\u0004\u0002*=\u0001\r!a\u000b)\u0017=\u0011y%!)\u0003d\t\u001d$\u0011\u000e\t\u0005\u0005#\u0012y&\u0004\u0002\u0003T)!!Q\u000bB,\u0003)\tgN\\8uCRLwN\u001c\u0006\u0005\u00053\u0012Y&A\u0006ue\u0006t7/Y2uS>t'b\u0001B/[\u0006y1\u000f\u001d:j]\u001e4'/Y7fo>\u00148.\u0003\u0003\u0003b\tM#!\u0004+sC:\u001c\u0018m\u0019;j_:\fG.\t\u0002\u0003f\u0005Y\"/\u001a9peRLgn\u001a+sC:\u001c\u0018m\u0019;j_:l\u0015M\\1hKJ\f\u0001B]3bI>sG._\r\u0002\u0003!ZqB!\u001c\u0003x\te$Q\u0010B@!\u0011\u0011yGa\u001d\u000e\u0005\tE$B\u00016\u001b\u0013\u0011\u0011)H!\u001d\u0003\u000f]{'o\u001b3je\u00061\u0001O]3gSb\f#Aa\u001f\u0002\u0011\u0011|wO\u001c7pC\u0012\fQa\u00197fC:$#A!!\n\t\t\r%QQ\u0001\u0007\u00032;\u0016)W*\u000b\t\t\u001d%\u0011R\u0001\u0006\u00072,\u0017M\u001c\u0006\u0005\u0005\u0017\u0013\t(A\u0004X_J\\G-\u001b:\u0002/M$(/Z1n\u0007>tGO]8m)\u0006\u001c8NU3q_J$H\u0003\u0006BI\u00053\u0013YJ!(\u0003\"\n\u0015&q\u0015BU\u0005W\u0013i\u000b\u0005\u0004\u0002V\u0005m#1\u0013\t\u0005\u0003c\u0013)*\u0003\u0003\u0003\u0018\u0006M&!F\"p]R\u0014x\u000e\u001c+bg.\u0014V\r]8si2Kg.\u001a\u0005\b\u0003w\u0003\u0002\u0019AA_\u0011\u001d\tI\r\u0005a\u0001\u0003{CqAa(\u0011\u0001\u0004\ti.\u0001\u0004ti\u0006$Xm\u001d\u0005\b\u0005G\u0003\u0002\u0019AAp\u0003!!\u0018m]6OC6,\u0007bBA\u0000!\u0001\u0007!\u0011\u0001\u0005\b\u00037\u0004\u0002\u0019AAo\u0011\u001d\ty\r\u0005a\u0001\u0003#Dq!a\u001e\u0011\u0001\u0004\tI\bC\u0004\u00030B\u0001\rA!-\u0002\u000fQ\f'oZ3ugB1\u0011Q\u0006BZ\u0003?LAA!.\u00020\t\u00191+\u001a;\u0002+\u001d,GoQ8oiJ|G\u000eV1tWN\u0014V\r]8siR!\"\u0011\u0013B^\u0005{\u0013yL!1\u0003D\n\u0015'q\u0019Be\u0005\u0017Dq!a/\u0012\u0001\u0004\ti\fC\u0004\u0002JF\u0001\r!!0\t\u000f\t}\u0015\u00031\u0001\u0002^\"9!1U\tA\u0002\u0005}\u0007bBA\u0000#\u0001\u0007!\u0011\u0001\u0005\b\u00037\f\u0002\u0019AAo\u0011\u001d\ty-\u0005a\u0001\u0003#Dq!a\u001e\u0012\u0001\u0004\ty\bC\u0004\u00030F\u0001\rA!-\u00025\u0011|wO\u001c7pC\u0012\u001cuN\u001c;s_2$\u0016m]6t%\u0016\u0004xN\u001d;\u0015!\u0005}'\u0011\u001bBj\u0005+\u00149N!7\u0003\\\nu\u0007bBA^%\u0001\u0007\u0011Q\u0018\u0005\b\u0003\u0013\u0014\u0002\u0019AA_\u0011\u001d\u0011yJ\u0005a\u0001\u0003;DqAa)\u0013\u0001\u0004\ty\u000eC\u0004\u0002\\J\u0001\r!!8\t\u000f\u0005='\u00031\u0001\u0002R\"9!q\u0016\nA\u0002\tE\u0006f\u0003\n\u0003P\u0005\u0005&1\rB4\u0005SB3B\u0005B7\u0005o\u0012IH! \u0003\u0000\u00059B.[:u\u00032d7)[:PMRK\b/Z$s_V\u0004X\r\u001a\u000b\u0007\u0005O\u0014ipa\u0005\u0011\u0011\t%(1\u001fB|\u0003?l!Aa;\u000b\t\t5(q^\u0001\nS6lW\u000f^1cY\u0016T1A!=v\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0005k\u0014YOA\u0002NCB\u0004B!a&\u0003z&!!1`AM\u0005\u001dIe\u000e^3hKJDqAa@\u0014\u0001\u0004\u0019\t!\u0001\u0004dSRK\b/\u001a\t\u0005\u0007\u0007\u0019y!\u0004\u0002\u0004\u0006)!1qAB\u0005\u0003\u001d\u0011XM\u001a7fGRT1!GB\u0006\u0015\r\u0019iAH\u0001\u0007a2,x-\u001b8\n\t\rE1Q\u0001\u0002\u0005)f\u0004X\rC\u0004\u0004\u0016M\u0001\raa\u0006\u0002\u0011\u001d,G\u000fT1cK2\u0004r\u0001^AF\u00073\ty\u000eE\u0002G\u00077I1a!\bH\u0005\r\u001auN\u001c4jOV\u0014\u0018\r^5p]&#X-\u001c#bi\u0006<\u0016\u000e\u001e5J]R,'O\\1m\u0013\u0012\fQ\u0002\\5tiRK\b/\u001a)bi\"\u001cH\u0003CA\u0016\u0007G\u0019Yc!\f\t\u000f\r\u0015B\u00031\u0001\u0004(\u0005Y\u0011M]2iSZ,GmQ5t!!\t\to!\u000b\u0003x\u0006u\u0017\u0002\u0002B{\u0003gDqa!\u0006\u0015\u0001\u0004\u00199\u0002C\u0004\u0003\u0000R\u0001\ra!\u0001\u0002!1L7\u000f^#om&\u0014xN\\7f]R\u001cHCAA\u0016\u0003Aa\u0017n\u001d;BaBd\u0017nY1uS>t7\u000fK\u0002\u0001\u0007o\u0001Ba!\u000f\u0004F5\u001111\b\u0006\u0005\u0005+\u001aiD\u0003\u0003\u0004@\r\u0005\u0013a\u00024bGR|'/\u001f\u0006\u0005\u0007\u0007\u0012Y&A\u0003cK\u0006t7/\u0003\u0003\u0004H\rm\"!C!vi><\u0018N]3eQ\r\u000111\n\t\u0005\u0007\u001b\u001a\u0019&\u0004\u0002\u0004P)!1\u0011\u000bB.\u0003)\u0019H/\u001a:f_RL\b/Z\u0005\u0005\u0007+\u001ayE\u0001\u0006D_:$(o\u001c7mKJ\u0004")
public class ReportServiceImpl
extends AbstractSecuredResource
implements ReportService,
Logging {
    private final ReportGenerator reportGenerator;
    private final PaginationService paginationService;
    private final CiRepository ciRepository;
    private final TaskArchive taskArchive;
    private final DownloadResource downloadResource;
    @Context
    private HttpResponse response;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        ReportServiceImpl reportServiceImpl = this;
        synchronized (reportServiceImpl) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        return !this.bitmap$trans$0 ? this.grizzled$slf4j$Logging$$_logger$lzycompute() : this.grizzled$slf4j$Logging$$_logger;
    }

    private HttpResponse response() {
        return this.response;
    }

    private void response_$eq(HttpResponse x$1) {
        this.response = x$1;
    }

    public void setResponse(HttpResponse response) {
        this.response_$eq(response);
    }

    private void setCiFilters(ArchivedTaskSearchParameters searchParameters, java.util.List<ConfigurationItemId> configurationItemIds) {
        Tuple2<List<String>, List<String>> tuple2 = TaskFilterUtils$.MODULE$.parseCiFilters((List<ConfigurationItemId>)((List)Option$.MODULE$.apply(configurationItemIds).toList().flatten((Function1 & Serializable & scala.Serializable)l -> ImplicitConversions$.MODULE$.list$u0020asScalaBuffer(l))));
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        List applications = (List)tuple2._1();
        List environments = (List)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)applications, (Object)environments);
        Tuple2 tuple23 = tuple22;
        List applications2 = (List)tuple23._1();
        List environments2 = (List)tuple23._2();
        applications2.foreach((Function1 & Serializable & scala.Serializable)x$1 -> searchParameters.forApplication(x$1));
        environments2.foreach((Function1 & Serializable & scala.Serializable)x$1 -> searchParameters.forEnvironment(x$1));
    }

    private <T> Stream<T> streamReport(Option<Paging> paging, Function1<Paging, ArchivedTaskSearchParameters> buildParams, Function1<ArchivedTaskSearchParameters, Stream<T>> stream) {
        Option limited = paging.map((Function1 & Serializable & scala.Serializable)input -> $this.paginationService.getLimitedPaging((Paging)input));
        ArchivedTaskSearchParameters searchParameters = (ArchivedTaskSearchParameters)buildParams.apply(limited.getOrElse((Function0 & Serializable & scala.Serializable)() -> new Paging()));
        limited.foreach((Function1 & Serializable & scala.Serializable)x$2 -> {
            this.paginationService.addPagingHeaderIfNeeded((Paging)paging.get(), x$2, this.paginationService.toSetHeader(this.response()), () -> Predef$.MODULE$.int2Integer($this.taskArchive.countTotalResults(searchParameters$2)));
            return BoxedUnit.UNIT;
        });
        return (Stream)stream.apply((Object)searchParameters);
    }

    private Stream<DeploymentTaskReportLine> streamDeploymentTaskReport(Date begin, Date end, Option<Paging> paging, java.util.List<com.xebialabs.deployit.engine.api.dto.Ordering> order, java.util.List<String> users, java.util.List<String> taskStates, java.util.List<String> taskTypes, FetchMode fetchMode, String taskId, boolean onlySuccessful, java.util.List<ConfigurationItemId> configurationItemIds) {
        return this.streamReport(paging, (Function1<Paging, ArchivedTaskSearchParameters>)(Function1 & Serializable & scala.Serializable)limited -> {
            ArchivedTaskSearchParameters params = $this.reportGenerator.buildFilteredTaskSearchParameters(begin, end, (Paging)limited, order, null, users, taskStates, taskTypes, fetchMode, taskId, ImplicitConversions$.MODULE$.seq$u0020AsJavaList((Seq)Nil$.MODULE$), ReportGenerator.DEPLOYMENT_ALLOWED_SORT_FIELDS, onlySuccessful);
            this.setCiFilters(params, configurationItemIds);
            return params;
        }, (Function1 & Serializable & scala.Serializable)searchParameters -> $this.reportGenerator.streamTaskReport((ArchivedTaskSearchParameters)searchParameters));
    }

    public Stream<DeploymentTaskReportLine> getTaskReport(Date begin, Date end, Paging paging, java.util.List<com.xebialabs.deployit.engine.api.dto.Ordering> order, java.util.List<String> users, java.util.List<String> taskStates, java.util.List<String> taskTypes, FetchMode fetchMode, String taskId, boolean onlySuccessful, java.util.List<ConfigurationItemId> configurationItemIds) {
        return this.streamDeploymentTaskReport(begin, end, (Option<Paging>)Option$.MODULE$.apply((Object)paging), order, users, taskStates, taskTypes, fetchMode, taskId, onlySuccessful, configurationItemIds);
    }

    @Workdir(prefix="download", clean=Workdir.Clean.ALWAYS)
    @Transactional(value="reportingTransactionManager", readOnly=true)
    public String downloadTaskReport(Date begin, Date end, java.util.List<com.xebialabs.deployit.engine.api.dto.Ordering> order, java.util.List<String> users, java.util.List<String> taskStates, java.util.List<String> taskTypes, String taskId, boolean onlySuccessful, java.util.List<ConfigurationItemId> configurationItemIds) {
        Stream<ReportLine> stream = this.streamDeploymentTaskReport(begin, end, (Option<Paging>)None$.MODULE$, order, users, taskStates, taskTypes, FetchMode.SUMMARY, taskId, onlySuccessful, configurationItemIds).map(x$1 -> DeploymentTaskReportLine.asReportLine((DeploymentTaskReportLine)x$1));
        String fileName = String.format("tasks-%s-%s.csv", ReportUtils.DATE_FORMAT.print((ReadableInstant)begin.asDateTime()), ReportUtils.DATE_FORMAT.print((ReadableInstant)end.asDateTime()));
        return ReportUtils.createDownloadToken(this.downloadResource, stream, fileName);
    }

    private Stream<ControlTaskReportLine> streamControlTaskReport(Date begin, Date end, java.util.List<String> states, String taskName, FetchMode fetchMode, java.util.List<String> users, java.util.List<com.xebialabs.deployit.engine.api.dto.Ordering> order, Option<Paging> paging, Set<String> targets) {
        return this.streamReport(paging, (Function1<Paging, ArchivedTaskSearchParameters>)(Function1 & Serializable & scala.Serializable)limited -> {
            ArchivedTaskSearchParameters params = $this.reportGenerator.buildTaskSearchParameters((Paging)limited, order, EnumSet.of(TaskType.CONTROL), ReportGenerator.CONTROL_ALLOWED_SORT_FIELDS);
            params.withTargets(targets);
            params.withTaskStates(states);
            params.withTaskName(taskName);
            params.withFetchMode(fetchMode);
            params.inDateTimeRange($this.reportGenerator.safeDateTime(begin, null), $this.reportGenerator.safeDateTime(end, null));
            Object object = users != null && ImplicitConversions$.MODULE$.list$u0020asScalaBuffer(users).nonEmpty() ? params.forUsers((Set)Sets.newHashSet((Iterable)users)) : BoxedUnit.UNIT;
            return params;
        }, (Function1 & Serializable & scala.Serializable)searchParameters -> $this.reportGenerator.streamControlTasksReport((ArchivedTaskSearchParameters)searchParameters));
    }

    public Stream<ControlTaskReportLine> getControlTasksReport(Date begin, Date end, java.util.List<String> states, String taskName, FetchMode fetchMode, java.util.List<String> users, java.util.List<com.xebialabs.deployit.engine.api.dto.Ordering> order, Paging paging, Set<String> targets) {
        return this.streamControlTaskReport(begin, end, states, taskName, fetchMode, users, order, (Option<Paging>)Option$.MODULE$.apply((Object)paging), targets);
    }

    @Workdir(prefix="download", clean=Workdir.Clean.ALWAYS)
    @Transactional(value="reportingTransactionManager", readOnly=true)
    public String downloadControlTasksReport(Date begin, Date end, java.util.List<String> states, String taskName, java.util.List<String> users, java.util.List<com.xebialabs.deployit.engine.api.dto.Ordering> order, Set<String> targets) {
        Stream<ReportLine> report = this.streamControlTaskReport(begin, end, states, taskName, FetchMode.SUMMARY, users, order, (Option<Paging>)None$.MODULE$, targets).map(x$1 -> ControlTaskReportLine.asReportLine((ControlTaskReportLine)x$1));
        return ReportUtils.createDownloadToken(this.downloadResource, report, this.reportGenerator.buildControlTaskReportFileName(begin, end));
    }

    private Map<Integer, String> listAllCisOfTypeGrouped(Type ciType, Function1<ConfigurationItemDataWithInternalId, String> getLabel) {
        SearchParameters params = SearchParametersFactory.createSearchParams((Type)ciType, (long)0L, (long)-1L);
        PlatformPermissions.READ.getPermissionHandler().applyPermission(params);
        return ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(this.ciRepository.listInternal(params)).asScala()).map((Function1 & Serializable & scala.Serializable)item -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)item.internalId()), getLabel.apply(item)), Buffer$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
    }

    private java.util.List<ConfigurationItemId> listTypePaths(Map<Integer, java.util.List<String>> archivedCis, Function1<ConfigurationItemDataWithInternalId, String> getLabel, Type ciType) {
        List list;
        this.checkPermission(PlatformPermissions.REPORT_VIEW);
        Map<Integer, String> cisInRepository = this.listAllCisOfTypeGrouped(ciType, getLabel);
        scala.collection.immutable.Set matchedIds = (scala.collection.immutable.Set)archivedCis.keySet().intersect((GenSet)cisInRepository.keySet());
        List onlyInArchive = ((TraversableOnce)archivedCis.flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Integer id = (Integer)tuple2._1();
            java.util.List paths = (java.util.List)tuple2._2();
            Nil$ nil$ = matchedIds.contains((Object)id) ? (Seq)ImplicitConversions$.MODULE$.list$u0020asScalaBuffer(paths).filter((Function1 & Serializable & scala.Serializable)path -> BoxesRunTime.boxToBoolean((boolean)ReportServiceImpl.$anonfun$listTypePaths$2(cisInRepository, id, path))) : Nil$.MODULE$;
            return nil$;
        }, Iterable$.MODULE$.canBuildFrom())).toList();
        List list2 = cisInRepository.values().toList();
        List inArchiveAndRepository = onlyInArchive.$colon$colon$colon(list2);
        if (this.hasPermission(PlatformPermissions.ADMIN)) {
            List list3 = inArchiveAndRepository;
            list = ((TraversableOnce)archivedCis.filterKeys((Function1 & Serializable & scala.Serializable)id -> BoxesRunTime.boxToBoolean((boolean)ReportServiceImpl.$anonfun$listTypePaths$3(cisInRepository, id))).values().flatten((Function1 & Serializable & scala.Serializable)l -> ImplicitConversions$.MODULE$.list$u0020asScalaBuffer(l))).toList().$colon$colon$colon(list3);
        } else {
            list = inArchiveAndRepository;
        }
        List result = list;
        return ImplicitConversions$.MODULE$.seq$u0020AsJavaList((Seq)((List)((SeqLike)result.distinct()).sorted((Ordering)Ordering.String$.MODULE$)).map((Function1 & Serializable & scala.Serializable)x$5 -> new ConfigurationItemId(x$5, ciType), List$.MODULE$.canBuildFrom()));
    }

    public java.util.List<ConfigurationItemId> listEnvironments() {
        return this.listTypePaths((Map<Integer, java.util.List<String>>)ImplicitConversions$.MODULE$.map$u0020AsScala(this.reportGenerator.getEnvironments()).toMap(Predef$.MODULE$.$conforms()), (Function1<ConfigurationItemDataWithInternalId, String>)(Function1 & Serializable & scala.Serializable)x$6 -> x$6.id(), Type.valueOf(Environment.class));
    }

    public java.util.List<ConfigurationItemId> listApplications() {
        return this.listTypePaths((Map<Integer, java.util.List<String>>)ImplicitConversions$.MODULE$.map$u0020AsScala(this.reportGenerator.getApplications()).toMap(Predef$.MODULE$.$conforms()), (Function1<ConfigurationItemDataWithInternalId, String>)(Function1 & Serializable & scala.Serializable)x$7 -> x$7.name(), Type.valueOf(Application.class));
    }

    public static final /* synthetic */ boolean $anonfun$listTypePaths$2(Map cisInRepository$1, Integer id$1, String path) {
        Object object = cisInRepository$1.apply((Object)id$1);
        String string = path;
        return object == null ? string != null : !object.equals(string);
    }

    public static final /* synthetic */ boolean $anonfun$listTypePaths$3(Map cisInRepository$1, Integer id) {
        return !cisInRepository$1.keySet().contains((Object)id);
    }

    public ReportServiceImpl(ReportGenerator reportGenerator, PaginationService paginationService, CiRepository ciRepository, TaskArchive taskArchive, DownloadResource downloadResource) {
        this.reportGenerator = reportGenerator;
        this.paginationService = paginationService;
        this.ciRepository = ciRepository;
        this.taskArchive = taskArchive;
        this.downloadResource = downloadResource;
        Logging.$init$((Logging)this);
    }
}

