/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.core.service;

import com.xebialabs.deployit.core.config.XldConfig;
import com.xebialabs.deployit.engine.api.dto.Paging;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import javax.ws.rs.core.MultivaluedMap;
import org.jboss.resteasy.spi.HttpResponse;
import org.jboss.resteasy.spi.ResteasyProviderFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PaginationService {
    private static final Logger log = LoggerFactory.getLogger(PaginationService.class);
    private XldConfig config;

    @Autowired
    public PaginationService(XldConfig config) {
        this.config = config;
    }

    public Paging getLimitedPaging(Paging input) {
        if (input.resultsPerPage() <= 0 || input.resultsPerPage() > this.config.restApi().maxPageSize()) {
            return new Paging(input.page(), this.config.restApi().maxPageSize());
        }
        return input;
    }

    public void addPagingHeaderIfNeeded(BiConsumer<String, Object> setHeader, Supplier<Integer> countTotalResults, Paging paging) {
        Paging limited = this.getLimitedPaging(paging);
        this.addPagingHeaderIfNeeded(paging, limited, setHeader, countTotalResults);
    }

    public void addPagingHeaderIfNeeded(Paging paging, Paging limited, BiConsumer<String, Object> setHeader, Supplier<Integer> countTotalResults) {
        if (limited.resultsPerPage() > 0) {
            int count = countTotalResults.get();
            if (paging.resultsPerPage() <= 0 && count > limited.resultsPerPage()) {
                log.warn("Limiting total number of results {} to maximum {}", (Object)count, (Object)limited.resultsPerPage());
            }
            setHeader.accept(Paging.X_TOTAL_COUNT_HEADER(), count);
        }
    }

    public BiConsumer<String, Object> toSetHeader(HttpResponse response) {
        if (ResteasyProviderFactory.getContextData(HttpResponse.class) != null) {
            return (arg_0, arg_1) -> ((MultivaluedMap)response.getOutputHeaders()).putSingle(arg_0, arg_1);
        }
        return new IgnoreNoHttpResponseContext();
    }

    private static class IgnoreNoHttpResponseContext
    implements BiConsumer<String, Object> {
        private IgnoreNoHttpResponseContext() {
        }

        @Override
        public void accept(String s, Object o) {
        }
    }
}

