/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.core.rest.api;

import com.google.common.collect.Sets;
import com.xebialabs.deployit.core.api.dto.ReportLine;
import com.xebialabs.deployit.core.api.resteasy.Date;
import com.xebialabs.deployit.core.converters.ControlTaskReportLineConverter$;
import com.xebialabs.deployit.core.converters.DeploymentTaskReportLineConverter$;
import com.xebialabs.deployit.core.rest.api.DownloadResource;
import com.xebialabs.deployit.core.rest.api.SearchParametersFactory;
import com.xebialabs.deployit.core.rest.api.reports.ReportUtils;
import com.xebialabs.deployit.core.rest.resteasy.Workdir;
import com.xebialabs.deployit.core.rest.secured.AbstractSecuredResource;
import com.xebialabs.deployit.core.service.PaginationService;
import com.xebialabs.deployit.core.service.ReportGenerator;
import com.xebialabs.deployit.core.util.TaskFilterUtils$;
import com.xebialabs.deployit.engine.api.ReportService;
import com.xebialabs.deployit.engine.api.dto.ConfigurationItemId;
import com.xebialabs.deployit.engine.api.dto.ControlTaskReportLine;
import com.xebialabs.deployit.engine.api.dto.DeploymentTaskReportLine;
import com.xebialabs.deployit.engine.api.dto.Paging;
import com.xebialabs.deployit.engine.api.execution.FetchMode;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.Application;
import com.xebialabs.deployit.plugin.api.udm.Environment;
import com.xebialabs.deployit.repository.SearchParameters;
import com.xebialabs.deployit.repository.sql.CiRepository;
import com.xebialabs.deployit.repository.sql.ConfigurationItemDataWithInternalId;
import com.xebialabs.deployit.security.permission.PlatformPermissions;
import com.xebialabs.deployit.task.ArchivedTaskSearchParameters;
import com.xebialabs.deployit.task.TaskType;
import com.xebialabs.deployit.task.archive.TaskArchive;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import java.util.EnumSet;
import java.util.Set;
import java.util.stream.Stream;
import javax.ws.rs.core.Context;
import org.jboss.resteasy.spi.HttpResponse;
import org.joda.time.ReadableInstant;
import org.slf4j.Marker;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.transaction.annotation.Transactional;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenSet;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.convert.ImplicitConversions$;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer$;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@Controller
@Autowired
@ScalaSignature(bytes="\u0006\u0001\rMc\u0001B\f\u0019\u0001\u0015B\u0001b\u000f\u0001\u0003\u0002\u0003\u0006I\u0001\u0010\u0005\t\u0005\u0002\u0011\t\u0011)A\u0005\u0007\"Aa\t\u0001B\u0001B\u0003%q\t\u0003\u0005P\u0001\t\u0005\t\u0015!\u0003Q\u0011!A\u0006A!A!\u0002\u0013I\u0006\"B/\u0001\t\u0003q\u0006\"C3\u0001\u0001\u0004\u0005\r\u0011\"\u0003g\u0011%\u0019\b\u00011AA\u0002\u0013%A\u000fC\u0005~\u0001\u0001\u0007\t\u0011)Q\u0005O\"9\u0011Q\u0003\u0001\u0005\u0002\u0005]\u0001bBA\u000e\u0001\u0011%\u0011Q\u0004\u0005\b\u0003\u0017\u0002A\u0011BA'\u0011\u001d\t9\u000b\u0001C\u0005\u0003SCqA!\u0007\u0001\t\u0003\u0012Y\u0002C\u0004\u00034\u0001!\tE!\u000e\t\u000f\t%\u0005\u0001\"\u0003\u0003\f\"9!1\u0017\u0001\u0005B\tU\u0006b\u0002Be\u0001\u0011\u0005#1\u001a\u0005\b\u0005?\u0004A\u0011\u0002Bq\u0011\u001d\u0019Y\u0002\u0001C\u0005\u0007;Aqaa\u000b\u0001\t\u0003\u001ai\u0003C\u0004\u00040\u0001!\te!\f\u0003#I+\u0007o\u001c:u'\u0016\u0014h/[2f\u00136\u0004HN\u0003\u0002\u001a5\u0005\u0019\u0011\r]5\u000b\u0005ma\u0012\u0001\u0002:fgRT!!\b\u0010\u0002\t\r|'/\u001a\u0006\u0003?\u0001\n\u0001\u0002Z3qY>L\u0018\u000e\u001e\u0006\u0003C\t\n\u0011\u0002_3cS\u0006d\u0017MY:\u000b\u0003\r\n1aY8n\u0007\u0001\u0019B\u0001\u0001\u0014-gA\u0011qEK\u0007\u0002Q)\u0011\u0011FG\u0001\bg\u0016\u001cWO]3e\u0013\tY\u0003FA\fBEN$(/Y2u'\u0016\u001cWO]3e%\u0016\u001cx.\u001e:dKB\u0011Q&M\u0007\u0002])\u0011\u0011d\f\u0006\u0003ay\ta!\u001a8hS:,\u0017B\u0001\u001a/\u00055\u0011V\r]8siN+'O^5dKB\u0011A'O\u0007\u0002k)\u0011agN\u0001\u0006g24GG\u001b\u0006\u0002q\u0005AqM]5{u2,G-\u0003\u0002;k\t9Aj\\4hS:<\u0017a\u0004:fa>\u0014HoR3oKJ\fGo\u001c:\u0011\u0005u\u0002U\"\u0001 \u000b\u0005}b\u0012aB:feZL7-Z\u0005\u0003\u0003z\u0012qBU3q_J$x)\u001a8fe\u0006$xN]\u0001\u0012a\u0006<\u0017N\\1uS>t7+\u001a:wS\u000e,\u0007CA\u001fE\u0013\t)eHA\tQC\u001eLg.\u0019;j_:\u001cVM\u001d<jG\u0016\fAbY5SKB|7/\u001b;pef\u0004\"\u0001S'\u000e\u0003%S!AS&\u0002\u0007M\fHN\u0003\u0002M=\u0005Q!/\u001a9pg&$xN]=\n\u00059K%\u0001D\"j%\u0016\u0004xn]5u_JL\u0018a\u0003;bg.\f%o\u00195jm\u0016\u0004\"!\u0015,\u000e\u0003IS!a\u0015+\u0002\u000f\u0005\u00148\r[5wK*\u0011QKH\u0001\u0005i\u0006\u001c8.\u0003\u0002X%\nYA+Y:l\u0003J\u001c\u0007.\u001b<f\u0003A!wn\u001e8m_\u0006$'+Z:pkJ\u001cW\r\u0005\u0002[76\t\u0001$\u0003\u0002]1\t\u0001Bi\\<oY>\fGMU3t_V\u00148-Z\u0001\u0007y%t\u0017\u000e\u001e \u0015\r}\u0003\u0017MY2e!\tQ\u0006\u0001C\u0003<\r\u0001\u0007A\bC\u0003C\r\u0001\u00071\tC\u0003G\r\u0001\u0007q\tC\u0003P\r\u0001\u0007\u0001\u000bC\u0003Y\r\u0001\u0007\u0011,\u0001\u0005sKN\u0004xN\\:f+\u00059\u0007C\u00015r\u001b\u0005I'B\u00016l\u0003\r\u0019\b/\u001b\u0006\u0003Y6\f\u0001B]3ti\u0016\f7/\u001f\u0006\u0003]>\fQA\u001b2pgNT\u0011\u0001]\u0001\u0004_J<\u0017B\u0001:j\u00051AE\u000f\u001e9SKN\u0004xN\\:f\u00031\u0011Xm\u001d9p]N,w\fJ3r)\t)8\u0010\u0005\u0002ws6\tqOC\u0001y\u0003\u0015\u00198-\u00197b\u0013\tQxO\u0001\u0003V]&$\bb\u0002?\t\u0003\u0003\u0005\raZ\u0001\u0004q\u0012\n\u0014!\u0003:fgB|gn]3!Q\tIq\u0010\u0005\u0003\u0002\u0002\u0005EQBAA\u0002\u0015\ri\u0012Q\u0001\u0006\u0005\u0003\u000f\tI!\u0001\u0002sg*!\u00111BA\u0007\u0003\t98O\u0003\u0002\u0002\u0010\u0005)!.\u0019<bq&!\u00111CA\u0002\u0005\u001d\u0019uN\u001c;fqR\f1b]3u%\u0016\u001c\bo\u001c8tKR\u0019Q/!\u0007\t\u000b\u0015T\u0001\u0019A4\u0002\u0019M,GoQ5GS2$XM]:\u0015\u000bU\fy\"a\u000b\t\u000f\u0005\u00052\u00021\u0001\u0002$\u0005\u00012/Z1sG\"\u0004\u0016M]1nKR,'o\u001d\t\u0005\u0003K\t9#D\u0001U\u0013\r\tI\u0003\u0016\u0002\u001d\u0003J\u001c\u0007.\u001b<fIR\u000b7o[*fCJ\u001c\u0007\u000eU1sC6,G/\u001a:t\u0011\u001d\tic\u0003a\u0001\u0003_\tAcY8oM&<WO]1uS>t\u0017\n^3n\u0013\u0012\u001c\bCBA\u0019\u0003w\ty$\u0004\u0002\u00024)!\u0011QGA\u001c\u0003\u0011)H/\u001b7\u000b\u0005\u0005e\u0012\u0001\u00026bm\u0006LA!!\u0010\u00024\t!A*[:u!\u0011\t\t%a\u0012\u000e\u0005\u0005\r#bAA#]\u0005\u0019A\r^8\n\t\u0005%\u00131\t\u0002\u0014\u0007>tg-[4ve\u0006$\u0018n\u001c8Ji\u0016l\u0017\nZ\u0001\rgR\u0014X-Y7SKB|'\u000f^\u000b\u0005\u0003\u001f\n\t\u0007\u0006\u0005\u0002R\u0005M\u00141QAG!\u0019\t\u0019&!\u0017\u0002^5\u0011\u0011Q\u000b\u0006\u0005\u0003/\n\u0019$\u0001\u0004tiJ,\u0017-\\\u0005\u0005\u00037\n)F\u0001\u0004TiJ,\u0017-\u001c\t\u0005\u0003?\n\t\u0007\u0004\u0001\u0005\u000f\u0005\rDB1\u0001\u0002f\t\tA+\u0005\u0003\u0002h\u00055\u0004c\u0001<\u0002j%\u0019\u00111N<\u0003\u000f9{G\u000f[5oOB\u0019a/a\u001c\n\u0007\u0005EtOA\u0002B]fDq!!\u001e\r\u0001\u0004\t9(\u0001\u0004qC\u001eLgn\u001a\t\u0006m\u0006e\u0014QP\u0005\u0004\u0003w:(AB(qi&|g\u000e\u0005\u0003\u0002B\u0005}\u0014\u0002BAA\u0003\u0007\u0012a\u0001U1hS:<\u0007bBAC\u0019\u0001\u0007\u0011qQ\u0001\fEVLG\u000e\u001a)be\u0006l7\u000fE\u0004w\u0003\u0013\u000bi(a\t\n\u0007\u0005-uOA\u0005Gk:\u001cG/[8oc!9\u0011q\u000b\u0007A\u0002\u0005=\u0005c\u0002<\u0002\n\u0006\r\u0012\u0011\u000b\u0015\b\u0019\u0005M\u0015qTAQ!\u0011\t)*a'\u000e\u0005\u0005]%\u0002BAM\u0003o\tA\u0001\\1oO&!\u0011QTAL\u0005A\u0019V\u000f\u001d9sKN\u001cx+\u0019:oS:<7/A\u0003wC2,X\r\f\u0002\u0002$\u0006\u0012\u0011QU\u0001\u0004C2d\u0017AG:ue\u0016\fW\u000eR3qY>LX.\u001a8u)\u0006\u001c8NU3q_J$H\u0003GAV\u0003g\u000b\u0019-a2\u0002J\u0006U\u0017\u0011_A{\u0003s\u0014IA!\u0004\u0003\u0018A1\u00111KA-\u0003[\u0003B!!\u0011\u00020&!\u0011\u0011WA\"\u0005a!U\r\u001d7ps6,g\u000e\u001e+bg.\u0014V\r]8si2Kg.\u001a\u0005\b\u0003kk\u0001\u0019AA\\\u0003\u0015\u0011WmZ5o!\u0011\tI,a0\u000e\u0005\u0005m&b\u00017\u0002>*\u0011\u0011\u0004H\u0005\u0005\u0003\u0003\fYL\u0001\u0003ECR,\u0007bBAc\u001b\u0001\u0007\u0011qW\u0001\u0004K:$\u0007bBA;\u001b\u0001\u0007\u0011q\u000f\u0005\b\u0003\u0017l\u0001\u0019AAg\u0003\u0015y'\u000fZ3s!\u0019\t\t$a\u000f\u0002PB!\u0011\u0011IAi\u0013\u0011\t\u0019.a\u0011\u0003\u0011=\u0013H-\u001a:j]\u001eDq!a6\u000e\u0001\u0004\tI.A\u0003vg\u0016\u00148\u000f\u0005\u0004\u00022\u0005m\u00121\u001c\t\u0005\u0003;\fYO\u0004\u0003\u0002`\u0006\u001d\bcAAqo6\u0011\u00111\u001d\u0006\u0004\u0003K$\u0013A\u0002\u001fs_>$h(C\u0002\u0002j^\fa\u0001\u0015:fI\u00164\u0017\u0002BAw\u0003_\u0014aa\u0015;sS:<'bAAuo\"9\u00111_\u0007A\u0002\u0005e\u0017A\u0003;bg.\u001cF/\u0019;fg\"9\u0011q_\u0007A\u0002\u0005e\u0017!\u0003;bg.$\u0016\u0010]3t\u0011\u001d\tY0\u0004a\u0001\u0003{\f\u0011BZ3uG\"lu\u000eZ3\u0011\t\u0005}(QA\u0007\u0003\u0005\u0003Q1Aa\u0001/\u0003%)\u00070Z2vi&|g.\u0003\u0003\u0003\b\t\u0005!!\u0003$fi\u000eDWj\u001c3f\u0011\u001d\u0011Y!\u0004a\u0001\u00037\fa\u0001^1tW&#\u0007b\u0002B\b\u001b\u0001\u0007!\u0011C\u0001\u000f_:d\u0017pU;dG\u0016\u001c8OZ;m!\r1(1C\u0005\u0004\u0005+9(a\u0002\"p_2,\u0017M\u001c\u0005\b\u0003[i\u0001\u0019AA\u0018\u000359W\r\u001e+bg.\u0014V\r]8siRA\u00121\u0016B\u000f\u0005?\u0011\tCa\t\u0003&\t\u001d\"\u0011\u0006B\u0016\u0005[\u0011yC!\r\t\u000f\u0005Uf\u00021\u0001\u00028\"9\u0011Q\u0019\bA\u0002\u0005]\u0006bBA;\u001d\u0001\u0007\u0011Q\u0010\u0005\b\u0003\u0017t\u0001\u0019AAg\u0011\u001d\t9N\u0004a\u0001\u00033Dq!a=\u000f\u0001\u0004\tI\u000eC\u0004\u0002x:\u0001\r!!7\t\u000f\u0005mh\u00021\u0001\u0002~\"9!1\u0002\bA\u0002\u0005m\u0007b\u0002B\b\u001d\u0001\u0007!\u0011\u0003\u0005\b\u0003[q\u0001\u0019AA\u0018\u0003I!wn\u001e8m_\u0006$G+Y:l%\u0016\u0004xN\u001d;\u0015)\u0005m'q\u0007B\u001d\u0005w\u0011iDa\u0010\u0003B\t\r#Q\tB$\u0011\u001d\t)l\u0004a\u0001\u0003oCq!!2\u0010\u0001\u0004\t9\fC\u0004\u0002L>\u0001\r!!4\t\u000f\u0005]w\u00021\u0001\u0002Z\"9\u00111_\bA\u0002\u0005e\u0007bBA|\u001f\u0001\u0007\u0011\u0011\u001c\u0005\b\u0005\u0017y\u0001\u0019AAn\u0011\u001d\u0011ya\u0004a\u0001\u0005#Aq!!\f\u0010\u0001\u0004\ty\u0003K\u0006\u0010\u0005\u0017\nyJa\u0018\u0003d\t\u0015\u0004\u0003\u0002B'\u00057j!Aa\u0014\u000b\t\tE#1K\u0001\u000bC:tw\u000e^1uS>t'\u0002\u0002B+\u0005/\n1\u0002\u001e:b]N\f7\r^5p]*\u0019!\u0011L8\u0002\u001fM\u0004(/\u001b8hMJ\fW.Z<pe.LAA!\u0018\u0003P\tiAK]1og\u0006\u001cG/[8oC2\f#A!\u0019\u00027I,\u0007o\u001c:uS:<GK]1og\u0006\u001cG/[8o\u001b\u0006t\u0017mZ3s\u0003!\u0011X-\u00193P]2L\u0018$A\u0001)\u0017=\u0011IGa\u001d\u0003v\te$1\u0010\t\u0005\u0005W\u0012y'\u0004\u0002\u0003n)\u0011ANG\u0005\u0005\u0005c\u0012iGA\u0004X_J\\G-\u001b:\u0002\rA\u0014XMZ5yC\t\u00119(\u0001\u0005e_^tGn\\1e\u0003\u0015\u0019G.Z1oI\t\u0011i(\u0003\u0003\u0003\u0000\t\u0005\u0015AB!M/\u0006K6K\u0003\u0003\u0003\u0004\n\u0015\u0015!B\"mK\u0006t'\u0002\u0002BD\u0005[\nqaV8sW\u0012L'/A\ftiJ,\u0017-\\\"p]R\u0014x\u000e\u001c+bg.\u0014V\r]8siR!\"Q\u0012BK\u0005/\u0013IJ!(\u0003\"\n\r&Q\u0015BT\u0005S\u0003b!a\u0015\u0002Z\t=\u0005\u0003BA!\u0005#KAAa%\u0002D\t)2i\u001c8ue>dG+Y:l%\u0016\u0004xN\u001d;MS:,\u0007bBA[!\u0001\u0007\u0011q\u0017\u0005\b\u0003\u000b\u0004\u0002\u0019AA\\\u0011\u001d\u0011Y\n\u0005a\u0001\u00033\faa\u001d;bi\u0016\u001c\bb\u0002BP!\u0001\u0007\u00111\\\u0001\ti\u0006\u001c8NT1nK\"9\u00111 \tA\u0002\u0005u\bbBAl!\u0001\u0007\u0011\u0011\u001c\u0005\b\u0003\u0017\u0004\u0002\u0019AAg\u0011\u001d\t)\b\u0005a\u0001\u0003oBqAa+\u0011\u0001\u0004\u0011i+A\u0004uCJ<W\r^:\u0011\r\u0005E\"qVAn\u0013\u0011\u0011\t,a\r\u0003\u0007M+G/A\u000bhKR\u001cuN\u001c;s_2$\u0016m]6t%\u0016\u0004xN\u001d;\u0015)\t5%q\u0017B]\u0005w\u0013iLa0\u0003B\n\r'Q\u0019Bd\u0011\u001d\t),\u0005a\u0001\u0003oCq!!2\u0012\u0001\u0004\t9\fC\u0004\u0003\u001cF\u0001\r!!7\t\u000f\t}\u0015\u00031\u0001\u0002\\\"9\u00111`\tA\u0002\u0005u\bbBAl#\u0001\u0007\u0011\u0011\u001c\u0005\b\u0003\u0017\f\u0002\u0019AAg\u0011\u001d\t)(\u0005a\u0001\u0003{BqAa+\u0012\u0001\u0004\u0011i+\u0001\u000ee_^tGn\\1e\u0007>tGO]8m)\u0006\u001c8n\u001d*fa>\u0014H\u000f\u0006\t\u0002\\\n5'q\u001aBi\u0005'\u0014)Na6\u0003Z\"9\u0011Q\u0017\nA\u0002\u0005]\u0006bBAc%\u0001\u0007\u0011q\u0017\u0005\b\u00057\u0013\u0002\u0019AAm\u0011\u001d\u0011yJ\u0005a\u0001\u00037Dq!a6\u0013\u0001\u0004\tI\u000eC\u0004\u0002LJ\u0001\r!!4\t\u000f\t-&\u00031\u0001\u0003.\"Z!Ca\u0013\u0002 \n}#1\rB3Q-\u0011\"\u0011\u000eB:\u0005k\u0012IHa\u001f\u0002/1L7\u000f^!mY\u000eK7o\u00144UsB,wI]8va\u0016$GC\u0002Br\u0005s\u001cy\u0001\u0005\u0005\u0003f\n=(1_An\u001b\t\u00119O\u0003\u0003\u0003j\n-\u0018!C5n[V$\u0018M\u00197f\u0015\r\u0011io^\u0001\u000bG>dG.Z2uS>t\u0017\u0002\u0002By\u0005O\u00141!T1q!\u0011\t)J!>\n\t\t]\u0018q\u0013\u0002\b\u0013:$XmZ3s\u0011\u001d\u0011Yp\u0005a\u0001\u0005{\faaY5UsB,\u0007\u0003\u0002B\u0000\u0007\u0017i!a!\u0001\u000b\t\r\r1QA\u0001\be\u00164G.Z2u\u0015\rI2q\u0001\u0006\u0004\u0007\u0013q\u0012A\u00029mk\u001eLg.\u0003\u0003\u0004\u000e\r\u0005!\u0001\u0002+za\u0016Dqa!\u0005\u0014\u0001\u0004\u0019\u0019\"\u0001\u0005hKRd\u0015MY3m!\u001d1\u0018\u0011RB\u000b\u00037\u00042\u0001SB\f\u0013\r\u0019I\"\u0013\u0002$\u0007>tg-[4ve\u0006$\u0018n\u001c8Ji\u0016lG)\u0019;b/&$\b.\u00138uKJt\u0017\r\\%e\u00035a\u0017n\u001d;UsB,\u0007+\u0019;igRA\u0011qFB\u0010\u0007O\u0019I\u0003C\u0004\u0004\"Q\u0001\raa\t\u0002\u0017\u0005\u00148\r[5wK\u0012\u001c\u0015n\u001d\t\t\u0003;\u001c)Ca=\u0002Z&!!\u0011_Ax\u0011\u001d\u0019\t\u0002\u0006a\u0001\u0007'AqAa?\u0015\u0001\u0004\u0011i0\u0001\tmSN$XI\u001c<je>tW.\u001a8ugR\u0011\u0011qF\u0001\u0011Y&\u001cH/\u00119qY&\u001c\u0017\r^5p]ND3\u0001AB\u001a!\u0011\u0019)d!\u0011\u000e\u0005\r]\"\u0002\u0002B)\u0007sQAaa\u000f\u0004>\u00059a-Y2u_JL(\u0002BB \u0005/\nQAY3b]NLAaa\u0011\u00048\tI\u0011)\u001e;po&\u0014X\r\u001a\u0015\u0004\u0001\r\u001d\u0003\u0003BB%\u0007\u001fj!aa\u0013\u000b\t\r5#qK\u0001\u000bgR,'/Z8usB,\u0017\u0002BB)\u0007\u0017\u0012!bQ8oiJ|G\u000e\\3s\u0001")
public class ReportServiceImpl
extends AbstractSecuredResource
implements ReportService,
Logging {
    private final ReportGenerator reportGenerator;
    private final PaginationService paginationService;
    private final CiRepository ciRepository;
    private final TaskArchive taskArchive;
    private final DownloadResource downloadResource;
    @Context
    private HttpResponse response;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        ReportServiceImpl reportServiceImpl = this;
        synchronized (reportServiceImpl) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        return !this.bitmap$trans$0 ? this.grizzled$slf4j$Logging$$_logger$lzycompute() : this.grizzled$slf4j$Logging$$_logger;
    }

    private HttpResponse response() {
        return this.response;
    }

    private void response_$eq(HttpResponse x$1) {
        this.response = x$1;
    }

    public void setResponse(HttpResponse response) {
        this.response_$eq(response);
    }

    private void setCiFilters(ArchivedTaskSearchParameters searchParameters, java.util.List<ConfigurationItemId> configurationItemIds) {
        Tuple2<List<String>, List<String>> tuple2 = TaskFilterUtils$.MODULE$.parseCiFilters((List<ConfigurationItemId>)((List)Option$.MODULE$.apply(configurationItemIds).toList().flatten((Function1 & Serializable & scala.Serializable)l -> ImplicitConversions$.MODULE$.list$u0020asScalaBuffer(l))));
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        List applications = (List)tuple2._1();
        List environments = (List)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)applications, (Object)environments);
        Tuple2 tuple23 = tuple22;
        List applications2 = (List)tuple23._1();
        List environments2 = (List)tuple23._2();
        applications2.foreach((Function1 & Serializable & scala.Serializable)x$1 -> searchParameters.forApplication(x$1));
        environments2.foreach((Function1 & Serializable & scala.Serializable)x$1 -> searchParameters.forEnvironment(x$1));
    }

    private <T> Stream<T> streamReport(Option<Paging> paging, Function1<Paging, ArchivedTaskSearchParameters> buildParams, Function1<ArchivedTaskSearchParameters, Stream<T>> stream) {
        Option limited = paging.map((Function1 & Serializable & scala.Serializable)input -> $this.paginationService.getLimitedPaging((Paging)input));
        ArchivedTaskSearchParameters searchParameters = (ArchivedTaskSearchParameters)buildParams.apply(limited.getOrElse((Function0 & Serializable & scala.Serializable)() -> new Paging()));
        limited.foreach((Function1 & Serializable & scala.Serializable)x$2 -> {
            this.paginationService.addPagingHeaderIfNeeded((Paging)paging.get(), x$2, this.paginationService.toSetHeader(this.response()), () -> Predef$.MODULE$.int2Integer($this.taskArchive.countTotalResults(searchParameters$2)));
            return BoxedUnit.UNIT;
        });
        return (Stream)stream.apply((Object)searchParameters);
    }

    private Stream<DeploymentTaskReportLine> streamDeploymentTaskReport(Date begin, Date end, Option<Paging> paging, java.util.List<com.xebialabs.deployit.engine.api.dto.Ordering> order, java.util.List<String> users, java.util.List<String> taskStates, java.util.List<String> taskTypes, FetchMode fetchMode, String taskId, boolean onlySuccessful, java.util.List<ConfigurationItemId> configurationItemIds) {
        return this.streamReport(paging, (Function1<Paging, ArchivedTaskSearchParameters>)(Function1 & Serializable & scala.Serializable)limited -> {
            ArchivedTaskSearchParameters params = $this.reportGenerator.buildFilteredTaskSearchParameters(begin, end, (Paging)limited, order, null, users, taskStates, taskTypes, fetchMode, taskId, ImplicitConversions$.MODULE$.seq$u0020AsJavaList((Seq)Nil$.MODULE$), ReportGenerator.DEPLOYMENT_ALLOWED_SORT_FIELDS, onlySuccessful);
            this.setCiFilters(params, configurationItemIds);
            return params;
        }, (Function1 & Serializable & scala.Serializable)searchParameters -> $this.reportGenerator.streamTaskReport((ArchivedTaskSearchParameters)searchParameters));
    }

    public Stream<DeploymentTaskReportLine> getTaskReport(Date begin, Date end, Paging paging, java.util.List<com.xebialabs.deployit.engine.api.dto.Ordering> order, java.util.List<String> users, java.util.List<String> taskStates, java.util.List<String> taskTypes, FetchMode fetchMode, String taskId, boolean onlySuccessful, java.util.List<ConfigurationItemId> configurationItemIds) {
        return this.streamDeploymentTaskReport(begin, end, (Option<Paging>)Option$.MODULE$.apply((Object)paging), order, users, taskStates, taskTypes, fetchMode, taskId, onlySuccessful, configurationItemIds);
    }

    @Workdir(prefix="download", clean=Workdir.Clean.ALWAYS)
    @Transactional(value="reportingTransactionManager", readOnly=true)
    public String downloadTaskReport(Date begin, Date end, java.util.List<com.xebialabs.deployit.engine.api.dto.Ordering> order, java.util.List<String> users, java.util.List<String> taskStates, java.util.List<String> taskTypes, String taskId, boolean onlySuccessful, java.util.List<ConfigurationItemId> configurationItemIds) {
        Stream<ReportLine> stream = this.streamDeploymentTaskReport(begin, end, (Option<Paging>)None$.MODULE$, order, users, taskStates, taskTypes, FetchMode.SUMMARY, taskId, onlySuccessful, configurationItemIds).map(line -> DeploymentTaskReportLineConverter$.MODULE$.toReportLine((DeploymentTaskReportLine)line));
        String fileName = String.format("tasks-%s-%s.csv", ReportUtils.DATE_FORMAT.print((ReadableInstant)begin.asDateTime()), ReportUtils.DATE_FORMAT.print((ReadableInstant)end.asDateTime()));
        return ReportUtils.createDownloadToken(this.downloadResource, stream, fileName);
    }

    private Stream<ControlTaskReportLine> streamControlTaskReport(Date begin, Date end, java.util.List<String> states, String taskName, FetchMode fetchMode, java.util.List<String> users, java.util.List<com.xebialabs.deployit.engine.api.dto.Ordering> order, Option<Paging> paging, Set<String> targets) {
        return this.streamReport(paging, (Function1<Paging, ArchivedTaskSearchParameters>)(Function1 & Serializable & scala.Serializable)limited -> {
            ArchivedTaskSearchParameters params = $this.reportGenerator.buildTaskSearchParameters((Paging)limited, order, EnumSet.of(TaskType.CONTROL), ReportGenerator.CONTROL_ALLOWED_SORT_FIELDS);
            params.withTargets(targets);
            params.withTaskStates(states);
            params.withTaskName(taskName);
            params.withFetchMode(fetchMode);
            params.inDateTimeRange($this.reportGenerator.safeDateTime(begin, null), $this.reportGenerator.safeDateTime(end, null));
            Object object = users != null && ImplicitConversions$.MODULE$.list$u0020asScalaBuffer(users).nonEmpty() ? params.forUsers((Set)Sets.newHashSet((Iterable)users)) : BoxedUnit.UNIT;
            return params;
        }, (Function1 & Serializable & scala.Serializable)searchParameters -> $this.reportGenerator.streamControlTasksReport((ArchivedTaskSearchParameters)searchParameters));
    }

    public Stream<ControlTaskReportLine> getControlTasksReport(Date begin, Date end, java.util.List<String> states, String taskName, FetchMode fetchMode, java.util.List<String> users, java.util.List<com.xebialabs.deployit.engine.api.dto.Ordering> order, Paging paging, Set<String> targets) {
        return this.streamControlTaskReport(begin, end, states, taskName, fetchMode, users, order, (Option<Paging>)Option$.MODULE$.apply((Object)paging), targets);
    }

    @Workdir(prefix="download", clean=Workdir.Clean.ALWAYS)
    @Transactional(value="reportingTransactionManager", readOnly=true)
    public String downloadControlTasksReport(Date begin, Date end, java.util.List<String> states, String taskName, java.util.List<String> users, java.util.List<com.xebialabs.deployit.engine.api.dto.Ordering> order, Set<String> targets) {
        Stream<ReportLine> report = this.streamControlTaskReport(begin, end, states, taskName, FetchMode.SUMMARY, users, order, (Option<Paging>)None$.MODULE$, targets).map(line -> ControlTaskReportLineConverter$.MODULE$.toReportLine((ControlTaskReportLine)line));
        return ReportUtils.createDownloadToken(this.downloadResource, report, this.reportGenerator.buildControlTaskReportFileName(begin, end));
    }

    private Map<Integer, String> listAllCisOfTypeGrouped(Type ciType, Function1<ConfigurationItemDataWithInternalId, String> getLabel) {
        SearchParameters params = SearchParametersFactory.createSearchParams((Type)ciType, (long)0L, (long)-1L);
        PlatformPermissions.READ.getPermissionHandler().applyPermission(params);
        return ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(this.ciRepository.listInternal(params)).asScala()).map((Function1 & Serializable & scala.Serializable)item -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)item.internalId()), getLabel.apply(item)), Buffer$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
    }

    private java.util.List<ConfigurationItemId> listTypePaths(Map<Integer, java.util.List<String>> archivedCis, Function1<ConfigurationItemDataWithInternalId, String> getLabel, Type ciType) {
        List list;
        this.checkPermission(PlatformPermissions.REPORT_VIEW);
        Map<Integer, String> cisInRepository = this.listAllCisOfTypeGrouped(ciType, getLabel);
        scala.collection.immutable.Set matchedIds = (scala.collection.immutable.Set)archivedCis.keySet().intersect((GenSet)cisInRepository.keySet());
        List onlyInArchive = ((TraversableOnce)archivedCis.flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Integer id = (Integer)tuple2._1();
            java.util.List paths = (java.util.List)tuple2._2();
            Nil$ nil$ = matchedIds.contains((Object)id) ? (Seq)ImplicitConversions$.MODULE$.list$u0020asScalaBuffer(paths).filter((Function1 & Serializable & scala.Serializable)path -> BoxesRunTime.boxToBoolean((boolean)ReportServiceImpl.$anonfun$listTypePaths$2(cisInRepository, id, path))) : Nil$.MODULE$;
            return nil$;
        }, Iterable$.MODULE$.canBuildFrom())).toList();
        List list2 = cisInRepository.values().toList();
        List inArchiveAndRepository = onlyInArchive.$colon$colon$colon(list2);
        if (this.hasPermission(PlatformPermissions.ADMIN)) {
            List list3 = inArchiveAndRepository;
            list = ((TraversableOnce)archivedCis.filterKeys((Function1 & Serializable & scala.Serializable)id -> BoxesRunTime.boxToBoolean((boolean)ReportServiceImpl.$anonfun$listTypePaths$3(cisInRepository, id))).values().flatten((Function1 & Serializable & scala.Serializable)l -> ImplicitConversions$.MODULE$.list$u0020asScalaBuffer(l))).toList().$colon$colon$colon(list3);
        } else {
            list = inArchiveAndRepository;
        }
        List result = list;
        return ImplicitConversions$.MODULE$.seq$u0020AsJavaList((Seq)((List)((SeqLike)result.distinct()).sorted((Ordering)Ordering.String$.MODULE$)).map((Function1 & Serializable & scala.Serializable)x$5 -> new ConfigurationItemId(x$5, ciType), List$.MODULE$.canBuildFrom()));
    }

    public java.util.List<ConfigurationItemId> listEnvironments() {
        return this.listTypePaths((Map<Integer, java.util.List<String>>)ImplicitConversions$.MODULE$.map$u0020AsScala(this.reportGenerator.getEnvironments()).toMap(Predef$.MODULE$.$conforms()), (Function1<ConfigurationItemDataWithInternalId, String>)(Function1 & Serializable & scala.Serializable)x$6 -> x$6.id(), Type.valueOf(Environment.class));
    }

    public java.util.List<ConfigurationItemId> listApplications() {
        return this.listTypePaths((Map<Integer, java.util.List<String>>)ImplicitConversions$.MODULE$.map$u0020AsScala(this.reportGenerator.getApplications()).toMap(Predef$.MODULE$.$conforms()), (Function1<ConfigurationItemDataWithInternalId, String>)(Function1 & Serializable & scala.Serializable)x$7 -> x$7.name(), Type.valueOf(Application.class));
    }

    public static final /* synthetic */ boolean $anonfun$listTypePaths$2(Map cisInRepository$1, Integer id$1, String path) {
        Object object = cisInRepository$1.apply((Object)id$1);
        String string = path;
        return object == null ? string != null : !object.equals(string);
    }

    public static final /* synthetic */ boolean $anonfun$listTypePaths$3(Map cisInRepository$1, Integer id) {
        return !cisInRepository$1.keySet().contains((Object)id);
    }

    public ReportServiceImpl(ReportGenerator reportGenerator, PaginationService paginationService, CiRepository ciRepository, TaskArchive taskArchive, DownloadResource downloadResource) {
        this.reportGenerator = reportGenerator;
        this.paginationService = paginationService;
        this.ciRepository = ciRepository;
        this.taskArchive = taskArchive;
        this.downloadResource = downloadResource;
        Logging.$init$((Logging)this);
    }
}

