/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.core.rest.api;

import com.xebialabs.deployit.core.api.HostService;
import com.xebialabs.deployit.core.rest.api.RepositoryResource;
import com.xebialabs.deployit.engine.api.dto.ConfigurationItemId;
import com.xebialabs.deployit.engine.api.dto.DeploymentInfo;
import com.xebialabs.deployit.engine.api.dto.Ordering;
import com.xebialabs.deployit.engine.api.dto.Paging;
import com.xebialabs.deployit.engine.api.dto.Paging$;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.repository.DeployedApplicationsRepository;
import com.xebialabs.deployit.repository.EnvironmentRepository;
import java.util.List;
import javax.ws.rs.core.Context;
import org.jboss.resteasy.spi.HttpResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import scala.Option$;
import scala.Predef$;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@Service
@ScalaSignature(bytes="\u0006\u0001\u00055d\u0001B\u0006\r\u0001eA\u0001b\n\u0001\u0003\u0002\u0003\u0006I\u0001\u000b\u0005\t]\u0001\u0011\t\u0011)A\u0005_!A!\u0007\u0001B\u0001B\u0003%1\u0007C\u00038\u0001\u0011\u0005\u0001\bC\u0004M\u0001\t\u0007I\u0011A'\t\ra\u0003\u0001\u0015!\u0003O\u0011\u0015)\u0007\u0001\"\u0003g\u0011\u0019y\b\u0001\"\u0011\u0002\u0002!9\u00111\b\u0001\u0005B\u0005u\u0002bBA&\u0001\u0011\u0005\u0013Q\n\u0002\u0010\u0011>\u001cHoU3sm&\u001cW-S7qY*\u0011QBD\u0001\u0004CBL'BA\b\u0011\u0003\u0011\u0011Xm\u001d;\u000b\u0005E\u0011\u0012\u0001B2pe\u0016T!a\u0005\u000b\u0002\u0011\u0011,\u0007\u000f\\8zSRT!!\u0006\f\u0002\u0013a,'-[1mC\n\u001c(\"A\f\u0002\u0007\r|Wn\u0001\u0001\u0014\u0007\u0001Q\"\u0005\u0005\u0002\u001cA5\tAD\u0003\u0002\u001e=\u0005!A.\u00198h\u0015\u0005y\u0012\u0001\u00026bm\u0006L!!\t\u000f\u0003\r=\u0013'.Z2u!\t\u0019S%D\u0001%\u0015\ti\u0001#\u0003\u0002'I\tY\u0001j\\:u'\u0016\u0014h/[2f\u0003U)gN^5s_:lWM\u001c;SKB|7/\u001b;pef\u0004\"!\u000b\u0017\u000e\u0003)R!a\u000b\n\u0002\u0015I,\u0007o\\:ji>\u0014\u00180\u0003\u0002.U\t)RI\u001c<je>tW.\u001a8u%\u0016\u0004xn]5u_JL\u0018A\b3fa2|\u00170\u001a3BaBd\u0017nY1uS>t7OU3q_NLGo\u001c:z!\tI\u0003'\u0003\u00022U\tqB)\u001a9m_f,G-\u00119qY&\u001c\u0017\r^5p]N\u0014V\r]8tSR|'/_\u0001\u0013e\u0016\u0004xn]5u_JL(+Z:pkJ\u001cW\r\u0005\u00025k5\tA\"\u0003\u00027\u0019\t\u0011\"+\u001a9pg&$xN]=SKN|WO]2f\u0003\u0019a\u0014N\\5u}Q!\u0011HO\u001e=!\t!\u0004\u0001C\u0003(\t\u0001\u0007\u0001\u0006C\u0003/\t\u0001\u0007q\u0006C\u00033\t\u0001\u00071\u0007\u000b\u0002\u0005}A\u0011qHS\u0007\u0002\u0001*\u0011\u0011IQ\u0001\u000bC:tw\u000e^1uS>t'BA\"E\u0003\u001d1\u0017m\u0019;pefT!!\u0012$\u0002\u000b\t,\u0017M\\:\u000b\u0005\u001dC\u0015aD:qe&twM\u001a:b[\u0016<xN]6\u000b\u0003%\u000b1a\u001c:h\u0013\tY\u0005IA\u0005BkR|w/\u001b:fI\u0006A!/Z:q_:\u001cX-F\u0001O!\tye+D\u0001Q\u0015\t\t&+A\u0002ta&T!a\u0015+\u0002\u0011I,7\u000f^3bgfT!!\u0016%\u0002\u000b)\u0014wn]:\n\u0005]\u0003&\u0001\u0004%uiB\u0014Vm\u001d9p]N,\u0017!\u0003:fgB|gn]3!Q\t1!\f\u0005\u0002\\G6\tAL\u0003\u0002\u0012;*\u0011alX\u0001\u0003eNT!\u0001Y1\u0002\u0005]\u001c(\"\u00012\u0002\u000b)\fg/\u0019=\n\u0005\u0011d&aB\"p]R,\u0007\u0010^\u0001\u001aG\",7m[%g+N,'\u000fS1t!\u0016\u0014X.[:tS>t7\u000f\u0006\u0002haB\u0011\u0001N\\\u0007\u0002S*\u0011!n[\u0001\u0004k\u0012l'BA\u0007m\u0015\ti'#\u0001\u0004qYV<\u0017N\\\u0005\u0003_&\u0014\u0011cQ8oM&<WO]1uS>t\u0017\n^3n\u0011\u0015\tx\u00011\u0001s\u0003\u0019Awn\u001d;JIB\u00111\u000f \b\u0003ij\u0004\"!\u001e=\u000e\u0003YT!a\u001e\r\u0002\rq\u0012xn\u001c;?\u0015\u0005I\u0018!B:dC2\f\u0017BA>y\u0003\u0019\u0001&/\u001a3fM&\u0011QP \u0002\u0007'R\u0014\u0018N\\4\u000b\u0005mD\u0018\u0001\u00074j]\u0012$U\r\u001d7ps\u0016$\u0017\t\u001d9mS\u000e\fG/[8ogRQ\u00111AA\u0011\u0003G\t9#!\r\u0011\r\u0005\u0015\u00111BA\b\u001b\t\t9AC\u0002\u0002\ny\tA!\u001e;jY&!\u0011QBA\u0004\u0005\u0011a\u0015n\u001d;\u0011\t\u0005E\u0011QD\u0007\u0003\u0003'QA!!\u0006\u0002\u0018\u0005\u0019A\r^8\u000b\u00075\tIBC\u0002\u0002\u001cI\ta!\u001a8hS:,\u0017\u0002BA\u0010\u0003'\u00111cQ8oM&<WO]1uS>t\u0017\n^3n\u0013\u0012DQ!\u001d\u0005A\u0002IDa!!\n\t\u0001\u0004\u0011\u0018a\u00043fa2|\u00170\u001a3BaBt\u0015-\\3\t\u000f\u0005%\u0002\u00021\u0001\u0002,\u00051\u0001/Y4j]\u001e\u0004B!!\u0005\u0002.%!\u0011qFA\n\u0005\u0019\u0001\u0016mZ5oO\"9\u00111\u0007\u0005A\u0002\u0005U\u0012!B8sI\u0016\u0014\b\u0003BA\t\u0003oIA!!\u000f\u0002\u0014\tAqJ\u001d3fe&tw-A\fd_VtG/\u00128wSJ|g.\\3oiN\u0014\u0015\u0010S8tiR1\u0011qHA#\u0003\u000f\u00022aGA!\u0013\r\t\u0019\u0005\b\u0002\u0005\u0019>tw\rC\u0003r\u0013\u0001\u0007!\u000f\u0003\u0004\u0002J%\u0001\rA]\u0001\u0010K:4\u0018N]8o[\u0016tGOT1nK\u0006)r-\u001a;F]ZL'o\u001c8nK:$8OQ=I_N$HCCA(\u0003/\nI&a\u0017\u0002^A1\u0011QAA\u0006\u0003#\u0002B!!\u0005\u0002T%!\u0011QKA\n\u00059!U\r\u001d7ps6,g\u000e^%oM>DQ!\u001d\u0006A\u0002IDa!!\u0013\u000b\u0001\u0004\u0011\bbBA\u0015\u0015\u0001\u0007\u00111\u0006\u0005\b\u0003gQ\u0001\u0019AA\u001bQ\r\u0001\u0011\u0011\r\t\u0005\u0003G\nI'\u0004\u0002\u0002f)\u0019\u0011q\r$\u0002\u0015M$XM]3pif\u0004X-\u0003\u0003\u0002l\u0005\u0015$aB*feZL7-\u001a")
public class HostServiceImpl
implements HostService {
    private final EnvironmentRepository environmentRepository;
    private final DeployedApplicationsRepository deployedApplicationsRepository;
    private final RepositoryResource repositoryResource;
    @Context
    private final HttpResponse response;

    public HttpResponse response() {
        return this.response;
    }

    private ConfigurationItem checkIfUserHasPermissions(String hostId) {
        return this.repositoryResource.read(hostId);
    }

    public List<ConfigurationItemId> findDeployedApplications(String hostId, String deployedAppName, Paging paging, Ordering order) {
        this.checkIfUserHasPermissions(hostId);
        int count = this.deployedApplicationsRepository.countByHost(hostId, deployedAppName);
        this.response().getOutputHeaders().putSingle((Object)Paging$.MODULE$.X_TOTAL_COUNT_HEADER(), (Object)BoxesRunTime.boxToInteger((int)count));
        return (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)this.deployedApplicationsRepository.findByHost(hostId, deployedAppName, paging, order)).asJava();
    }

    public Long countEnvironmentsByHost(String hostId, String environmentName) {
        this.checkIfUserHasPermissions(hostId);
        return Predef$.MODULE$.long2Long(this.environmentRepository.count(hostId, Option$.MODULE$.apply((Object)environmentName)));
    }

    public List<DeploymentInfo> getEnvironmentsByHost(String hostId, String environmentName, Paging paging, Ordering order) {
        this.checkIfUserHasPermissions(hostId);
        long count = this.environmentRepository.count(hostId, Option$.MODULE$.apply((Object)environmentName));
        this.response().getOutputHeaders().putSingle((Object)Paging$.MODULE$.X_TOTAL_COUNT_HEADER(), (Object)BoxesRunTime.boxToLong((long)count));
        return this.environmentRepository.listEnvironmentsByHost(hostId, Option$.MODULE$.apply((Object)environmentName), paging, order);
    }

    @Autowired
    public HostServiceImpl(EnvironmentRepository environmentRepository, DeployedApplicationsRepository deployedApplicationsRepository, RepositoryResource repositoryResource) {
        this.environmentRepository = environmentRepository;
        this.deployedApplicationsRepository = deployedApplicationsRepository;
        this.repositoryResource = repositoryResource;
        this.response = null;
    }
}

