/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.core.rest.websockets;

import com.xebialabs.deployit.core.events.ChangeSetEvent;
import com.xebialabs.deployit.core.websockets.WebSocketEndpoints;
import com.xebialabs.deployit.engine.spi.event.MaintenanceStartEvent;
import com.xebialabs.deployit.engine.spi.event.MaintenanceStopEvent;
import com.xebialabs.deployit.event.EventBusHolder;
import java.io.Serializable;
import java.util.Collection;
import nl.javadude.t2bus.Subscribe;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.messaging.simp.SimpMessagingTemplate;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Controller;
import scala.Function0;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.convert.ImplicitConversions$;
import scala.collection.immutable.Map;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@Controller
@ScalaSignature(bytes="\u0006\u0001\u0005\u0005d\u0001\u0002\u0006\f\u0001aA\u0001b\b\u0001\u0003\u0002\u0003\u0006I\u0001\t\u0005\u0006o\u0001!\t\u0001\u000f\u0005\u0006{\u0001!IA\u0010\u0005\u0006\u001f\u0002!I\u0001\u0015\u0005\u0006e\u0002!\ta\u001d\u0005\b\u0003\u001f\u0001A\u0011BA\t\u0011\u001d\ti\u0002\u0001C\u0005\u0003?Aq!a\u000b\u0001\t\u0003\ti\u0003C\u0004\u0002F\u0001!\t!a\u0012\u0003/]+'mU8dW\u0016$X*Z:tC\u001e,7oU3oI\u0016\u0014(B\u0001\u0007\u000e\u0003)9XMY:pG.,Go\u001d\u0006\u0003\u001d=\tAA]3ti*\u0011\u0001#E\u0001\u0005G>\u0014XM\u0003\u0002\u0013'\u0005AA-\u001a9m_fLGO\u0003\u0002\u0015+\u0005I\u00010\u001a2jC2\f'm\u001d\u0006\u0002-\u0005\u00191m\\7\u0004\u0001M\u0011\u0001!\u0007\t\u00035ui\u0011a\u0007\u0006\u00029\u0005)1oY1mC&\u0011ad\u0007\u0002\u0007\u0003:L(+\u001a4\u0002\u001f5,7o]1hKR+W\u000e\u001d7bi\u0016\u0004\"!\t\u0016\u000e\u0003\tR!a\t\u0013\u0002\tMLW\u000e\u001d\u0006\u0003K\u0019\n\u0011\"\\3tg\u0006<\u0017N\\4\u000b\u0005\u001dB\u0013aD:qe&twM\u001a:b[\u0016<xN]6\u000b\u0003%\n1a\u001c:h\u0013\tY#EA\u000bTS6\u0004X*Z:tC\u001eLgn\u001a+f[Bd\u0017\r^3)\u0005\u0005i\u0003C\u0001\u00186\u001b\u0005y#B\u0001\u00192\u0003)\tgN\\8uCRLwN\u001c\u0006\u0003eM\nqAZ1di>\u0014\u0018P\u0003\u00025M\u0005)!-Z1og&\u0011ag\f\u0002\n\u0003V$xn^5sK\u0012\fa\u0001P5oSRtDCA\u001d<!\tQ\u0004!D\u0001\f\u0011\u0015y\"\u00011\u0001!Q\tYT&\u0001\u0006hKRDU-\u00193feN$\"aP'\u0011\t\u0001;%*\u0007\b\u0003\u0003\u0016\u0003\"AQ\u000e\u000e\u0003\rS!\u0001R\f\u0002\rq\u0012xn\u001c;?\u0013\t15$\u0001\u0004Qe\u0016$WMZ\u0005\u0003\u0011&\u00131!T1q\u0015\t15\u0004\u0005\u0002A\u0017&\u0011A*\u0013\u0002\u0007'R\u0014\u0018N\\4\t\u000b9\u001b\u0001\u0019\u0001&\u0002\u0011U\u001cXM\u001d8b[\u0016\f\u0001C\\8uS\u001aL\u0018J\u001a(pi\u0016k\u0007\u000f^=\u0015\tE#6,\u001d\t\u00035IK!aU\u000e\u0003\tUs\u0017\u000e\u001e\u0005\u0006+\u0012\u0001\rAV\u0001\tK:$\u0007o\\5oiB\u0011q+W\u0007\u00021*\u0011AbD\u0005\u00035b\u0013!cV3c'>\u001c7.\u001a;F]\u0012\u0004x.\u001b8ug\")A\f\u0002a\u0001;\u0006\u00191-[:1\u0005yC\u0007cA0eM6\t\u0001M\u0003\u0002bE\u0006!Q\u000f^5m\u0015\u0005\u0019\u0017\u0001\u00026bm\u0006L!!\u001a1\u0003\u0015\r{G\u000e\\3di&|g\u000e\u0005\u0002hQ2\u0001A!C5\\\u0003\u0003\u0005\tQ!\u0001k\u0005\ryF%M\t\u0003W:\u0004\"A\u00077\n\u00055\\\"a\u0002(pi\"Lgn\u001a\t\u00035=L!\u0001]\u000e\u0003\u0007\u0005s\u0017\u0010C\u0003O\t\u0001\u0007!*A\ftK:$7)[\"iC:<WmU3u\u001b\u0016\u001c8/Y4fgR\u0011\u0011\u000b\u001e\u0005\u0006k\u0016\u0001\rA^\u0001\u0006KZ,g\u000e\u001e\t\u0003ojl\u0011\u0001\u001f\u0006\u0003s>\ta!\u001a<f]R\u001c\u0018BA>y\u00059\u0019\u0005.\u00198hKN+G/\u0012<f]RD#!B?\u0011\u0007y\fY!D\u0001\u0000\u0015\u0011\t\t!a\u0001\u0002\u000bQ\u0014$-^:\u000b\t\u0005\u0015\u0011qA\u0001\tU\u00064\u0018\rZ;eK*\u0011\u0011\u0011B\u0001\u0003]2L1!!\u0004\u0000\u0005%\u0019VOY:de&\u0014W-\u0001\u0011o_RLg-_!c_V$X*Y5oi\u0016t\u0017M\\2f\u001b>$Wm\u00115b]\u001e,GcA)\u0002\u0014!9\u0011Q\u0003\u0004A\u0002\u0005]\u0011aB3oC\ndW\r\u001a\t\u00045\u0005e\u0011bAA\u000e7\t9!i\\8mK\u0006t\u0017aC4fiV\u001bXM\u001d(b[\u0016,\"!!\t\u0011\t\u0005\r\u0012\u0011F\u0007\u0003\u0003KQ1!a\nc\u0003\u0011a\u0017M\\4\n\u00071\u000b)#\u0001\ftK:$W*Y5oi\u0016t\u0017M\\2f'R\f'\u000f^3e)\r\t\u0016q\u0006\u0005\u0007k\"\u0001\r!!\r\u0011\t\u0005M\u0012qH\u0007\u0003\u0003kQ1!^A\u001c\u0015\u0011\tI$a\u000f\u0002\u0007M\u0004\u0018NC\u0002\u0002>E\ta!\u001a8hS:,\u0017\u0002BA!\u0003k\u0011Q#T1j]R,g.\u00198dKN#\u0018M\u001d;Fm\u0016tG\u000f\u000b\u0002\t{\u000612/\u001a8e\u001b\u0006Lg\u000e^3oC:\u001cWm\u0015;paB,G\rF\u0002R\u0003\u0013Ba!^\u0005A\u0002\u0005-\u0003\u0003BA\u001a\u0003\u001bJA!a\u0014\u00026\t!R*Y5oi\u0016t\u0017M\\2f'R|\u0007/\u0012<f]RD#!C?)\u0007\u0001\t)\u0006\u0005\u0003\u0002X\u0005uSBAA-\u0015\r\tYFJ\u0001\u000bgR,'/Z8usB,\u0017\u0002BA0\u00033\u0012!bQ8oiJ|G\u000e\\3s\u0001")
public class WebSocketMessagesSender {
    @Autowired
    private final SimpMessagingTemplate messageTemplate;

    private Map<String, Object> getHeaders(String username) {
        return (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"username"), (Object)username)}));
    }

    private void notifyIfNotEmpty(WebSocketEndpoints endpoint, Collection<?> cis, String username) {
        block0: {
            if (!ImplicitConversions$.MODULE$.collection$u0020AsScalaIterable(cis).nonEmpty()) break block0;
            this.messageTemplate.convertAndSend((Object)endpoint.getName(), cis, ImplicitConversions$.MODULE$.map$u0020AsJavaMap(this.getHeaders(username)));
        }
    }

    @Subscribe
    public void sendCiChangeSetMessages(ChangeSetEvent event) {
        String username = (String)event.username().getOrElse((Function0 & Serializable & scala.Serializable)() -> this.getUserName());
        this.notifyIfNotEmpty(WebSocketEndpoints.TOPIC_CI_CREATE, event.createCis(), username);
        this.notifyIfNotEmpty(WebSocketEndpoints.TOPIC_CI_UPDATE, event.updateCis(), username);
        this.notifyIfNotEmpty(WebSocketEndpoints.TOPIC_CI_DELETE, event.deleteCiIds(), username);
        this.notifyIfNotEmpty(WebSocketEndpoints.TOPIC_CI_RENAME, event.renameCis(), username);
        this.notifyIfNotEmpty(WebSocketEndpoints.TOPIC_CI_MOVE, event.moveCis(), username);
        this.notifyIfNotEmpty(WebSocketEndpoints.TOPIC_CI_COPY, event.copyCis(), username);
    }

    private void notifyAboutMaintenanceModeChange(boolean enabled) {
        this.messageTemplate.convertAndSend((Object)WebSocketEndpoints.TOPIC_MAINTENANCE.getName(), (Object)BoxesRunTime.boxToBoolean((boolean)enabled), ImplicitConversions$.MODULE$.map$u0020AsJavaMap(this.getHeaders(this.getUserName())));
    }

    private String getUserName() {
        return SecurityContextHolder.getContext().getAuthentication().getName();
    }

    @Subscribe
    public void sendMaintenanceStarted(MaintenanceStartEvent event) {
        this.notifyAboutMaintenanceModeChange(true);
    }

    @Subscribe
    public void sendMaintenanceStopped(MaintenanceStopEvent event) {
        this.notifyAboutMaintenanceModeChange(false);
    }

    public WebSocketMessagesSender(@Autowired SimpMessagingTemplate messageTemplate) {
        this.messageTemplate = messageTemplate;
        EventBusHolder.register((Object)this);
    }
}

