/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.core.rest.websockets;

import com.xebialabs.deployit.core.events.ChangeSetEvent;
import com.xebialabs.deployit.core.websockets.WebSocketEndpoints;
import com.xebialabs.deployit.engine.spi.event.MaintenanceStartEvent;
import com.xebialabs.deployit.engine.spi.event.MaintenanceStopEvent;
import com.xebialabs.deployit.event.EventBusHolder;
import java.io.Serializable;
import java.util.Collection;
import nl.javadude.t2bus.Subscribe;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.messaging.simp.SimpMessagingTemplate;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Controller;
import scala.Function0;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.convert.ImplicitConversions$;
import scala.collection.immutable.Map;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@Controller
@ScalaSignature(bytes="\u0006\u0001\u0005\u0005d\u0001B\u0001\u0003\u0001=\u0011qcV3c'>\u001c7.\u001a;NKN\u001c\u0018mZ3t'\u0016tG-\u001a:\u000b\u0005\r!\u0011AC<fEN|7m[3ug*\u0011QAB\u0001\u0005e\u0016\u001cHO\u0003\u0002\b\u0011\u0005!1m\u001c:f\u0015\tI!\"\u0001\u0005eKBdw._5u\u0015\tYA\"A\u0005yK\nL\u0017\r\\1cg*\tQ\"A\u0002d_6\u001c\u0001a\u0005\u0002\u0001!A\u0011\u0011\u0003F\u0007\u0002%)\t1#A\u0003tG\u0006d\u0017-\u0003\u0002\u0016%\t1\u0011I\\=SK\u001aD\u0001b\u0006\u0001\u0003\u0002\u0003\u0006I\u0001G\u0001\u0010[\u0016\u001c8/Y4f)\u0016l\u0007\u000f\\1uKB\u0011\u0011DI\u0007\u00025)\u00111\u0004H\u0001\u0005g&l\u0007O\u0003\u0002\u001e=\u0005IQ.Z:tC\u001eLgn\u001a\u0006\u0003?\u0001\nqb\u001d9sS:<gM]1nK^|'o\u001b\u0006\u0002C\u0005\u0019qN]4\n\u0005\rR\"!F*j[BlUm]:bO&tw\rV3na2\fG/\u001a\u0015\u0003-\u0015\u0002\"AJ\u0017\u000e\u0003\u001dR!\u0001K\u0015\u0002\u0015\u0005tgn\u001c;bi&|gN\u0003\u0002+W\u00059a-Y2u_JL(B\u0001\u0017\u001f\u0003\u0015\u0011W-\u00198t\u0013\tqsEA\u0005BkR|w/\u001b:fI\")\u0001\u0007\u0001C\u0001c\u00051A(\u001b8jiz\"\"A\r\u001b\u0011\u0005M\u0002Q\"\u0001\u0002\t\u000b]y\u0003\u0019\u0001\r)\u0005Q*\u0003\"B\u001c\u0001\t\u0013A\u0014AC4fi\"+\u0017\rZ3sgR\u0011\u0011h\u0012\t\u0005u\u0005#\u0005C\u0004\u0002<\u007fA\u0011AHE\u0007\u0002{)\u0011aHD\u0001\u0007yI|w\u000e\u001e \n\u0005\u0001\u0013\u0012A\u0002)sK\u0012,g-\u0003\u0002C\u0007\n\u0019Q*\u00199\u000b\u0005\u0001\u0013\u0002C\u0001\u001eF\u0013\t15I\u0001\u0004TiJLgn\u001a\u0005\u0006\u0011Z\u0002\r\u0001R\u0001\tkN,'O\\1nK\")!\n\u0001C\u0005\u0017\u0006\u0001bn\u001c;jMfLeMT8u\u000b6\u0004H/\u001f\u000b\u0005\u0019>3F\u000e\u0005\u0002\u0012\u001b&\u0011aJ\u0005\u0002\u0005+:LG\u000fC\u0003Q\u0013\u0002\u0007\u0011+\u0001\u0005f]\u0012\u0004x.\u001b8u!\t\u0011F+D\u0001T\u0015\t\u0019a!\u0003\u0002V'\n\u0011r+\u001a2T_\u000e\\W\r^#oIB|\u0017N\u001c;t\u0011\u00159\u0016\n1\u0001Y\u0003\r\u0019\u0017n\u001d\u0019\u00033\u000e\u00042AW0b\u001b\u0005Y&B\u0001/^\u0003\u0011)H/\u001b7\u000b\u0003y\u000bAA[1wC&\u0011\u0001m\u0017\u0002\u000b\u0007>dG.Z2uS>t\u0007C\u00012d\u0019\u0001!\u0011\u0002\u001a,\u0002\u0002\u0003\u0005)\u0011A3\u0003\u0007}#\u0013'\u0005\u0002gSB\u0011\u0011cZ\u0005\u0003QJ\u0011qAT8uQ&tw\r\u0005\u0002\u0012U&\u00111N\u0005\u0002\u0004\u0003:L\b\"\u0002%J\u0001\u0004!\u0005\"\u00028\u0001\t\u0003y\u0017aF:f]\u0012\u001c\u0015n\u00115b]\u001e,7+\u001a;NKN\u001c\u0018mZ3t)\ta\u0005\u000fC\u0003r[\u0002\u0007!/A\u0003fm\u0016tG\u000f\u0005\u0002tm6\tAO\u0003\u0002v\r\u00051QM^3oiNL!a\u001e;\u0003\u001d\rC\u0017M\\4f'\u0016$XI^3oi\"\u0012Q.\u001f\t\u0004u\u0006\rQ\"A>\u000b\u0005ql\u0018!\u0002;3EV\u001c(B\u0001@\u0000\u0003!Q\u0017M^1ek\u0012,'BAA\u0001\u0003\tqG.C\u0002\u0002\u0006m\u0014\u0011bU;cg\u000e\u0014\u0018NY3\t\u000f\u0005%\u0001\u0001\"\u0003\u0002\f\u0005\u0001cn\u001c;jMf\f%m\\;u\u001b\u0006Lg\u000e^3oC:\u001cW-T8eK\u000eC\u0017M\\4f)\ra\u0015Q\u0002\u0005\t\u0003\u001f\t9\u00011\u0001\u0002\u0012\u00059QM\\1cY\u0016$\u0007cA\t\u0002\u0014%\u0019\u0011Q\u0003\n\u0003\u000f\t{w\u000e\\3b]\"9\u0011\u0011\u0004\u0001\u0005\n\u0005m\u0011aC4fiV\u001bXM\u001d(b[\u0016,\"!!\b\u0011\t\u0005}\u0011QE\u0007\u0003\u0003CQ1!a\t^\u0003\u0011a\u0017M\\4\n\u0007\u0019\u000b\t\u0003C\u0004\u0002*\u0001!\t!a\u000b\u0002-M,g\u000eZ'bS:$XM\\1oG\u0016\u001cF/\u0019:uK\u0012$2\u0001TA\u0017\u0011\u001d\t\u0018q\u0005a\u0001\u0003_\u0001B!!\r\u0002>5\u0011\u00111\u0007\u0006\u0004c\u0006U\"\u0002BA\u001c\u0003s\t1a\u001d9j\u0015\r\tY\u0004C\u0001\u0007K:<\u0017N\\3\n\t\u0005}\u00121\u0007\u0002\u0016\u001b\u0006Lg\u000e^3oC:\u001cWm\u0015;beR,e/\u001a8uQ\r\t9#\u001f\u0005\b\u0003\u000b\u0002A\u0011AA$\u0003Y\u0019XM\u001c3NC&tG/\u001a8b]\u000e,7\u000b^8qa\u0016$Gc\u0001'\u0002J!9\u0011/a\u0011A\u0002\u0005-\u0003\u0003BA\u0019\u0003\u001bJA!a\u0014\u00024\t!R*Y5oi\u0016t\u0017M\\2f'R|\u0007/\u0012<f]RD3!a\u0011zQ\r\u0001\u0011Q\u000b\t\u0005\u0003/\ni&\u0004\u0002\u0002Z)\u0019\u00111\f\u0010\u0002\u0015M$XM]3pif\u0004X-\u0003\u0003\u0002`\u0005e#AC\"p]R\u0014x\u000e\u001c7fe\u0002")
public class WebSocketMessagesSender {
    @Autowired
    private final SimpMessagingTemplate messageTemplate;

    private Map<String, Object> getHeaders(String username) {
        return (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"username"), (Object)username)}));
    }

    private void notifyIfNotEmpty(WebSocketEndpoints endpoint, Collection<?> cis, String username) {
        block0: {
            if (!ImplicitConversions$.MODULE$.collection$u0020AsScalaIterable(cis).nonEmpty()) break block0;
            this.messageTemplate.convertAndSend((Object)endpoint.getName(), cis, ImplicitConversions$.MODULE$.map$u0020AsJavaMap(this.getHeaders(username)));
        }
    }

    @Subscribe
    public void sendCiChangeSetMessages(ChangeSetEvent event) {
        String username = (String)event.username().getOrElse((Function0 & Serializable & scala.Serializable)() -> this.getUserName());
        this.notifyIfNotEmpty(WebSocketEndpoints.TOPIC_CI_CREATE, event.createCis(), username);
        this.notifyIfNotEmpty(WebSocketEndpoints.TOPIC_CI_UPDATE, event.updateCis(), username);
        this.notifyIfNotEmpty(WebSocketEndpoints.TOPIC_CI_DELETE, event.deleteCiIds(), username);
        this.notifyIfNotEmpty(WebSocketEndpoints.TOPIC_CI_RENAME, event.renameCis(), username);
        this.notifyIfNotEmpty(WebSocketEndpoints.TOPIC_CI_MOVE, event.moveCis(), username);
        this.notifyIfNotEmpty(WebSocketEndpoints.TOPIC_CI_COPY, event.copyCis(), username);
    }

    private void notifyAboutMaintenanceModeChange(boolean enabled) {
        this.messageTemplate.convertAndSend((Object)WebSocketEndpoints.TOPIC_MAINTENANCE.getName(), (Object)BoxesRunTime.boxToBoolean((boolean)enabled), ImplicitConversions$.MODULE$.map$u0020AsJavaMap(this.getHeaders(this.getUserName())));
    }

    private String getUserName() {
        return SecurityContextHolder.getContext().getAuthentication().getName();
    }

    @Subscribe
    public void sendMaintenanceStarted(MaintenanceStartEvent event) {
        this.notifyAboutMaintenanceModeChange(true);
    }

    @Subscribe
    public void sendMaintenanceStopped(MaintenanceStopEvent event) {
        this.notifyAboutMaintenanceModeChange(false);
    }

    public WebSocketMessagesSender(@Autowired SimpMessagingTemplate messageTemplate) {
        this.messageTemplate = messageTemplate;
        EventBusHolder.register((Object)this);
    }
}

