/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.core.rest.converters;

import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.core.api.dto.BannerInfo;
import com.xebialabs.xltype.serialization.json.JsonWriter;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;

public class BannerInfoJsonConverter {
    public String toJson(BannerInfo bannerInfo) {
        JsonWriter writer = new JsonWriter();
        this.toJson(bannerInfo, writer);
        return writer.toString();
    }

    public void toJson(BannerInfo bannerInfo, JsonWriter writer) {
        writer.object();
        writer.key("kind").value((Object)bannerInfo.getKind().name());
        writer.key("content").value((Object)bannerInfo.getContent());
        writer.endObject();
    }

    public BannerInfo toBannerInfo(String jsonString) {
        try {
            JSONObject json = new JSONObject(jsonString);
            Checks.checkArgument((boolean)json.has("kind"), (String)"Missing 'kind' property in JSON:\n%s", (Object[])new Object[]{jsonString});
            Checks.checkArgument((boolean)json.has("content"), (String)"Missing 'content' property in JSON:\n%s", (Object[])new Object[]{jsonString});
            BannerInfo.BannerKind kind = BannerInfo.BannerKind.fromValue((String)json.getString("kind"));
            return new BannerInfo(kind, json.getString("content"));
        }
        catch (JSONException e) {
            throw new IllegalArgumentException("Can't parse JSON:\n" + jsonString, e);
        }
    }
}

