/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.core.rest.api.reports;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.xebialabs.deployit.core.CiUtils;
import com.xebialabs.deployit.core.api.dto.Report;
import com.xebialabs.deployit.core.api.dto.ReportLine;
import com.xebialabs.deployit.core.rest.api.reports.ReportUtils;
import com.xebialabs.deployit.core.rest.api.reports.TaskArchiveReport;
import com.xebialabs.deployit.core.rest.api.reports.TaskStateData;
import com.xebialabs.deployit.task.archive.TaskArchive;
import com.xebialabs.deployit.task.archive.sql.schema.ArchivedDeploymentTasks;
import java.util.Map;

public class DeploymentsKeyIndicator
extends TaskArchiveReport {
    public DeploymentsKeyIndicator(TaskArchive taskArchive) {
        super(taskArchive);
    }

    public Report report() {
        LoadingCache tasks = CacheBuilder.newBuilder().build(CacheLoader.from(input -> new TaskStateData()));
        this.taskArchive.searchForMaps(this.getSearchParameters(), true).forEach(task -> DeploymentsKeyIndicator.addTask((LoadingCache<String, TaskStateData>)tasks, task));
        return DeploymentsKeyIndicator.generateReport(tasks.asMap());
    }

    private static Report generateReport(Map<String, TaskStateData> tasksMap) {
        Report report = new Report();
        for (Map.Entry<String, TaskStateData> entry : tasksMap.entrySet()) {
            TaskStateData task = entry.getValue();
            ReportLine line = report.addLine();
            String[] appAndEnv = entry.getKey().split("~", 2);
            String appId = appAndEnv[0];
            String envId = appAndEnv[1];
            line.addValue("application", (Object)appId);
            line.addValue("environment", (Object)CiUtils.getName((String)envId));
            line.addValue("environmentId", (Object)envId);
            line.addValue("environmentIdWithoutRoot", (Object)CiUtils.getIdWithoutRoot((String)envId));
            line.addValue("noOfSuccessfulDeployments", (Object)task.getNoOfSuccessfulDeployments().toString());
            line.addValue("noOfFailedDeployments", (Object)task.getNoOfFailedDeployments().toString());
            line.addValue("noOfAbortedDeployments", (Object)task.getNoOfAbortedDeployments().toString());
            line.addValue("noOfRollbacks", (Object)task.getNoOfRollbacks().toString());
            line.addValue("averageDuration", (Object)DeploymentsKeyIndicator.getAverageDeploymentTime(task));
        }
        return report;
    }

    static String getAverageDeploymentTime(TaskStateData task) {
        if (task.getTotalSuccessfulTasks() > 0) {
            return ReportUtils.formatToHoursMinsSecs(task.getAverageDeploymentTime() / (long)task.getTotalSuccessfulTasks());
        }
        return "00:00:00";
    }

    private static void addTask(LoadingCache<String, TaskStateData> tasks, Map<String, Object> task) {
        String entityId = task.get(ArchivedDeploymentTasks.main_application().name()) + "~" + task.get(ArchivedDeploymentTasks.environment().name());
        ((TaskStateData)tasks.getUnchecked((Object)entityId)).addTaskAndDuration(task);
    }
}

