/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.core.rest.websockets;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import com.xebialabs.deployit.ServerConfiguration;
import com.xebialabs.deployit.core.rest.converters.CiMessageConverter;
import com.xebialabs.deployit.core.rest.converters.CisMessageConverter;
import com.xebialabs.deployit.core.rest.json.CiJsonMessageBodyReaderWriter;
import com.xebialabs.deployit.core.rest.json.CisJsonMessageBodyReaderWriter;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.eclipse.jetty.websocket.api.WebSocketBehavior;
import org.eclipse.jetty.websocket.api.WebSocketPolicy;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.messaging.converter.MessageConverter;
import org.springframework.messaging.simp.config.MessageBrokerRegistry;
import org.springframework.scheduling.TaskScheduler;
import org.springframework.web.socket.config.annotation.AbstractWebSocketMessageBrokerConfigurer;
import org.springframework.web.socket.config.annotation.EnableWebSocketMessageBroker;
import org.springframework.web.socket.config.annotation.StompEndpointRegistry;
import org.springframework.web.socket.server.HandshakeHandler;
import org.springframework.web.socket.server.RequestUpgradeStrategy;
import org.springframework.web.socket.server.jetty.JettyRequestUpgradeStrategy;
import org.springframework.web.socket.server.support.DefaultHandshakeHandler;
import scala.reflect.ScalaSignature;

@Configuration
@EnableWebSocketMessageBroker
@ScalaSignature(bytes="\u0006\u0001\u0005=d\u0001B\u0007\u000f\u0001mA\u0001\u0002\f\u0001\u0003\u0002\u0003\u0006I!\f\u0005\t{\u0001\u0011\t\u0011)A\u0005}!A!\t\u0001B\u0001B\u0003%1\tC\u0003R\u0001\u0011\u0005!\u000bC\u0004]\u0001\t\u0007I\u0011B/\t\r\u0019\u0004\u0001\u0015!\u0003_\u0011\u001d9\u0007A1A\u0005\n!Da\u0001\u001d\u0001!\u0002\u0013I\u0007\"B9\u0001\t\u0003\u0012\bbBA\u0005\u0001\u0011\u0005\u00111\u0002\u0005\b\u0003[\u0001A\u0011IA\u0018\u0011\u001d\tI\u0004\u0001C!\u0003w\u0011AdV3c'>\u001c7.\u001a;NKN\u001c\u0018mZ3Ce>\\WM]\"p]\u001aLwM\u0003\u0002\u0010!\u0005Qq/\u001a2t_\u000e\\W\r^:\u000b\u0005E\u0011\u0012\u0001\u0002:fgRT!a\u0005\u000b\u0002\t\r|'/\u001a\u0006\u0003+Y\t\u0001\u0002Z3qY>L\u0018\u000e\u001e\u0006\u0003/a\t\u0011\u0002_3cS\u0006d\u0017MY:\u000b\u0003e\t1aY8n\u0007\u0001\u0019\"\u0001\u0001\u000f\u0011\u0005uQS\"\u0001\u0010\u000b\u0005}\u0001\u0013AC1o]>$\u0018\r^5p]*\u0011\u0011EI\u0001\u0007G>tg-[4\u000b\u0005\r\"\u0013AB:pG.,GO\u0003\u0002&M\u0005\u0019q/\u001a2\u000b\u0005\u001dB\u0013aD:qe&twM\u001a:b[\u0016<xN]6\u000b\u0003%\n1a\u001c:h\u0013\tYcD\u0001\u0015BEN$(/Y2u/\u0016\u00147k\\2lKRlUm]:bO\u0016\u0014%o\\6fe\u000e{gNZ5hkJ,'/A\u000fdS*\u001bxN\\'fgN\fw-\u001a\"pIf\u0014V-\u00193fe^\u0013\u0018\u000e^3s!\tq\u0013'D\u00010\u0015\t\u0001\u0004#\u0001\u0003kg>t\u0017B\u0001\u001a0\u0005u\u0019\u0015NS:p]6+7o]1hK\n{G-\u001f*fC\u0012,'o\u0016:ji\u0016\u0014\bFA\u00015!\t)4(D\u00017\u0015\tyrG\u0003\u00029s\u00059a-Y2u_JL(B\u0001\u001e'\u0003\u0015\u0011W-\u00198t\u0013\tadGA\u0005BkR|w/\u001b:fI\u0006q2-[:Kg>tW*Z:tC\u001e,'i\u001c3z%\u0016\fG-\u001a:Xe&$XM\u001d\t\u0003]}J!\u0001Q\u0018\u0003=\rK7OS:p]6+7o]1hK\n{G-\u001f*fC\u0012,'o\u0016:ji\u0016\u0014\bF\u0001\u00025\u00035!\u0018m]6TG\",G-\u001e7feB\u0011AiR\u0007\u0002\u000b*\u0011aIJ\u0001\u000bg\u000eDW\rZ;mS:<\u0017B\u0001%F\u00055!\u0016m]6TG\",G-\u001e7fe\"\"1AS'O!\t)4*\u0003\u0002Mm\tI\u0011+^1mS\u001aLWM]\u0001\u0006m\u0006dW/Z\u0011\u0002\u001f\u0006\u0019r/\u001a2t_\u000e\\W\r^:TG\",G-\u001e7fe\"\u00121\u0001N\u0001\u0007y%t\u0017\u000e\u001e \u0015\tM+v+\u0017\t\u0003)\u0002i\u0011A\u0004\u0005\u0006Y\u0011\u0001\r!\f\u0015\u0003+RBQ!\u0010\u0003A\u0002yB#a\u0016\u001b\t\u000b\t#\u0001\u0019A\")\teSUJ\u0014\u0015\u00033R\nA$T#T'\u0006;Ui\u0018\"S\u001f.+%kX\"P\u001d\u001aKui\u0018)S\u000b\u001aK\u0005,F\u0001_!\tyF-D\u0001a\u0015\t\t'-\u0001\u0003mC:<'\"A2\u0002\t)\fg/Y\u0005\u0003K\u0002\u0014aa\u0015;sS:<\u0017!H'F'N\u000bu)R0C%>[UIU0D\u001f:3\u0015jR0Q%\u00163\u0015\n\u0017\u0011\u0002\u0019ML8\u000f^3n\u0007>tg-[4\u0016\u0003%\u0004\"A\u001b8\u000e\u0003-T!!\t7\u000b\u00055D\u0012\u0001\u0003;za\u0016\u001c\u0018MZ3\n\u0005=\\'AB\"p]\u001aLw-A\u0007tsN$X-\\\"p]\u001aLw\rI\u0001\u0017G>tg-[4ve\u0016lUm]:bO\u0016\u0014%o\\6feR\u00111/\u001f\t\u0003i^l\u0011!\u001e\u0006\u0002m\u0006)1oY1mC&\u0011\u00010\u001e\u0002\u0005+:LG\u000fC\u0003{\u0013\u0001\u000710\u0001\u0005sK\u001eL7\u000f\u001e:z!\ra\u0018QA\u0007\u0002{*\u0011\u0011E \u0006\u0004\u007f\u0006\u0005\u0011\u0001B:j[BT1!a\u0001'\u0003%iWm]:bO&tw-C\u0002\u0002\bu\u0014Q#T3tg\u0006<WM\u0011:pW\u0016\u0014(+Z4jgR\u0014\u00180\u0001\tiC:$7\u000f[1lK\"\u000bg\u000e\u001a7feR\u0011\u0011Q\u0002\t\u0005\u0003\u001f\tI\"\u0004\u0002\u0002\u0012)!\u00111CA\u000b\u0003\u001d\u0019X\u000f\u001d9peRT1!a\u0006#\u0003\u0019\u0019XM\u001d<fe&!\u00111DA\t\u0005]!UMZ1vYRD\u0015M\u001c3tQ\u0006\\W\rS1oI2,'\u000fK\u0002\u000b\u0003?\u0001B!!\t\u0002*5\u0011\u00111\u0005\u0006\u0004?\u0005\u0015\"bAA\u0014M\u000591m\u001c8uKb$\u0018\u0002BA\u0016\u0003G\u0011AAQ3b]\u00061\"/Z4jgR,'o\u0015;p[B,e\u000e\u001a9pS:$8\u000fF\u0002t\u0003cAaA_\u0006A\u0002\u0005M\u0002cA\u000f\u00026%\u0019\u0011q\u0007\u0010\u0003+M#x.\u001c9F]\u0012\u0004x.\u001b8u%\u0016<\u0017n\u001d;ss\u0006Q2m\u001c8gS\u001e,(/Z'fgN\fw-Z\"p]Z,'\u000f^3sgR!\u0011QHA\"!\r!\u0018qH\u0005\u0004\u0003\u0003*(a\u0002\"p_2,\u0017M\u001c\u0005\b\u0003\u000bb\u0001\u0019AA$\u0003EiWm]:bO\u0016\u001cuN\u001c<feR,'o\u001d\t\u0007\u0003\u0013\ny%a\u0015\u000e\u0005\u0005-#bAA'E\u0006!Q\u000f^5m\u0013\u0011\t\t&a\u0013\u0003\t1K7\u000f\u001e\t\u0005\u0003+\nY&\u0004\u0002\u0002X)!\u0011\u0011LA\u0001\u0003%\u0019wN\u001c<feR,'/\u0003\u0003\u0002^\u0005]#\u0001E'fgN\fw-Z\"p]Z,'\u000f^3sQ\r\u0001\u0011\u0011\r\t\u0004;\u0005\r\u0014bAA3=\taRI\\1cY\u0016<VMY*pG.,G/T3tg\u0006<WM\u0011:pW\u0016\u0014\bf\u0001\u0001\u0002jA!\u0011\u0011EA6\u0013\u0011\ti'a\t\u0003\u001b\r{gNZ5hkJ\fG/[8o\u0001")
public class WebSocketMessageBrokerConfig
extends AbstractWebSocketMessageBrokerConfigurer {
    @Autowired
    private final CiJsonMessageBodyReaderWriter ciJsonMessageBodyReaderWriter;
    @Autowired
    private final CisJsonMessageBodyReaderWriter cisJsonMessageBodyReaderWriter;
    @Autowired
    @Qualifier(value="websocketsScheduler")
    private final TaskScheduler taskScheduler;
    private final String MESSAGE_BROKER_CONFIG_PREFIX;
    private final Config systemConfig;

    private String MESSAGE_BROKER_CONFIG_PREFIX() {
        return this.MESSAGE_BROKER_CONFIG_PREFIX;
    }

    private Config systemConfig() {
        return this.systemConfig;
    }

    public void configureMessageBroker(MessageBrokerRegistry registry) {
        registry.setApplicationDestinationPrefixes(new String[]{"/app"});
        registry.enableSimpleBroker(new String[]{"/topic"}).setTaskScheduler(this.taskScheduler);
    }

    @Bean
    public DefaultHandshakeHandler handshakeHandler() {
        WebSocketPolicy policy = new WebSocketPolicy(WebSocketBehavior.SERVER);
        policy.setInputBufferSize(this.systemConfig().getInt(new StringBuilder(17).append(this.MESSAGE_BROKER_CONFIG_PREFIX()).append("input-buffer-size").toString()));
        long idleTimeout = TimeUnit.MINUTES.toMillis(ServerConfiguration.getInstance().getClientSessionTimeoutMinutes());
        policy.setIdleTimeout(idleTimeout);
        return new DefaultHandshakeHandler((RequestUpgradeStrategy)new JettyRequestUpgradeStrategy(policy));
    }

    public void registerStompEndpoints(StompEndpointRegistry registry) {
        registry.addEndpoint(new String[]{"/ws"}).setAllowedOrigins(new String[]{"*"}).setHandshakeHandler((HandshakeHandler)this.handshakeHandler()).withSockJS();
    }

    public boolean configureMessageConverters(List<MessageConverter> messageConverters) {
        messageConverters.add((MessageConverter)new CiMessageConverter(this.ciJsonMessageBodyReaderWriter));
        messageConverters.add((MessageConverter)new CisMessageConverter(this.cisJsonMessageBodyReaderWriter));
        return true;
    }

    public WebSocketMessageBrokerConfig(@Autowired CiJsonMessageBodyReaderWriter ciJsonMessageBodyReaderWriter, @Autowired CisJsonMessageBodyReaderWriter cisJsonMessageBodyReaderWriter, @Autowired @Qualifier(value="websocketsScheduler") TaskScheduler taskScheduler) {
        this.ciJsonMessageBodyReaderWriter = ciJsonMessageBodyReaderWriter;
        this.cisJsonMessageBodyReaderWriter = cisJsonMessageBodyReaderWriter;
        this.taskScheduler = taskScheduler;
        this.MESSAGE_BROKER_CONFIG_PREFIX = "xl.deploy.websockets.message-broker.";
        this.systemConfig = ConfigFactory.load((String)"system.conf");
    }
}

