/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.core.rest.json;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Charsets;
import com.google.common.io.CharStreams;
import com.xebialabs.deployit.core.rest.json.ReaderPostProcessor;
import com.xebialabs.deployit.core.xml.PasswordEncryptingCiConverter;
import com.xebialabs.deployit.engine.api.dto.Deployment;
import com.xebialabs.xltype.serialization.ConfigurationItemConverter;
import com.xebialabs.xltype.serialization.json.DeploymentJsonConverter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import javax.ws.rs.Consumes;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.Provider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@Provider
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class DeploymentJsonReaderWriter
implements MessageBodyWriter<Deployment>,
MessageBodyReader<Deployment> {
    private ReaderPostProcessor postProcessor;

    @Autowired
    public DeploymentJsonReaderWriter(ReaderPostProcessor postProcessor) {
        this.postProcessor = postProcessor;
    }

    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return this.isReadable(type, genericType, annotations, mediaType);
    }

    public boolean isReadable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return Deployment.class.isAssignableFrom(type);
    }

    public long getSize(Deployment deployment, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return -1L;
    }

    public void writeTo(Deployment deployment, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException, WebApplicationException {
        entityStream.write(this.toJson(deployment).getBytes());
    }

    public Deployment readFrom(Class<Deployment> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> httpHeaders, InputStream entityStream) throws IOException, WebApplicationException {
        return this.toDeployment(this.toString(entityStream));
    }

    @VisibleForTesting
    String toJson(Deployment deployment) {
        DeploymentJsonConverter converter = this.getConverter();
        return converter.toJson(deployment);
    }

    @VisibleForTesting
    Deployment toDeployment(String deployment) {
        return this.postProcessor.apply(context -> {
            DeploymentJsonConverter converter = this.getConverter();
            context.register(converter.getCiConverter());
            return converter.toDeployment(deployment);
        });
    }

    public String toString(InputStream in) throws IOException {
        return CharStreams.toString((Readable)new InputStreamReader(in, Charsets.UTF_8));
    }

    private DeploymentJsonConverter getConverter() {
        return new DeploymentJsonConverter((ConfigurationItemConverter)new PasswordEncryptingCiConverter());
    }
}

