/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.core.rest.api;

import com.xebialabs.deployit.core.rest.secured.AbstractSecuredResource;
import com.xebialabs.deployit.engine.api.DeploymentService;
import com.xebialabs.deployit.engine.api.dto.Deployment;
import com.xebialabs.deployit.engine.api.dto.SelectedDeployment;
import com.xebialabs.deployit.engine.api.execution.StepState;
import com.xebialabs.deployit.engine.api.execution.TaskPreviewBlock;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.service.deployment.DeploymentTaskService;
import java.util.List;
import java.util.Map;
import javax.ws.rs.PathParam;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;

@Controller
public class DeploymentResource
extends AbstractSecuredResource
implements DeploymentService {
    @Autowired
    private DeploymentTaskService deploymentTaskService;
    private static final Logger logger = LoggerFactory.getLogger(DeploymentResource.class);

    public boolean isDeployed(String applicationId, String environmentId) {
        logger.trace("isDeployed {}, {}", (Object)applicationId, (Object)environmentId);
        return this.deploymentTaskService.isDeployed(applicationId, environmentId);
    }

    public Deployment prepareInitial(String versionId, String environmentId) {
        logger.trace("prepareInitial {}, {}", (Object)versionId, (Object)environmentId);
        return this.deploymentTaskService.prepareInitial(versionId, environmentId);
    }

    public Deployment prepareUpdate(String newVersionId, String deployedApplicationId) {
        logger.trace("prepareUpgrade {}, {}", (Object)newVersionId, (Object)deployedApplicationId);
        return this.deploymentTaskService.prepareUpdate(newVersionId, deployedApplicationId);
    }

    public Deployment prepareUndeploy(String deployedApplicationId) {
        logger.trace("prepareUndeployApplication {}", (Object)deployedApplicationId);
        return this.deploymentTaskService.prepareUndeploy(deployedApplicationId);
    }

    public Deployment prepareAutoDeployeds(Deployment deployment) {
        logger.trace("updateDeployeds {}", (Object)deployment);
        return this.deploymentTaskService.prepareAutoDeployeds(deployment);
    }

    public Deployment generateSelectedDeployeds(List<String> deployableIds, Deployment deployment) {
        return this.generateSelectedDeployeds(new SelectedDeployment(deployableIds, deployment));
    }

    public Deployment generateSelectedDeployeds(SelectedDeployment selectedDeployment) {
        return this.deploymentTaskService.generateSelectedDeployeds(selectedDeployment);
    }

    public Deployment generateSingleDeployed(String deployableId, String containerId, Type deployedType, Deployment deployment) {
        return this.deploymentTaskService.generateSingleDeployed(deployableId, containerId, deployedType, deployment);
    }

    public Deployment validate(Deployment deployment) {
        return this.deploymentTaskService.validate(deployment);
    }

    public TaskPreviewBlock taskPreviewBlock(Deployment deployment) {
        return this.deploymentTaskService.taskPreviewBlock(deployment);
    }

    public StepState taskPreviewBlock(Deployment deployment, String blockId, int stepNr) {
        return this.deploymentTaskService.taskPreviewBlock(deployment, blockId, stepNr);
    }

    public String createTask(Deployment deployment) {
        return this.deploymentTaskService.createTask(deployment);
    }

    public String rollback(@PathParam(value="taskid") String taskid) {
        return this.deploymentTaskService.rollback(taskid);
    }

    public Map<String, String> effectiveDictionary(String environment, String application, String container) {
        return this.deploymentTaskService.effectiveDictionary(environment, application, container);
    }
}

