/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.core.rest.api;

import com.xebialabs.deployit.core.ordering.ConfigurationItemIdComparator;
import com.xebialabs.deployit.core.rest.api.DtoReader;
import com.xebialabs.deployit.core.rest.api.RepositoryResource;
import com.xebialabs.deployit.core.rest.api.SearchParametersFactory;
import com.xebialabs.deployit.engine.api.RoleService;
import com.xebialabs.deployit.engine.api.dto.ConfigurationItemId;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.repository.RepositoryService;
import com.xebialabs.deployit.repository.SearchParameters;
import com.xebialabs.deployit.repository.WorkDirFactory;
import com.xebialabs.deployit.repository.sql.XldSearchParameters;
import com.xebialabs.deployit.security.permission.DeployitPermissions;
import com.xebialabs.deployit.security.permission.PlatformPermissions;
import com.xebialabs.deployit.service.validation.Validator;
import com.xebialabs.xldeploy.packager.SourceArtifactEnricher;
import com.xebialabs.xlplatform.documentation.PublicApi;
import java.util.Calendar;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import org.joda.time.DateTime;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;

@Controller
@Path(value="/repository")
@Consumes(value={"application/xml", "application/json"})
@Produces(value={"application/xml", "application/json"})
@PublicApi
public class DeployitRepositoryResource
extends RepositoryResource {
    private final ConfigurationItemIdComparator comparator;
    @Autowired
    private RepositoryService repositoryService;

    @Autowired
    public DeployitRepositoryResource(RepositoryService repositoryService, Validator validator, RoleService roleService, WorkDirFactory workDirFactory, ConfigurationItemIdComparator comparator, SourceArtifactEnricher enricher, @Value(value="#{allowedConvertibleTypes}") List<Type> allowedConvertibleTypes) {
        super(repositoryService, validator, roleService, workDirFactory, enricher, allowedConvertibleTypes);
        this.comparator = comparator;
    }

    protected void checkDeletePermission(String id) {
        if (DeployitPermissions.IMPORT_REMOVE.isApplicableTo(id)) {
            this.checkPermission(DeployitPermissions.IMPORT_REMOVE, id);
        } else {
            this.checkPermission(PlatformPermissions.EDIT_REPO, id);
        }
    }

    public List<ConfigurationItemId> query(Type type, String parent, String ancestor, String namePattern, DateTime lastModifiedBefore, DateTime lastModifiedAfter, long page, long resultPerPage) {
        List result = super.query(type, parent, ancestor, namePattern, lastModifiedBefore, lastModifiedAfter, page, resultPerPage);
        if (this.isNoPagination(resultPerPage)) {
            this.sort(result);
        }
        return result;
    }

    @GET
    @Path(value="v2/query")
    public List<ConfigurationItemId> queryV2(@QueryParam(value="type") Type type, @QueryParam(value="parent") String parent, @QueryParam(value="ancestor") String ancestor, @QueryParam(value="namePattern") String namePattern, @QueryParam(value="idPattern") String idPattern, @QueryParam(value="lastModifiedBefore") DateTime lastModifiedBefore, @QueryParam(value="lastModifiedAfter") DateTime lastModifiedAfter, @QueryParam(value="page") long page, @QueryParam(value="resultsPerPage") long resultPerPage) {
        XldSearchParameters parameters = new XldSearchParameters(SearchParametersFactory.createSearchParams((Type)type, (long)page, (long)resultPerPage, (String)parent, (String)ancestor, (String)namePattern, (Calendar)(lastModifiedBefore != null ? lastModifiedBefore.toGregorianCalendar() : null), (Calendar)(lastModifiedAfter != null ? lastModifiedAfter.toGregorianCalendar() : null), (int)0));
        if (idPattern != null) {
            parameters.setId(idPattern);
        }
        List<ConfigurationItemId> result = this.repositoryService.list((SearchParameters)parameters).stream().filter(hasReadRight).map(DtoReader.ciDataToCiId).collect(Collectors.toList());
        if (this.isNoPagination(resultPerPage)) {
            this.sort(result);
        }
        return result;
    }

    private void sort(List<ConfigurationItemId> result) {
        Collections.sort(result, this.comparator);
    }

    private boolean isNoPagination(long resultPerPage) {
        return resultPerPage <= 0L;
    }
}

