/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.core.rest.json;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Charsets;
import com.google.common.io.CharStreams;
import com.xebialabs.deployit.core.rest.json.ReaderPostProcessor;
import com.xebialabs.deployit.core.xml.PasswordEncryptingCiConverter;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.xltype.serialization.CiListReader;
import com.xebialabs.xltype.serialization.CiWriter;
import com.xebialabs.xltype.serialization.ConfigurationItemConverter;
import com.xebialabs.xltype.serialization.json.CiJsonWriter;
import com.xebialabs.xltype.serialization.json.CiListJsonReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collection;
import javax.ws.rs.Consumes;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.Provider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@Provider
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class CisJsonMessageBodyReaderWriter
implements MessageBodyWriter<Collection<ConfigurationItem>>,
MessageBodyReader<Collection<ConfigurationItem>> {
    private ReaderPostProcessor postProcessor;

    @Autowired
    public CisJsonMessageBodyReaderWriter(ReaderPostProcessor postProcessor) {
        this.postProcessor = postProcessor;
    }

    public boolean isReadable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return this.isWriteable(type, genericType, annotations, mediaType);
    }

    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        if (!mediaType.toString().contains("application/json")) {
            return false;
        }
        if (Collection.class.isAssignableFrom(type) && genericType instanceof ParameterizedType) {
            type = (Class)((ParameterizedType)genericType).getActualTypeArguments()[0];
        }
        return ConfigurationItem.class.isAssignableFrom(type);
    }

    public long getSize(Collection<ConfigurationItem> t, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return -1L;
    }

    public void writeTo(Collection<ConfigurationItem> cis, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException, WebApplicationException {
        entityStream.write(CisJsonMessageBodyReaderWriter.toJson(cis).getBytes());
    }

    public Collection<ConfigurationItem> readFrom(Class<Collection<ConfigurationItem>> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> httpHeaders, InputStream entityStream) throws IOException, WebApplicationException {
        return this.toObject(CisJsonMessageBodyReaderWriter.toString(entityStream));
    }

    @VisibleForTesting
    static String toJson(Collection<ConfigurationItem> cis) {
        PasswordEncryptingCiConverter converter = CisJsonMessageBodyReaderWriter.getConverter();
        CiJsonWriter writer = new CiJsonWriter();
        writer.startList();
        cis.forEach(arg_0 -> CisJsonMessageBodyReaderWriter.lambda$toJson$73(converter, (CiWriter)writer, arg_0));
        writer.endList();
        return writer.toString();
    }

    @VisibleForTesting
    Collection<ConfigurationItem> toObject(String json) {
        PasswordEncryptingCiConverter converter = CisJsonMessageBodyReaderWriter.getConverter();
        return this.postProcessor.apply(context -> {
            context.register((ConfigurationItemConverter)converter);
            return converter.readCis((CiListReader)CiListJsonReader.create((String)json));
        });
    }

    private static PasswordEncryptingCiConverter getConverter() {
        return new PasswordEncryptingCiConverter();
    }

    public static String toString(InputStream in) throws IOException {
        return CharStreams.toString((Readable)new InputStreamReader(in, Charsets.UTF_8));
    }

    private static /* synthetic */ void lambda$toJson$73(PasswordEncryptingCiConverter converter, CiWriter writer, ConfigurationItem configurationItem) {
        converter.writeCi(configurationItem, writer);
    }
}

