/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.core.rest.api.reports;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.collect.FluentIterable;
import com.xebialabs.deployit.core.api.dto.Report;
import com.xebialabs.deployit.core.api.dto.ReportLine;
import com.xebialabs.deployit.engine.api.execution.TaskState;
import java.util.TreeMap;
import java.util.stream.Stream;
import org.joda.time.Duration;
import org.joda.time.Period;
import org.joda.time.ReadablePeriod;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.PeriodFormatter;
import org.joda.time.format.PeriodFormatterBuilder;

public class ReportUtils {
    public static final DateTimeFormatter FORMATTER = DateTimeFormat.forPattern((String)"yyyy-MM-dd'T'HH:mm:ss.SSSZ");
    static final PeriodFormatter HH_MM_SS = new PeriodFormatterBuilder().minimumPrintedDigits(2).printZeroAlways().appendHours().appendSeparator(":").appendMinutes().appendSeparator(":").appendSeconds().toFormatter();
    static final PeriodFormatter MM_SS = new PeriodFormatterBuilder().printZeroAlways().minimumPrintedDigits(1).appendMinutes().appendSeparator(":").appendSeconds().toFormatter();
    private static final Joiner LINE_JOINER = Joiner.on((String)"\n");
    private static final Joiner FIELD_JOINER = Joiner.on((String)",");
    private static final Function<Object, String> QUOTE = new Function<Object, String>(){

        public String apply(Object input) {
            return String.format("\"%s\"", input);
        }
    };

    static final String formatToMinsAndSecs(long millis) {
        Period period = new Duration(millis).toPeriod();
        return MM_SS.print((ReadablePeriod)period);
    }

    static final String formatToHoursMinsSecs(long millis) {
        Period period = new Duration(millis).toPeriod();
        return HH_MM_SS.print((ReadablePeriod)period);
    }

    public static long duration(TaskState s) {
        return s.getCompletionDate().getMillis() - s.getStartDate().getMillis();
    }

    public static Stream<String> toCsv(Report report) {
        return ReportUtils.toCsv(report.getLines().stream());
    }

    public static Stream<String> toCsv(Stream<ReportLine> report) {
        return report.map(new HeadersFirstLine());
    }

    private static String line(Iterable<?> fields) {
        return FIELD_JOINER.join((Iterable)FluentIterable.from(fields).transform(QUOTE));
    }

    private static TreeMap<String, Object> sorted(ReportLine line) {
        return new TreeMap<String, Object>(line.getValues());
    }

    private static class HeadersFirstLine
    implements java.util.function.Function<ReportLine, String> {
        boolean first = true;

        private HeadersFirstLine() {
        }

        @Override
        public String apply(ReportLine reportLine) {
            TreeMap sorted = ReportUtils.sorted(reportLine);
            if (this.first) {
                this.first = false;
                return LINE_JOINER.join((Object)ReportUtils.line(sorted.keySet()), (Object)ReportUtils.line(sorted.values()), new Object[0]);
            }
            return ReportUtils.line(sorted.values());
        }
    }
}

