/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.core.rest.api.reports;

import com.google.common.base.Function;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.xebialabs.deployit.core.api.dto.Report;
import com.xebialabs.deployit.core.api.dto.ReportLine;
import com.xebialabs.deployit.core.rest.api.reports.DeploymentsKeyIndicator;
import com.xebialabs.deployit.core.rest.api.reports.TaskArchiveReport;
import com.xebialabs.deployit.core.rest.api.reports.TaskStateData;
import com.xebialabs.deployit.engine.api.dto.ConfigurationItemId;
import com.xebialabs.deployit.task.ArchivedTaskSearchParameters;
import com.xebialabs.deployit.task.FilterType;
import com.xebialabs.deployit.task.archive.TaskArchive;
import java.util.List;
import java.util.Map;

public class AggregatedDeploymentsKeyIndicator
extends TaskArchiveReport {
    public AggregatedDeploymentsKeyIndicator(TaskArchive taskArchive) {
        super(taskArchive);
    }

    public Report report(FilterType filterType, List<ConfigurationItemId> filterCriteria) {
        LoadingCache tasks = CacheBuilder.newBuilder().build(CacheLoader.from((Function)new Function<String, TaskStateData>(){

            public TaskStateData apply(String input) {
                return new TaskStateData();
            }
        }));
        for (ConfigurationItemId appOrEnvName : filterCriteria) {
            ArchivedTaskSearchParameters searchTasks = this.cloneSearchParameters().forFilterType(filterType, appOrEnvName);
            this.taskArchive.searchForMaps(searchTasks, true).forEach(task -> ((TaskStateData)tasks.getUnchecked((Object)AggregatedDeploymentsKeyIndicator.getEntityId(task, filterType))).addTaskAndDuration((Map<String, Object>)task));
        }
        return AggregatedDeploymentsKeyIndicator.generateReport(tasks.asMap());
    }

    private static Report generateReport(Map<String, TaskStateData> tasks) {
        Report report = new Report();
        for (Map.Entry<String, TaskStateData> entry : tasks.entrySet()) {
            ReportLine line = report.addLine();
            TaskStateData task = entry.getValue();
            line.addValue("entityName", (Object)entry.getKey());
            line.addValue("noOfSuccessfulDeployments", (Object)task.getNoOfSuccessfulDeployments().toString());
            line.addValue("noOfFailedDeployments", (Object)task.getNoOfFailedDeployments().toString());
            line.addValue("noOfAbortedDeployments", (Object)task.getNoOfAbortedDeployments().toString());
            line.addValue("noOfRollbacks", (Object)task.getNoOfRollbacks().toString());
            line.addValue("averageDuration", (Object)DeploymentsKeyIndicator.getAverageDeploymentTime(task));
        }
        return report;
    }

    private static String getEntityId(Map<String, Object> task, FilterType filterType) {
        switch (filterType) {
            case APPLICATION: {
                return (String)task.get("main_application");
            }
            case ENVIRONMENT: {
                return (String)task.get("environment");
            }
        }
        throw new IllegalArgumentException("Unsupported filter type: " + filterType);
    }
}

