/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.core.rest.api.reports.widgets;

import com.google.common.collect.Lists;
import com.xebialabs.deployit.core.api.dto.Report;
import com.xebialabs.deployit.core.rest.api.reports.widgets.DashboardWidgetBase;
import com.xebialabs.deployit.jcr.grouping.Duration;
import com.xebialabs.deployit.jcr.grouping.Function;
import com.xebialabs.deployit.jcr.grouping.GroupBy;
import com.xebialabs.deployit.task.ArchivedTaskSearchParameters;
import com.xebialabs.deployit.task.TaskType;
import com.xebialabs.deployit.task.archive.JcrTaskArchive;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import org.joda.time.DateTime;

public class Top5LongestRunningDeployments
extends DashboardWidgetBase {
    private static final String DURATIONLIST = "durationList";
    private static final String DURATION = "duration";
    private static final String ENVIRONMENT = "environment";
    private static final String APPLICATION_NAME = "application";

    public Top5LongestRunningDeployments(JcrTaskArchive taskArchive) {
        super(taskArchive);
    }

    @Override
    public Report getReport(DateTime beginDate, DateTime endDate) {
        ArchivedTaskSearchParameters sp = this.getSearchParameters().thatAreOfType(EnumSet.of(TaskType.INITIAL, TaskType.UNDEPLOY, TaskType.UPGRADE));
        sp.createdBetween(beginDate, endDate).thatCompleted();
        Collection searchResult = this.taskArchive.searchTasksWithoutLoadingSteps(sp, new GroupBy((Collection)Lists.newArrayList((Object[])new String[]{APPLICATION_NAME, ENVIRONMENT}), new Function[]{new Duration(DURATIONLIST)}));
        return this.generateDurationReport(searchResult);
    }

    Report generateDurationReport(Collection<Map<String, Object>> resultList) {
        Top5LongestRunningDeployments.calculateAverageDurations(resultList);
        ArrayList list = Lists.newArrayList(resultList);
        Collections.sort(list, new Comparator<Map<String, Object>>(){

            @Override
            public int compare(Map<String, Object> valueMap1, Map<String, Object> valueMap2) {
                Long duration1 = (Long)valueMap1.get(Top5LongestRunningDeployments.DURATION);
                Long duration2 = (Long)valueMap2.get(Top5LongestRunningDeployments.DURATION);
                return -duration1.compareTo(duration2);
            }
        });
        Report report = new Report();
        for (Map line : list.subList(0, Math.min(5, resultList.size()))) {
            Report.ReportLine reportLine = report.addLine();
            reportLine.addValue(APPLICATION_NAME, line.get(APPLICATION_NAME));
            reportLine.addValue(ENVIRONMENT, line.get(ENVIRONMENT));
            reportLine.addValue(DURATION, (Object)Top5LongestRunningDeployments.formatToMinsAndSecs((Long)line.get(DURATION)));
        }
        return report;
    }

    private static void calculateAverageDurations(Collection<Map<String, Object>> resultList) {
        for (Map<String, Object> line : resultList) {
            List durationList = (List)line.get(DURATIONLIST);
            long totalDuration = 0L;
            for (Long duration : durationList) {
                totalDuration += duration.longValue();
            }
            line.put(DURATION, totalDuration / (long)durationList.size());
        }
    }
}

