/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.core.rest.api.reports;

import com.google.common.collect.Maps;
import com.xebialabs.deployit.core.api.dto.Report;
import com.xebialabs.deployit.core.rest.api.reports.TaskArchiveReport;
import com.xebialabs.deployit.core.rest.api.reports.TaskStateData;
import com.xebialabs.deployit.engine.api.execution.TaskExecutionState;
import com.xebialabs.deployit.engine.api.execution.TaskState;
import com.xebialabs.deployit.task.ArchivedTaskSearchParameters;
import com.xebialabs.deployit.task.TaskMetadata;
import com.xebialabs.deployit.task.archive.ArchivedTask;
import com.xebialabs.deployit.task.archive.JcrTaskArchive;
import com.xebialabs.deployit.task.archive.TaskCallback;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.joda.time.DateTime;

public class DeploymentsStateBreakdownPerEnvironmentReport
extends TaskArchiveReport {
    public DeploymentsStateBreakdownPerEnvironmentReport(JcrTaskArchive taskArchive) {
        super(taskArchive);
    }

    public Report report(List<String> environments, DateTime startDate, DateTime endDate) {
        this.getSearchParameters().createdBetween(startDate, endDate);
        final HashMap tasks = Maps.newHashMap();
        for (String env : environments) {
            ArchivedTaskSearchParameters searchTasks = this.cloneSearchParameters().forEnvironment(env);
            this.taskArchive.searchTaskWithOnlyMetadata(searchTasks, new TaskCallback(){

                public void doWithTask(ArchivedTask task) {
                    DeploymentsStateBreakdownPerEnvironmentReport.addTask(tasks, (TaskState)task);
                }
            });
        }
        for (String env : environments) {
            if (tasks.containsKey(env)) continue;
            tasks.put(env, new TaskStateData());
        }
        return DeploymentsStateBreakdownPerEnvironmentReport.generateReport(tasks);
    }

    private static Report generateReport(Map<String, TaskStateData> tasks) {
        Report report = new Report();
        for (Map.Entry<String, TaskStateData> entry : tasks.entrySet()) {
            Report.ReportLine line = report.addLine();
            line.addValue("environmentName", (Object)entry.getKey());
            line.addValue("noOfSuccessfulDeployments", (Object)entry.getValue().getNoOfSuccessfulDeployments().toString());
            line.addValue("noOfFailedDeployments", (Object)entry.getValue().getNoOfFailedDeployments().toString());
        }
        return report;
    }

    private static void addTask(Map<String, TaskStateData> tasks, TaskState task) {
        String targetEntityId = TaskMetadata.getMetadata((TaskState)task, (String)"environment");
        if (task.getState().equals((Object)TaskExecutionState.DONE)) {
            if (!tasks.containsKey(targetEntityId)) {
                TaskStateData taskStateData = new TaskStateData();
                taskStateData.getNoOfSuccessfulDeployments().incrementAndGet();
                tasks.put(targetEntityId, taskStateData);
            } else {
                tasks.get(targetEntityId).getNoOfSuccessfulDeployments().incrementAndGet();
            }
        } else if (task.getState().equals((Object)TaskExecutionState.CANCELLED)) {
            if (!tasks.containsKey(targetEntityId)) {
                TaskStateData taskStateData = new TaskStateData();
                taskStateData.getNoOfAbortedDeployments().incrementAndGet();
                tasks.put(targetEntityId, taskStateData);
            } else {
                tasks.get(targetEntityId).getNoOfFailedDeployments().incrementAndGet();
            }
        }
    }
}

