/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.core.rest.api.reports.widgets;

import com.xebialabs.deployit.core.api.dto.Report;
import com.xebialabs.deployit.core.rest.api.reports.TaskStateData;
import com.xebialabs.deployit.core.rest.api.reports.widgets.DashboardWidgetBase;
import com.xebialabs.deployit.engine.api.execution.TaskWithBlock;
import com.xebialabs.deployit.task.ArchivedTaskSearchParameters;
import com.xebialabs.deployit.task.TaskMetadata;
import com.xebialabs.deployit.task.TaskType;
import com.xebialabs.deployit.task.archive.ArchivedTask;
import com.xebialabs.deployit.task.archive.JcrTaskArchive;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import org.joda.time.DateTime;

public class DeploymentsPercentageWidgetData
extends DashboardWidgetBase {
    public DeploymentsPercentageWidgetData(JcrTaskArchive taskArchive) {
        super(taskArchive);
    }

    @Override
    public Report getReport(DateTime beginDate, DateTime endDate) {
        return DeploymentsPercentageWidgetData.generateReportData(this.groupCompletedTasksByState(this.getSearchParameters().createdBetween(beginDate, endDate)));
    }

    private static Report generateReportData(TaskStateData stateData) {
        Report report = new Report();
        if (stateData.getTotalTasks() == 0) {
            return report;
        }
        Report.ReportLine line = report.addLine();
        DecimalFormat format = new DecimalFormat("#.##", DecimalFormatSymbols.getInstance(Locale.ENGLISH));
        line.addValue("noOfSuccessfulDeployments", (Object)format.format(DeploymentsPercentageWidgetData.getPercentage(stateData.getNoOfSuccessfulDeployments().get(), stateData.getTotalTasks())));
        line.addValue("noOfAbortedDeployments", (Object)format.format(DeploymentsPercentageWidgetData.getPercentage(stateData.getNoOfAbortedDeployments().get(), stateData.getTotalTasks())));
        line.addValue("noOfFailedDeployments", (Object)format.format(DeploymentsPercentageWidgetData.getPercentage(stateData.getNoOfFailedDeployments().get(), stateData.getTotalTasks())));
        line.addValue("noOfRollbacks", (Object)format.format(DeploymentsPercentageWidgetData.getPercentage(stateData.getNoOfRollbacks().get(), stateData.getTotalTasks())));
        return report;
    }

    private TaskStateData groupCompletedTasksByState(ArchivedTaskSearchParameters archivedTaskSearchParameters) {
        TaskStateData stateData = new TaskStateData();
        this.taskArchive.searchTaskWithOnlyMetadata(archivedTaskSearchParameters, task -> {
            if (task.getMetadata() != null && TaskMetadata.metadataContainsKey((TaskWithBlock)task, (String)"taskType") && TaskType.ROLLBACK.toString().equals(TaskMetadata.getMetadata((ArchivedTask)task, (String)"taskType"))) {
                stateData.getNoOfRollbacks().incrementAndGet();
            } else {
                switch (task.getState()) {
                    case DONE: {
                        if (task.getFailureCount() == 0) {
                            stateData.getNoOfSuccessfulDeployments().incrementAndGet();
                            break;
                        }
                        stateData.getNoOfFailedDeployments().incrementAndGet();
                        break;
                    }
                    case CANCELLED: {
                        stateData.getNoOfAbortedDeployments().incrementAndGet();
                        break;
                    }
                }
            }
        });
        return stateData;
    }
}

