/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.core.rest.api.reports;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.xebialabs.deployit.core.api.dto.Report;
import com.xebialabs.deployit.core.rest.api.reports.TaskArchiveReport;
import com.xebialabs.deployit.security.permission.PermissionHandler;
import com.xebialabs.deployit.task.TaskType;
import com.xebialabs.deployit.task.archive.ArchivedTask;
import com.xebialabs.deployit.task.archive.JcrTaskArchive;
import com.xebialabs.deployit.task.archive.TaskCallback;
import java.util.EnumSet;
import org.joda.time.DateTime;

public class ControlTasksReport
extends TaskArchiveReport {
    private final PermissionHandler permissionHandler;

    public ControlTasksReport(JcrTaskArchive taskArchive, DateTime startDate, DateTime endDate, PermissionHandler permissionHandler) {
        super(taskArchive);
        Preconditions.checkNotNull((Object)permissionHandler, (Object)"Argument [permissionHandler] must be set");
        this.permissionHandler = permissionHandler;
        this.getSearchParameters().inDateTimeRange(startDate, endDate);
        this.getSearchParameters().thatAreOfType(EnumSet.of(TaskType.CONTROL));
    }

    public Report createReport() {
        final Report report = new Report();
        this.taskArchive.searchTasksWithoutLoadingSteps(this.getSearchParameters(), new TaskCallback(){

            public void doWithTask(ArchivedTask t) {
                if (!Strings.isNullOrEmpty((String)((String)t.getMetadata().get("cloudOperation")))) {
                    return;
                }
                String targetCI = (String)t.getMetadata().get("controlTaskTargetCI");
                if (Strings.isNullOrEmpty((String)targetCI) && !ControlTasksReport.this.permissionHandler.isCurrentUserAdmin()) {
                    return;
                }
                if (!ControlTasksReport.this.permissionHandler.hasPermission(targetCI)) {
                    return;
                }
                Report.ReportLine line = report.addLine();
                line.addValue("taskId", (Object)t.getId());
                line.addValue("started", (Object)t.getStartDate().toString());
                line.addValue("finished", (Object)t.getCompletionDate().toString());
                line.addValue("description", (Object)t.getDescription());
                line.addValue("owner", (Object)t.getOwner());
                line.addValue("state", (Object)t.getState().name());
                for (String key : t.getMetadata().keySet()) {
                    line.addValue(key, t.getMetadata().get(key));
                }
            }
        });
        return report;
    }
}

