/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.core.rest.api.reports;

import com.xebialabs.deployit.core.api.dto.Report;
import com.xebialabs.deployit.core.rest.api.reports.ReportUtils;
import com.xebialabs.deployit.core.rest.api.reports.TaskArchiveReport;
import com.xebialabs.deployit.task.TaskType;
import com.xebialabs.deployit.task.archive.ArchivedTask;
import com.xebialabs.deployit.task.archive.JcrTaskArchive;
import org.joda.time.ReadableInstant;

public class TaskReport
extends TaskArchiveReport {
    public TaskReport(JcrTaskArchive taskArchive) {
        super(taskArchive);
    }

    public Report report() {
        final Report report = new Report();
        this.taskArchive.searchTasksWithoutLoadingSteps(this.getSearchParameters(), new JcrTaskArchive.TaskCallback(){

            public void doWithTask(ArchivedTask task) {
                Report.ReportLine line = report.addLine();
                line.addValue("taskId", (Object)task.getId());
                line.addValue("user", (Object)task.getOwner());
                line.addValue("status", (Object)task.getState().name());
                line.addValue("startDate", (Object)ReportUtils.FORMATTER.print((ReadableInstant)task.getStartDate()));
                line.addValue("completionDate", (Object)ReportUtils.FORMATTER.print((ReadableInstant)task.getCompletionDate()));
                line.addValue("package", (Object)((String)task.getMetadata().get("application") + "/" + (String)task.getMetadata().get("version")));
                line.addValue("environment", task.getMetadata().get("environment"));
                line.addValue("type", (Object)TaskReport.getTaskType(task));
            }
        });
        return report;
    }

    private static String getTaskType(ArchivedTask task) {
        String taskType = "Unknown";
        switch (TaskType.valueOf((String)((String)task.getMetadata().get("taskType")))) {
            case INITIAL: {
                taskType = "Initial";
                break;
            }
            case UPGRADE: {
                taskType = "Update";
                break;
            }
            case UNDEPLOY: {
                taskType = "Undeployment";
                break;
            }
            case ROLLBACK: {
                taskType = "Rollback";
            }
        }
        return taskType;
    }
}

