/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.core.rest.api;

import com.google.common.collect.Multimap;
import com.xebialabs.deployit.core.rest.secured.AbstractSecuredResource;
import com.xebialabs.deployit.engine.api.PermissionService;
import com.xebialabs.deployit.engine.spi.event.PermissionGrantedEvent;
import com.xebialabs.deployit.engine.spi.event.PermissionRevokedEvent;
import com.xebialabs.deployit.engine.spi.exception.DeployitException;
import com.xebialabs.deployit.engine.spi.exception.HttpResponseCodeResult;
import com.xebialabs.deployit.event.EventBusHolder;
import com.xebialabs.deployit.security.PermissionEditor;
import com.xebialabs.deployit.security.PermissionLister;
import com.xebialabs.deployit.security.Role;
import com.xebialabs.deployit.security.RoleService;
import com.xebialabs.deployit.security.permission.Permission;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;

@Controller
public class PermissionResource
extends AbstractSecuredResource
implements PermissionService {
    @Autowired
    private RoleService roleService;
    @Autowired
    private PermissionEditor permissionEditor;
    @Autowired
    private PermissionLister permissionLister;

    private static Permission getPermission(String permissionName) {
        Permission permission = Permission.find((String)permissionName);
        if (permission == null) {
            throw new UnknownPermissionException(permissionName);
        }
        return permission;
    }

    public boolean isGranted(String permission, String id, String roleName) {
        this.checkPermission(Permission.EDIT_SECURITY);
        Role role = this.roleService.getRoleForRoleName(roleName);
        Multimap stringStringMultimap = this.permissionLister.listPermissions(role);
        return stringStringMultimap.containsEntry((Object)id, (Object)permission);
    }

    public void grant(String permission, String id, String roleName) {
        this.checkPermission(Permission.EDIT_SECURITY);
        Role role = this.roleService.getRoleForRoleName(roleName);
        Multimap rolePermissions = this.permissionEditor.readPermissions(id);
        rolePermissions.put((Object)role, (Object)PermissionResource.getPermission(permission));
        this.permissionEditor.editPermissions(id, rolePermissions);
        EventBusHolder.publish((Object)new PermissionGrantedEvent(id, roleName, permission));
    }

    public void revoke(String permission, String id, String roleName) {
        this.checkPermission(Permission.EDIT_SECURITY);
        Role role = this.roleService.getRoleForRoleName(roleName);
        Multimap rolePermissions = this.permissionEditor.readPermissions(id);
        rolePermissions.remove((Object)role, (Object)PermissionResource.getPermission(permission));
        this.permissionEditor.editPermissions(id, rolePermissions);
        EventBusHolder.publish((Object)new PermissionRevokedEvent(id, roleName, permission));
    }

    public void checkMyPermission(String permission, String id) {
        this.checkPermission(PermissionResource.getPermission(permission), id);
    }

    @HttpResponseCodeResult(statusCode=400)
    public static class UnknownPermissionException
    extends DeployitException {
        public UnknownPermissionException(String permission) {
            super("Permission %s does not exist.", new Object[]{permission});
        }
    }
}

