/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.core.rest.api;

import com.xebialabs.deployit.core.rest.secured.AbstractSecuredResource;
import com.xebialabs.deployit.engine.api.PackageService;
import com.xebialabs.deployit.engine.api.dto.FileUpload;
import com.xebialabs.deployit.engine.spi.event.PackageImportedEvent;
import com.xebialabs.deployit.event.EventBusHolder;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.repository.RepositoryService;
import com.xebialabs.deployit.server.api.importer.ImportSource;
import com.xebialabs.deployit.service.importer.ImporterException;
import com.xebialabs.deployit.service.importer.ImporterService;
import com.xebialabs.deployit.service.importer.source.FileSource;
import com.xebialabs.deployit.service.importer.source.InputStreamSource;
import com.xebialabs.deployit.service.importer.source.UrlSource;
import java.io.File;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;

@Controller
public class PackageResource
extends AbstractSecuredResource
implements PackageService {
    @Autowired
    private ImporterService importerService;
    @Autowired
    private RepositoryService repositoryService;

    public List<String> list() {
        List files = this.importerService.listPackages();
        return files;
    }

    public ConfigurationItem importPackage(String file) {
        if (!this.importerService.getImportablePackageDirectory().exists()) {
            throw new ImporterException(String.format("Directory '%s' to import packages from does not exist", this.importerService.getImportablePackageDirectory().getAbsolutePath()), new Object[0]);
        }
        FileSource fileSource = new FileSource(new File(this.importerService.getImportablePackageDirectory(), file), false);
        return this.doImport((ImportSource)fileSource);
    }

    public ConfigurationItem fetch(String url) {
        try {
            UrlSource urlSource = new UrlSource(new URL(url));
            return this.doImport((ImportSource)urlSource);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    public ConfigurationItem upload(String file, FileUpload form) {
        InputStream uploadedPackage = form.getFileData();
        InputStreamSource byteArraySource = new InputStreamSource(file, uploadedPackage);
        return this.doImport((ImportSource)byteArraySource);
    }

    private ConfigurationItem doImport(ImportSource source) {
        String importedApplication = this.importerService.importPackage(source);
        ConfigurationItem read = this.repositoryService.read(importedApplication);
        EventBusHolder.publish((Object)new PackageImportedEvent(importedApplication));
        return read;
    }
}

