package com.xebialabs.deployit.core.rest.resteasy;

import org.jboss.resteasy.core.InjectorFactoryImpl;
import org.jboss.resteasy.core.MethodInjectorImpl;
import org.jboss.resteasy.spi.*;
import org.springframework.stereotype.Component;

import javax.ws.rs.WebApplicationException;
import javax.ws.rs.ext.Provider;
import java.lang.reflect.Method;

@Component
@Provider
public class WorkdirInjectorFactory extends InjectorFactoryImpl {
    private ResteasyProviderFactory factory;

    public WorkdirInjectorFactory() {
        super(ResteasyProviderFactory.getInstance());
        factory = ResteasyProviderFactory.getInstance();
    }

    public WorkdirInjectorFactory(ResteasyProviderFactory factory) {
        super(factory);
        this.factory = factory;
    }

    @Override
    public MethodInjector createMethodInjector(@SuppressWarnings("rawtypes") Class root, Method method) {
        return new WorkdirMethodInjector(root, method, factory);
    }

    public static class WorkdirMethodInjector extends MethodInjectorImpl {

        private final Method method;

        public WorkdirMethodInjector(Class<?> root, Method method, ResteasyProviderFactory factory) {
            super(root, method, factory);
            this.method = method;
        }

        @Override
        public Object invoke(HttpRequest request, HttpResponse httpResponse, Object resource) throws Failure, ApplicationException, WebApplicationException {
            try {
                Method realMethod = resource.getClass().getMethod(method.getName(), method.getParameterTypes());
                if (realMethod.isAnnotationPresent(Workdir.class)) {
                    WorkdirHolder.initWorkdir();
                }
            } catch (NoSuchMethodException ignored) {}
            return super.invoke(request, httpResponse, resource);    //To change body of overridden methods use File | Settings | File Templates.
        }
    }
}
