package com.xebialabs.deployit.core.rest.api.reports.widgets;

import com.xebialabs.deployit.task.archive.JcrTaskArchive;

public enum WidgetRegistry {

    DEPLOYMENTSUCCESS("deploymentSuccess") {
        @Override
        public final Widget getWidget(final JcrTaskArchive taskArchive) {
            return new DeploymentsPercentageWidgetData(taskArchive);
        }
    },
    DEPLOYMENTDURATION("deploymentDuration") {
        @Override
        public final Widget getWidget(final JcrTaskArchive taskArchive) {
            return new DeploymentsDurationFrequencyWidget(taskArchive);
        }
    },
    DEPLOYMENTTREND("deploymentTrend") {
        @Override
        public Widget getWidget(final JcrTaskArchive taskArchive) {
            return new DeploymentTrendsWidget(taskArchive);
        }
    },
    DEPLOYMENTTRENDPERCENTILE("deploymentTrendPercentile") {
        @Override
        public Widget getWidget(final JcrTaskArchive taskArchive) {
            return new DeploymentTrendsPercentileWidget(taskArchive);
        }
    },
    TOP5SUCCESSFULDEPLOYMENTS("top5SuccessfulDeployments") {
        @Override
        public Widget getWidget(final JcrTaskArchive taskArchive) {
            return new Top5SuccessfulDeployments(taskArchive);
        }
    },
    TOP5RETRIEDDEPLOYMENTS("top5RetriedDeployments") {
        @Override
        public Widget getWidget(final JcrTaskArchive taskArchive) {
            return new Top5RetriedDeployments(taskArchive);
        }
    },
    TOP5LONGESTRUNNINGDEPLOYMENTS("top5LongestRunningDeployments") {
        @Override
        public Widget getWidget(final JcrTaskArchive taskArchive) {
            return new Top5LongestRunningDeployments(taskArchive);
        }
    };

    private String widgetName;

    private WidgetRegistry(final String widgetName) {
        this.widgetName = widgetName;
    }

    public final String getWidgetType() {
        return widgetName;
    }

    public abstract Widget getWidget(final JcrTaskArchive taskArchive);
}
