package com.xebialabs.deployit.core.rest.api.reports;

import java.util.concurrent.atomic.AtomicInteger;

import com.xebialabs.deployit.engine.api.execution.TaskExecutionState;
import com.xebialabs.deployit.engine.api.execution.TaskState;
import com.xebialabs.deployit.task.TaskType;

public class TaskStateData {

    private AtomicInteger noOfSuccessfulDeployments = new AtomicInteger(0);
    private AtomicInteger noOfFailedDeployments = new AtomicInteger(0);
    private AtomicInteger noOfAbortedDeployments = new AtomicInteger(0);
    private AtomicInteger noOfRollbacks = new AtomicInteger(0);

    private Long averageDeploymentTime = 0L;

    public AtomicInteger getNoOfSuccessfulDeployments() {
        return noOfSuccessfulDeployments;
    }

    public void setNoOfSuccessfulDeployments(AtomicInteger noOfSuccessfulDeployments) {
        this.noOfSuccessfulDeployments = noOfSuccessfulDeployments;
    }

    public AtomicInteger getNoOfFailedDeployments() {
        return noOfFailedDeployments;
    }

    public void setNoOfFailedDeployments(AtomicInteger noOfFailedDeployments) {
        this.noOfFailedDeployments = noOfFailedDeployments;
    }

    public AtomicInteger getNoOfAbortedDeployments() {
        return noOfAbortedDeployments;
    }

    public void setNoOfAbortedDeployments(AtomicInteger noOfAbortedDeployments) {
        this.noOfAbortedDeployments = noOfAbortedDeployments;
    }

    public AtomicInteger getNoOfRollbacks() {
        return noOfRollbacks;
    }

    public Long getAverageDeploymentTime() {
        return averageDeploymentTime;
    }

    public void setAverageDeploymentTime(Long averageDeploymentTime) {
        this.averageDeploymentTime = averageDeploymentTime;
    }

    /*
     * Derived counters
     */

    public int getTotalSuccessfulTasks() {
        return noOfFailedDeployments.get() + noOfSuccessfulDeployments.get();
    }

    public int getTotalTasks() {
        return noOfAbortedDeployments.get() + noOfFailedDeployments.get() + noOfSuccessfulDeployments.get() + noOfRollbacks.get();
    }

    public void addTask(TaskState task) {
        if (TaskType.ROLLBACK.name().equals(task.getMetadata().get("taskType"))) {
            noOfRollbacks.incrementAndGet();
            return;
        }

        if (task.getState().equals(TaskExecutionState.DONE)) {
            if (task.getFailureCount() > 0) {
                noOfFailedDeployments.incrementAndGet();
            } else {
                noOfSuccessfulDeployments.incrementAndGet();
            }
        } else if (task.getState().equals(TaskExecutionState.CANCELLED)) {
            noOfAbortedDeployments.incrementAndGet();
        }
    }

    public void addTaskAndDuration(TaskState task) {
        addTask(task);
        if (task.getState().equals(TaskExecutionState.DONE)) {
            averageDeploymentTime += (task.getCompletionDate().getMillis() - task.getStartDate().getMillis());
        }
    }
}
