package com.xebialabs.deployit.core.rest.api.reports;

import java.util.Map;

import com.google.common.base.Function;
import com.google.common.collect.MapMaker;

import com.xebialabs.deployit.core.api.dto.Report;
import com.xebialabs.deployit.engine.api.execution.TaskState;
import com.xebialabs.deployit.task.archive.ArchivedTask;
import com.xebialabs.deployit.task.archive.JcrTaskArchive;
import com.xebialabs.deployit.task.archive.JcrTaskArchive.TaskCallback;

public class DeploymentsKeyIndicator extends TaskArchiveReport {

    public DeploymentsKeyIndicator(JcrTaskArchive taskArchive) {
        super(taskArchive);
    }

    @SuppressWarnings("deprecation")
    public Report report() {
        final Map<String, TaskStateData> tasks = new MapMaker().makeComputingMap(new Function<String, TaskStateData>() {
            public TaskStateData apply(String input) {
                return new TaskStateData();
            }
        });

        taskArchive.searchTasksWithoutLoadingSteps(getSearchParameters(), new TaskCallback() {
            public void doWithTask(ArchivedTask task) {
                addTask(tasks, task);
            }
        });

        return generateReport(tasks);
    }

    private static Report generateReport(Map<String, TaskStateData> tasksMap) {
        final Report report = new Report();
        for (Map.Entry<String, TaskStateData> entry : tasksMap.entrySet()) {
            TaskStateData task = entry.getValue();
            final Report.ReportLine line = report.addLine();
            line.addValue("application", entry.getKey().substring(0, entry.getKey().indexOf("~")));
            line.addValue("environment", entry.getKey().substring(entry.getKey().indexOf("~") + 1, entry.getKey().length()));
            line.addValue("noOfSuccessfulDeployments", task.getNoOfSuccessfulDeployments().toString());
            line.addValue("noOfFailedDeployments", task.getNoOfFailedDeployments().toString());
            line.addValue("noOfAbortedDeployments", task.getNoOfAbortedDeployments().toString());
            line.addValue("noOfRollbacks", task.getNoOfRollbacks().toString());
            line.addValue("averageDuration", getAverageDeploymentTime(task));
        }
        return report;
    }

    static String getAverageDeploymentTime(TaskStateData task) {
        if (task.getTotalSuccessfulTasks() > 0) {
            return ReportUtils.formatToHoursMinsSecs(task.getAverageDeploymentTime() / task.getTotalSuccessfulTasks());
        }
        return "00:00:00";
    }

    private static void addTask(Map<String, TaskStateData> tasks, TaskState task) {
        String entityId = task.getMetadata().get("application") + "~" + task.getMetadata().get("environment");
        tasks.get(entityId).addTaskAndDuration(task);
    }
}
