package com.xebialabs.deployit.core.rest.api;

import com.xebialabs.deployit.engine.api.execution.TaskExecutionState;
import com.xebialabs.deployit.engine.api.execution.TaskState;
import com.xebialabs.deployit.engine.api.execution.TaskWithSteps;
import org.joda.time.DateTime;

import java.util.Map;

public class TaskStateView implements TaskState {
    private TaskWithSteps wrapped;

    public TaskStateView(TaskWithSteps wrapped) {
        this.wrapped = wrapped;
    }

    @Override
    public TaskExecutionState getState() {
        return wrapped.getState();
    }

    @Override
    public String getId() {
        return wrapped.getId();
    }

    @Override
    public String getDescription() {
        return wrapped.getDescription();
    }

    @Override
    public DateTime getStartDate() {
        return wrapped.getStartDate();
    }

    @Override
    public DateTime getCompletionDate() {
        return wrapped.getCompletionDate();
    }

    @Override
    public int getNrSteps() {
        return wrapped.getNrSteps();
    }

    @Override
    public int getCurrentStepNr() {
        return wrapped.getCurrentStepNr();
    }

    @Override
    public Map<String, String> getMetadata() {
        return wrapped.getMetadata();
    }

    @Override
    public int getFailureCount() {
        return wrapped.getFailureCount();
    }

    @Override
    public String getOwner() {
        return wrapped.getOwner();
    }
}
