package com.xebialabs.deployit.core.rest.api;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;

import com.xebialabs.deployit.core.api.PackageExportProxy;
import com.xebialabs.deployit.core.rest.resteasy.Workdir;
import com.xebialabs.deployit.core.rest.resteasy.WorkdirHolder;
import com.xebialabs.deployit.core.rest.secured.AbstractSecuredResource;
import com.xebialabs.deployit.repository.WorkDir;
import com.xebialabs.deployit.service.version.exporter.ExporterService;
import com.xebialabs.overthere.local.LocalFile;

/**
 * I am A REST resource that exposes functionality of exporting a deployment
 * package version.
 */
@Controller
public class PackageExportResource extends AbstractSecuredResource implements PackageExportProxy {

    @Autowired
    private ExporterService exporterService;

    @Autowired
    private DownloadResource downloadResource;

    @Override
    @Workdir
    public String exportDar(final String id) {
        WorkDir workDir = WorkdirHolder.get();
        try {
            LocalFile file = exporterService.exportDar(id, workDir);
            return downloadResource.register(file.getFile(), workDir, "application/zip");
        } catch (RuntimeException re) {
            workDir.delete();
            throw re;
        }
    }
}
