package com.xebialabs.deployit.core.rest.api;

import java.util.List;

import org.springframework.stereotype.Controller;

import com.google.common.base.Function;
import com.google.common.base.Predicate;

import com.xebialabs.deployit.deployment.orchestrator.OrchestratorRegistry;
import com.xebialabs.deployit.engine.api.MetadataService;
import com.xebialabs.deployit.plugin.api.reflect.Descriptor;
import com.xebialabs.deployit.plugin.api.reflect.DescriptorRegistry;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.security.permission.Permission;

import static com.google.common.collect.Collections2.filter;
import static com.google.common.collect.Collections2.transform;
import static com.google.common.collect.Lists.newArrayList;

@Controller
public class MetadataResource implements MetadataService {

    private final static Predicate<Descriptor> NO_VIRTUAL_TYPES = new Predicate<Descriptor>() {
        @Override
        public boolean apply(Descriptor input) {
            return !input.isVirtual();
        }
    };

    @Override
    public List<Descriptor> listDescriptors() {
        return newArrayList(filter(DescriptorRegistry.getDescriptors(), NO_VIRTUAL_TYPES));
    }

    @Override
    public Descriptor findDescriptor(Type type) {
        return DescriptorRegistry.getDescriptor(type);
    }

    @Override
    public List<com.xebialabs.deployit.engine.api.security.Permission> listPermissions() {
        return DtoWriter.writeReferenceDataPermissions(Permission.values());
    }

    @Override
    public List<String> listOrchestrators() {
        return newArrayList(OrchestratorRegistry.all());
    }
}
