package com.xebialabs.deployit.core.rest.api;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import com.xebialabs.deployit.core.api.dto.RolePermissions;
import com.xebialabs.deployit.core.api.dto.RolePrincipals;
import com.xebialabs.deployit.engine.api.security.Role;
import com.xebialabs.deployit.security.permission.Permission;
import org.springframework.stereotype.Component;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;

import static com.google.common.collect.Lists.newArrayList;
import static com.google.common.collect.Lists.transform;

@Component
public class DtoWriter {
    public List<Role> writeRoles(List<com.xebialabs.deployit.security.Role> roles) {
        return newArrayList(transform(roles, new Function<com.xebialabs.deployit.security.Role, Role>() {
            public Role apply(com.xebialabs.deployit.security.Role input) {
                return writeRole(input);
            }
        }));
    }

    private static Role writeRole(com.xebialabs.deployit.security.Role role) {
        return new Role(role.getId(), role.getName());
    }

    public List<RolePrincipals> writeRoleAssignments(List<com.xebialabs.deployit.security.Role> roles) {
        List<RolePrincipals> assignments = newArrayList();
        for (com.xebialabs.deployit.security.Role role : roles) {
            assignments.add(new RolePrincipals(writeRole(role), newArrayList(role.getPrincipalsAssigned())));
        }
        return assignments;
    }

    public List<RolePermissions> writeRolePermissions(Multimap<com.xebialabs.deployit.security.Role, Permission> multimap) {
        List<RolePermissions> permissions = newArrayList();
        for (com.xebialabs.deployit.security.Role role : multimap.keySet()) {
            permissions.add(new RolePermissions(writeRole(role), writePermissions(multimap.get(role))));
        }

        return permissions;
    }

    private static List<String> writePermissions(Collection<Permission> permissions) {
        return newArrayList(Iterables.transform(permissions, new Function<Permission, String>() {
            public String apply(Permission input) {
                return input.getPermissionName();
            }
        }));
    }

    public static List<com.xebialabs.deployit.engine.api.security.Permission> writeReferenceDataPermissions(Permission[] values) {
        return newArrayList(Iterables.transform(Arrays.asList(values), new Function<Permission, com.xebialabs.deployit.engine.api.security.Permission>() {
            public com.xebialabs.deployit.engine.api.security.Permission apply(Permission input) {
                String rootNodeName = input.getRoot() != null ? input.getRoot().getRootNodeName() : null;
                return new com.xebialabs.deployit.engine.api.security.Permission(input.getPermissionName(), input.getLevel().name(), rootNodeName);
            }
        }));
    }
}
