package com.xebialabs.deployit.core.rest.api;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import com.xebialabs.deployit.core.rest.resteasy.Workdir;
import com.xebialabs.deployit.core.rest.resteasy.WorkdirHolder;
import com.xebialabs.deployit.core.rest.secured.AbstractSecuredResource;
import com.xebialabs.deployit.engine.api.ControlService;
import com.xebialabs.deployit.engine.api.dto.Control;
import com.xebialabs.deployit.engine.spi.event.TaskCreatedEvent;
import com.xebialabs.deployit.engine.spi.exception.DeployitException;
import com.xebialabs.deployit.engine.spi.exception.HttpResponseCodeResult;
import com.xebialabs.deployit.engine.tasker.Engine;
import com.xebialabs.deployit.engine.tasker.TaskSpecification;
import com.xebialabs.deployit.event.EventBusHolder;
import com.xebialabs.deployit.plugin.api.reflect.MethodDescriptor;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.repository.RepositoryService;
import com.xebialabs.deployit.security.permission.Permission;
import com.xebialabs.deployit.service.controltask.ControlTaskService;

@Component
public class ControlTaskResource extends AbstractSecuredResource implements ControlService {
    @Autowired
    private RepositoryService repository;

    @Autowired
    private ControlTaskService controlTaskService;

    @Autowired
    private Engine engine;

    @Override
    public Control prepare(String controlName, String id) {
        checkPermission(Permission.CONTROLTASK_EXECUTE);
        ConfigurationItem configurationItem = repository.read(id);
        MethodDescriptor controlTask = configurationItem.getType().getDescriptor().getControlTask(controlName);
        if (controlTask == null) {
            throw new InvalidControlException("Control [%s] could  not be found on type [%s]", controlName, configurationItem.getType());
        }
        return new Control(configurationItem, controlName);
    }

    @Override
    @Workdir
    public String createTask(Control control) {
        checkPermission(Permission.CONTROLTASK_EXECUTE);
        try {
            TaskSpecification taskSpecification = controlTaskService.prepareControlTask(control.getConfigurationItem(), control.getControlName(), WorkdirHolder.get());
            String taskId = engine.register(taskSpecification);

            EventBusHolder.publish(new TaskCreatedEvent(taskId, control.getControlName(), control.getConfigurationItem().getId()));

            return taskId;
        } catch (RuntimeException e) {
            WorkdirHolder.get().delete();
            throw e;
        }
    }

    @SuppressWarnings("serial")
    @HttpResponseCodeResult(statusCode = 400)
    public static class InvalidControlException extends DeployitException {
        public InvalidControlException(String messageTemplate, Object... params) {
            super(messageTemplate, params);
        }
    }
}
