/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.core.rest.api;

import com.google.common.collect.Multimap;
import com.xebialabs.deployit.core.api.SecurityProxy;
import com.xebialabs.deployit.core.api.dto.PrincipalPermissions;
import com.xebialabs.deployit.core.api.dto.RoleAssignment;
import com.xebialabs.deployit.core.api.dto.RoleAssignments;
import com.xebialabs.deployit.core.api.dto.RolePermission;
import com.xebialabs.deployit.core.api.dto.RolePermissions;
import com.xebialabs.deployit.core.api.dto.Roles;
import com.xebialabs.deployit.core.api.resteasy.http.tunnel.ResponseFactory;
import com.xebialabs.deployit.core.rest.api.DtoReader;
import com.xebialabs.deployit.core.rest.api.DtoWriter;
import com.xebialabs.deployit.core.rest.secured.AbstractSecuredResource;
import com.xebialabs.deployit.exception.DeployitException;
import com.xebialabs.deployit.exception.HttpResponseCodeResult;
import com.xebialabs.deployit.security.PermissionEditor;
import com.xebialabs.deployit.security.PermissionLister;
import com.xebialabs.deployit.security.Permissions;
import com.xebialabs.deployit.security.Role;
import com.xebialabs.deployit.security.RoleService;
import com.xebialabs.deployit.security.permission.Permission;
import java.util.List;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.Authentication;
import org.springframework.stereotype.Controller;

@Controller
public class SecurityResource
extends AbstractSecuredResource
implements SecurityProxy {
    @Autowired
    private RoleService roleService;
    @Autowired
    private PermissionEditor permissionEditor;
    @Autowired
    private PermissionLister permissionLister;
    @Autowired
    private DtoWriter dtoWriter;
    @Autowired
    private DtoReader dtoReader;
    private static final Logger logger = LoggerFactory.getLogger(SecurityResource.class);

    public Response logout() {
        return ResponseFactory.ok().build();
    }

    public Response getGrantedPermissions(String id) {
        this.checkPermission(Permission.EDIT_SECURITY);
        if (id.equals("global")) {
            logger.debug("Requested global permissions.");
            id = "";
        }
        Multimap rolePermissionMultimap = this.permissionEditor.readPermissions(id);
        List<RolePermission> rolePermissions = this.dtoWriter.writeRolePermissions((Multimap<Role, Permission>)rolePermissionMultimap);
        return ResponseFactory.ok((Object)new RolePermissions(rolePermissions)).build();
    }

    public Response writeGrantedPermissions(String id, RolePermissions permissions) {
        this.checkPermission(Permission.EDIT_SECURITY);
        if (id.equals("global")) {
            logger.debug("Writing global permissions");
            id = "";
        }
        List roles = this.roleService.readRoles();
        Multimap<Role, Permission> multimap = this.dtoReader.readRolePermissions(permissions, roles);
        this.permissionEditor.editPermissions(id, multimap);
        return ResponseFactory.ok().build();
    }

    public Response getRoleAssignments() {
        this.checkPermission(Permission.EDIT_SECURITY);
        List multimap = this.roleService.readRoleAssignments();
        logger.debug("RoleService delivered roles: {}", (Object)multimap);
        List<RoleAssignment> assignments = this.dtoWriter.writeRoleAssignments(multimap);
        logger.debug("Going to return the following roles: {}", assignments);
        return ResponseFactory.ok((Object)new RoleAssignments(assignments)).build();
    }

    public Response writeRoleAssignments(RoleAssignments assignments) {
        this.checkPermission(Permission.EDIT_SECURITY);
        logger.debug("Got the following roles: {}", (Object)assignments);
        List<Role> roles = this.dtoReader.readRoleAssignments(assignments);
        logger.debug("Going to write the following role assignments: {}", roles);
        this.roleService.writeRoleAssignments(roles);
        return ResponseFactory.ok().build();
    }

    public Response getRoles() {
        List roles = this.roleService.readRoles();
        return ResponseFactory.ok((Object)new Roles(this.dtoWriter.writeRoles(roles))).build();
    }

    public Response hasPermission(String permission, String id) {
        this.checkPermission(Permission.find((String)permission), id);
        return ResponseFactory.ok().build();
    }

    public Response retrievePermissions(String roleName) {
        Role role = this.roleService.getRoleForRoleName(roleName);
        Multimap grantedPermissions = this.permissionLister.listPermissions(role);
        PrincipalPermissions entity = new PrincipalPermissions(roleName, grantedPermissions);
        return ResponseFactory.ok((Object)entity).build();
    }

    public Response retrievePermissionsForCurrentUser() {
        Authentication authentication = Permissions.getAuthentication();
        List roles = this.roleService.getRolesFor(authentication);
        Multimap grantedPermissions = this.permissionLister.listPermissions(roles);
        PrincipalPermissions entity = new PrincipalPermissions(authentication.getName(), grantedPermissions);
        return ResponseFactory.ok((Object)entity).build();
    }

    private Permission getPermission(String permissionName) {
        Permission permission = Permission.find((String)permissionName);
        if (permission == null) {
            throw new UnknownPermissionException(permissionName);
        }
        return permission;
    }

    @HttpResponseCodeResult(statusCode=400)
    public static class UnknownPermissionException
    extends DeployitException {
        public UnknownPermissionException(String permission) {
            super("Permission %s does not exist.", new Object[]{permission});
        }
    }
}

