package com.xebialabs.deployit.core.rest.api;

import java.util.Collection;
import javax.ws.rs.core.Response;
import org.springframework.stereotype.Controller;
import org.springframework.beans.factory.annotation.Autowired;
import com.xebialabs.deployit.task.TaskArchive;
import com.xebialabs.deployit.task.DeploymentTaskInfo;
import com.xebialabs.deployit.core.api.ExportProxy;
import com.xebialabs.deployit.core.api.dto.FullTaskInfos;
import com.xebialabs.deployit.core.api.resteasy.Date;
import com.xebialabs.deployit.core.api.resteasy.http.tunnel.ResponseFactory;
import com.xebialabs.deployit.task.ArchivedTaskSearchParameters;
import static com.xebialabs.deployit.checks.Checks.checkNotNull;


@Controller
public class ExportResource implements ExportProxy {

	@Autowired
	private TaskArchive taskArchive;
	
	@Autowired
	private DtoWriter dtoConverter;
	
	@Override
	public Response getFullArchivedTasks() {
		return ResponseFactory.ok(getFullTaskInfos(new ArchivedTaskSearchParameters())).build();
	}
	
	@Override
	public Response getFullArchivedTasksInDateRange(final Date beginDate, final Date endDate) {
		checkNotNull(beginDate, "beginDate");
		checkNotNull(endDate, "endDate");
		
		ArchivedTaskSearchParameters taskSearchParameters = new ArchivedTaskSearchParameters();
		taskSearchParameters.createdBetween(beginDate.getCalendar(), endDate.getCalendar());
		return ResponseFactory.ok(getFullTaskInfos(taskSearchParameters)).build();
	}

	private final FullTaskInfos getFullTaskInfos(final ArchivedTaskSearchParameters taskSearchParameters){
		FullTaskInfos fullTaskInfos = new FullTaskInfos();
		Collection<DeploymentTaskInfo> allTasks = taskArchive.searchTasks(taskSearchParameters);
		for (DeploymentTaskInfo deploymentTaskInfo : allTasks){
			fullTaskInfos.addTask(dtoConverter.fullArchivedTaskToDto(deploymentTaskInfo));
		}
		return fullTaskInfos;
	};
}