/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.core.rest.api.reports;

import com.xebialabs.deployit.core.api.dto.Report;
import com.xebialabs.deployit.core.api.resteasy.Date;
import com.xebialabs.deployit.task.ArchivedTaskSearchParameters;
import com.xebialabs.deployit.task.DeploymentTaskInfo;
import com.xebialabs.deployit.task.TaskArchive;
import com.xebialabs.deployit.task.jcrarchive.JcrTaskArchive;

public class TasksInDateRangeReport {
    private TaskArchive taskArchive;

    public TasksInDateRangeReport(TaskArchive taskArchive) {
        this.taskArchive = taskArchive;
    }

    public Report report(Date begin, Date end) {
        ArchivedTaskSearchParameters searchTasks = new ArchivedTaskSearchParameters();
        searchTasks.createdBetween(begin.getCalendar(), end.getCalendar());
        final Report report = new Report();
        this.taskArchive.searchTasksWithoutLoadingSteps(searchTasks, new JcrTaskArchive.TaskCallback(){

            public void doWithTask(DeploymentTaskInfo task) {
                Report.ReportLine reportLine = report.addLine();
                reportLine.addValue("user", (Object)task.getOwner());
                reportLine.addValue("status", (Object)task.getState().name());
                reportLine.addValue("startDate", (Object)new Date(task.getStartDate(), "yyyy-MM-dd'T'HH:mm:ss.SSSZ").toString());
                reportLine.addValue("completionDate", (Object)new Date(task.getCompletionDate(), "yyyy-MM-dd'T'HH:mm:ss.SSSZ").toString());
                reportLine.addValue("package", (Object)(task.getApplicationName() + "/" + task.getApplicationVersion()));
                reportLine.addValue("environment", (Object)task.getEnvironment());
                TasksInDateRangeReport.this.fillDeploymentType(reportLine, task);
            }
        });
        return report;
    }

    private void fillDeploymentType(Report.ReportLine reportLine, DeploymentTaskInfo task) {
        String taskType = "Unknown";
        switch (task.getDeploymentType()) {
            case INITIAL: {
                taskType = "Initial";
                break;
            }
            case UPGRADE: {
                taskType = "Upgrade";
                break;
            }
            case UNDEPLOY: {
                taskType = "Undeployment";
            }
        }
        reportLine.addValue("type", (Object)taskType);
    }
}

