/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.core.rest.api.reports;

import com.google.common.collect.Maps;
import com.xebialabs.deployit.core.api.dto.Report;
import com.xebialabs.deployit.core.api.resteasy.Date;
import com.xebialabs.deployit.core.rest.api.reports.TaskStateData;
import com.xebialabs.deployit.task.ArchivedTaskSearchParameters;
import com.xebialabs.deployit.task.DeploymentTaskInfo;
import com.xebialabs.deployit.task.Task;
import com.xebialabs.deployit.task.TaskArchive;
import com.xebialabs.deployit.task.jcrarchive.JcrTaskArchive;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DeploymentsStateBreakdownPerEnvironmentReport {
    private TaskArchive taskArchive;

    public DeploymentsStateBreakdownPerEnvironmentReport(TaskArchive taskArchive) {
        this.taskArchive = taskArchive;
    }

    public Report report(List<String> environments, Date startDate, Date endDate) {
        ArchivedTaskSearchParameters searchTasks = new ArchivedTaskSearchParameters();
        searchTasks.createdBetween(startDate.getCalendar(), endDate.getCalendar());
        final HashMap tasksMap = Maps.newHashMap();
        for (String env : environments) {
            searchTasks.toEnvironment(env);
            this.taskArchive.searchTasksWithoutLoadingSteps(searchTasks, new JcrTaskArchive.TaskCallback(){

                public void doWithTask(DeploymentTaskInfo task) {
                    DeploymentsStateBreakdownPerEnvironmentReport.this.createTasksMap(tasksMap, task);
                }
            });
        }
        for (String env : environments) {
            if (tasksMap.containsKey(env)) continue;
            tasksMap.put(env, new TaskStateData());
        }
        return this.generateReportDataFromTaskMap(tasksMap);
    }

    private Report generateReportDataFromTaskMap(Map<String, TaskStateData> tasksMap) {
        Report report = new Report();
        for (Map.Entry<String, TaskStateData> entry : tasksMap.entrySet()) {
            Report.ReportLine reportLine = report.addLine();
            reportLine.addValue("environmentName", (Object)entry.getKey());
            reportLine.addValue("noOfSuccessfulDeployments", (Object)entry.getValue().getNoOfSuccessfulDeployments().toString());
            reportLine.addValue("noOfFailedDeployments", (Object)entry.getValue().getNoOfFailedDeployments().toString());
        }
        return report;
    }

    private void createTasksMap(Map<String, TaskStateData> tasksMap, DeploymentTaskInfo task) {
        String targetEntityId = task.getEnvironment();
        if (task.getState().equals((Object)Task.State.DONE)) {
            if (!tasksMap.containsKey(targetEntityId)) {
                TaskStateData taskStateData = new TaskStateData();
                taskStateData.getNoOfSuccessfulDeployments().incrementAndGet();
                tasksMap.put(targetEntityId, taskStateData);
            } else {
                tasksMap.get(targetEntityId).getNoOfSuccessfulDeployments().incrementAndGet();
            }
        } else if (task.getState().equals((Object)Task.State.CANCELLED)) {
            if (!tasksMap.containsKey(targetEntityId)) {
                TaskStateData taskStateData = new TaskStateData();
                taskStateData.getNoOfAbortedDeployments().incrementAndGet();
                tasksMap.put(targetEntityId, taskStateData);
            } else {
                tasksMap.get(targetEntityId).getNoOfFailedDeployments().incrementAndGet();
            }
        }
    }
}

