/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.core.rest.api.reports;

import com.google.common.base.Function;
import com.google.common.collect.MapMaker;
import com.xebialabs.deployit.core.api.dto.ConfigurationItemId;
import com.xebialabs.deployit.core.api.dto.Report;
import com.xebialabs.deployit.core.api.resteasy.Date;
import com.xebialabs.deployit.core.rest.api.reports.ReportFilterType;
import com.xebialabs.deployit.core.rest.api.reports.ReportUtils;
import com.xebialabs.deployit.core.rest.api.reports.TaskStateData;
import com.xebialabs.deployit.task.ArchivedTaskSearchParameters;
import com.xebialabs.deployit.task.DeploymentTaskInfo;
import com.xebialabs.deployit.task.TaskArchive;
import com.xebialabs.deployit.task.jcrarchive.JcrTaskArchive;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;

public class AggregatedDeploymentsKeyIndicator {
    private TaskArchive taskArchive;

    public AggregatedDeploymentsKeyIndicator(TaskArchive taskArchive) {
        this.taskArchive = taskArchive;
    }

    public Report report(Date startDate, Date endDate, final ReportFilterType filterType, List<ConfigurationItemId> filterCriteria) {
        final ConcurrentMap tasksMap = new MapMaker().makeComputingMap((Function)new Function<String, TaskStateData>(){

            public TaskStateData apply(String input) {
                return new TaskStateData();
            }
        });
        ArchivedTaskSearchParameters searchTasks = new ArchivedTaskSearchParameters();
        searchTasks.createdBetween(startDate.getCalendar(), endDate.getCalendar());
        for (ConfigurationItemId appOrEnvName : filterCriteria) {
            switch (filterType) {
                case APPLICATION: {
                    searchTasks.forApplication(appOrEnvName.getId());
                    break;
                }
                case ENVIRONMENT: {
                    searchTasks.toEnvironment(appOrEnvName.getId());
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Report filter type, " + (Object)((Object)filterType) + " is not supported");
                }
            }
            this.taskArchive.searchTasksWithoutLoadingSteps(searchTasks, new JcrTaskArchive.TaskCallback(){

                public void doWithTask(DeploymentTaskInfo task) {
                    AggregatedDeploymentsKeyIndicator.this.fillTasksMap(tasksMap, task, filterType);
                }
            });
        }
        return this.generateReportDataFromTaskMap(tasksMap);
    }

    private Report generateReportDataFromTaskMap(Map<String, TaskStateData> tasksMap) {
        Report report = new Report();
        for (Map.Entry<String, TaskStateData> entry : tasksMap.entrySet()) {
            Report.ReportLine reportLine = report.addLine();
            reportLine.addValue("entityName", (Object)entry.getKey());
            reportLine.addValue("noOfSuccessfulDeployments", (Object)entry.getValue().getNoOfSuccessfulDeployments().toString());
            reportLine.addValue("noOfFailedDeployments", (Object)entry.getValue().getNoOfFailedDeployments().toString());
            reportLine.addValue("noOfAbortedDeployments", (Object)entry.getValue().getNoOfAbortedDeployments().toString());
            String averageDeploymentTime = "00:00:00";
            if (entry.getValue().getTotalSuccessfulTasks() > 0) {
                averageDeploymentTime = ReportUtils.formatToHoursMinsSecs(entry.getValue().getAverageDeploymentTime() / (long)entry.getValue().getTotalSuccessfulTasks());
            }
            reportLine.addValue("averageDuration", (Object)averageDeploymentTime);
        }
        return report;
    }

    private void fillTasksMap(Map<String, TaskStateData> tasksMap, DeploymentTaskInfo task, ReportFilterType filterType) {
        String entityId = this.getEntityId(task, filterType);
        TaskStateData taskStateData = tasksMap.get(entityId);
        taskStateData.addTaskAndDuration(task);
    }

    private String getEntityId(DeploymentTaskInfo task, ReportFilterType filterType) {
        switch (filterType) {
            case APPLICATION: {
                return task.getApplicationName();
            }
            case ENVIRONMENT: {
                return task.getEnvironment();
            }
        }
        throw new IllegalArgumentException("Unknown filter type: " + (Object)((Object)filterType));
    }
}

