/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.core.rest.api;

import com.xebialabs.deployit.core.api.UserProxy;
import com.xebialabs.deployit.core.api.dto.User;
import com.xebialabs.deployit.core.api.resteasy.http.tunnel.ResponseFactory;
import com.xebialabs.deployit.core.rest.secured.AbstractSecuredResource;
import com.xebialabs.deployit.security.JcrUser;
import com.xebialabs.deployit.security.UserService;
import com.xebialabs.deployit.security.permission.Permission;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;

@Controller
public class UserResource
extends AbstractSecuredResource
implements UserProxy {
    @Autowired
    UserService userService;
    private static final Logger logger = LoggerFactory.getLogger(UserResource.class);

    public Response create(String username, User user) {
        this.checkPermission(Permission.EDIT_SECURITY);
        this.sanityCheckUser(username, user);
        logger.debug("Creating user {}", (Object)username);
        this.userService.create(username, user.getPassword());
        JcrUser u = this.userService.read(username);
        logger.debug("Created user {}", (Object)u.getUsername());
        return ResponseFactory.created((Object)new User(u.getUsername(), u.isAdmin())).build();
    }

    public Response read(String username) {
        this.checkPermission(Permission.EDIT_SECURITY);
        JcrUser u = this.userService.read(username);
        return ResponseFactory.ok((Object)new User(u.getUsername(), u.isAdmin())).build();
    }

    public Response modifyPassword(String username, User user) {
        this.checkPermission(Permission.EDIT_SECURITY);
        this.sanityCheckUser(username, user);
        this.userService.modifyPassword(username, user.getPassword());
        return ResponseFactory.noContent().build();
    }

    public Response delete(String username) {
        this.checkPermission(Permission.EDIT_SECURITY);
        this.userService.delete(username);
        return ResponseFactory.noContent().build();
    }

    private void sanityCheckUser(String username, User user) {
        if (user.getUsername() != null && !user.getUsername().equals(username)) {
            throw new IllegalArgumentException("Username in URL is " + username + " but username in POST data is " + user.getUsername());
        }
    }
}

