package com.xebialabs.deployit.core.rest.api.reports.widgets;

import static com.google.common.base.Preconditions.checkArgument;
import static com.google.common.collect.Maps.newLinkedHashMap;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.TimeUnit;

import com.google.common.base.Function;
import com.xebialabs.deployit.core.api.resteasy.Date;
import com.xebialabs.deployit.task.TaskArchive;

abstract class DashboardWidgetBase implements Widget {

	protected TaskArchive taskArchive;
	
	final SimpleDateFormat monthFormat = new SimpleDateFormat("MMM", Locale.ENGLISH);
	
	protected final double getPercentage(final double numOfTasksInAState, final double totalTasks) {
		checkArgument(numOfTasksInAState <= totalTasks,
		        "Number of deplyments in a state passed to the percentage function cannot be greater than total number of deployments! numOfDeployment :"
		                + numOfTasksInAState + "totalDeployment:" + totalTasks);
		return (totalTasks == 0) ? 0 : (numOfTasksInAState / totalTasks ) * 100;
	}

	final String formatToMinsAndSecs(final long millis) {
		final long secs = TimeUnit.MILLISECONDS.toSeconds(millis) - TimeUnit.MINUTES.toSeconds(TimeUnit.MILLISECONDS.toMinutes(millis));
		String seconds = String.valueOf(secs);
		if(secs < 10) {
			seconds = "0" + seconds;
		}
		return String.format("%d:%s", TimeUnit.MILLISECONDS.toMinutes(millis), seconds);
	}

	protected final String formatToSecs(final long millis) {
		final long seconds = TimeUnit.MILLISECONDS.toSeconds(millis);
		return String.format("%d", seconds);
	}

	protected final String formatToMins(final long millis) {
		long minutes = TimeUnit.MILLISECONDS.toMinutes(millis);
		final long seconds = TimeUnit.MILLISECONDS.toSeconds(millis) - TimeUnit.MINUTES.toSeconds(minutes);
		if (seconds >= 30) {
			minutes++;
		}
		return String.format("%d", minutes);
	}

	protected final String formatToHours(final long millis) {
		long hours = TimeUnit.MILLISECONDS.toHours(millis);
		final long minutes = TimeUnit.MILLISECONDS.toMinutes(millis) - TimeUnit.HOURS.toMinutes(hours);
		if (minutes >= 30) {
			hours++;
		}
		return String.format("%d", hours);
	}
	
	protected <T> Map<String, T> initializeMap(Date begin, Date end, Function<String, T> f) {
		Map<String, T> groupedTasks = newLinkedHashMap();
		final Calendar month = (Calendar) begin.getCalendar().clone();
		month.set(Calendar.DAY_OF_MONTH, 1);
		final Calendar endMonth = (Calendar) end.getCalendar().clone();
		endMonth.set(Calendar.DAY_OF_MONTH, 1);
		for (; month.compareTo(endMonth) <= 0; month.add(Calendar.MONTH, 1)) {
			String mnth = monthFormat.format(month.getTime());
			groupedTasks.put(mnth, f.apply(mnth));
		}

		return groupedTasks;
	}

}
