package com.xebialabs.deployit.core.rest.api;

import com.xebialabs.deployit.core.api.ReferenceDataProxy;
import com.xebialabs.deployit.core.api.dto.ConfigurationItemDescriptorDto;
import com.xebialabs.deployit.core.api.dto.ConfigurationItemDescriptorList;
import com.xebialabs.deployit.core.api.dto.Orchestrators;
import com.xebialabs.deployit.core.api.dto.Permissions;
import com.xebialabs.deployit.core.api.resteasy.http.tunnel.ResponseFactory;
import com.xebialabs.deployit.plugin.api.reflect.Descriptor;
import com.xebialabs.deployit.plugin.api.reflect.DescriptorRegistry;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.security.permission.Permission;
import com.xebialabs.deployit.server.api.orchestrator.OrchestratorRegistry;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;

import javax.ws.rs.PathParam;
import javax.ws.rs.core.Response;
import java.util.ArrayList;
import java.util.List;

import static com.google.common.collect.Lists.newArrayList;

@Controller
public class ReferenceDataResource implements ReferenceDataProxy {

	@Autowired
	private DtoWriter dtoWriter;

	@Override
	public Response list() {
		ConfigurationItemDescriptorList descriptorList = new ConfigurationItemDescriptorList();
		List<ConfigurationItemDescriptorDto> descriptors = new ArrayList<ConfigurationItemDescriptorDto>();
		for (Descriptor descriptor : DescriptorRegistry.getDescriptors()) {
			if(!descriptor.isVirtual()) {
				ConfigurationItemDescriptorDto descriptorDto = dtoWriter.descriptorToDto(descriptor);
				descriptors.add(descriptorDto);
			}
		}
		descriptorList.setDescriptors(descriptors);
		return ResponseFactory.ok(descriptorList).build();
	}

	@Override
	public Response find(@PathParam("type") final String type) {
		final Descriptor descriptor = DescriptorRegistry.getDescriptor(Type.valueOf(type));
		final ConfigurationItemDescriptorDto dto = dtoWriter.descriptorToDto(descriptor);
		return ResponseFactory.ok(dto).build();
	}

	@Override
	public Response permissionList() {
		return ResponseFactory.ok(new Permissions(dtoWriter.writeReferenceDataPermissions(Permission.values()))).build();
	}

	@Override
	public Response orchestrators() {
		return ResponseFactory.ok(new Orchestrators(OrchestratorRegistry.all())).build();
	}
}
