/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.core.rest.resteasy;

import com.xebialabs.deployit.core.api.dto.Report;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.Provider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Provider
@Component
@Produces(value={"text/csv"})
public class CsvMessageProvider
implements MessageBodyWriter<Object> {
    private static final String CSV_SEPERATOR = ",";
    private static final String LINE_SEPERATOR = "\n";
    private static Logger logger = LoggerFactory.getLogger(CsvMessageProvider.class);

    public long getSize(Object object, Class<?> clazz, Type type, Annotation[] annotationArray, MediaType mediaType) {
        return -1L;
    }

    public boolean isWriteable(Class<?> clazz, Type type, Annotation[] annotationArray, MediaType mediaType) {
        return clazz.isAssignableFrom(Report.class) && mediaType.getType().equals("text") && mediaType.getSubtype().equals("csv");
    }

    public void writeTo(Object object, Class<?> clazz, Type type, Annotation[] annotationArray, MediaType mediaType, MultivaluedMap<String, Object> multivaluedMap, OutputStream outputStream) throws IOException, WebApplicationException {
        logger.debug("Entering CsvMessageProvider...");
        String string = this.convertReportToCsvFormat((Report)object);
        outputStream.write(string.getBytes());
    }

    private String convertReportToCsvFormat(Report report) {
        StringBuilder stringBuilder = new StringBuilder();
        List list = report.getLines();
        if (list.size() > 0) {
            this.appendReportHeader(stringBuilder, list);
            this.appendReportRows(stringBuilder, list);
        }
        return stringBuilder.toString();
    }

    private void appendReportHeader(StringBuilder stringBuilder, List<Report.ReportLine> list) {
        Report.ReportLine reportLine = list.iterator().next();
        if (reportLine != null) {
            Iterator iterator;
            Map map = reportLine.getValues();
            Iterator iterator2 = iterator = new TreeSet(map.keySet()).iterator();
            while (iterator2.hasNext()) {
                String string = (String)iterator2.next();
                stringBuilder.append(this.encloseInQuotes(string));
                if (!iterator2.hasNext()) continue;
                stringBuilder.append(CSV_SEPERATOR);
            }
            stringBuilder.append(LINE_SEPERATOR);
        }
    }

    private String encloseInQuotes(String string) {
        return "\"" + string + "\"";
    }

    private void appendReportRows(StringBuilder stringBuilder, List<Report.ReportLine> list) {
        Iterator<Report.ReportLine> iterator = list.iterator();
        while (iterator.hasNext()) {
            Report.ReportLine reportLine = iterator.next();
            this.appendReportRow(stringBuilder, reportLine);
            if (!iterator.hasNext()) continue;
            stringBuilder.append(LINE_SEPERATOR);
        }
    }

    private void appendReportRow(StringBuilder stringBuilder, Report.ReportLine reportLine) {
        TreeMap treeMap = new TreeMap(reportLine.getValues());
        Iterator iterator = treeMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            stringBuilder.append(this.encloseInQuotes(entry.getValue().toString()));
            if (!iterator.hasNext()) continue;
            stringBuilder.append(CSV_SEPERATOR);
        }
    }
}

