/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.core.rest.api.reports;

import com.xebialabs.deployit.core.api.dto.Report;
import com.xebialabs.deployit.core.api.resteasy.Date;
import com.xebialabs.deployit.task.ArchivedTaskSearchParameters;
import com.xebialabs.deployit.task.DeploymentTaskInfo;
import com.xebialabs.deployit.task.TaskArchive;
import com.xebialabs.deployit.task.jcrarchive.JcrTaskArchive;

public class TasksInDateRangeReport {
    private TaskArchive taskArchive;

    public TasksInDateRangeReport(TaskArchive taskArchive) {
        this.taskArchive = taskArchive;
    }

    public Report report(Date date, Date date2) {
        ArchivedTaskSearchParameters archivedTaskSearchParameters = new ArchivedTaskSearchParameters();
        archivedTaskSearchParameters.createdBetween(date.getCalendar(), date2.getCalendar());
        final Report report = new Report();
        this.taskArchive.searchTasksWithoutLoadingSteps(archivedTaskSearchParameters, new JcrTaskArchive.TaskCallback(){

            public void doWithTask(DeploymentTaskInfo deploymentTaskInfo) {
                Report.ReportLine reportLine = report.addLine();
                reportLine.addValue("user", (Object)deploymentTaskInfo.getOwner());
                reportLine.addValue("status", (Object)deploymentTaskInfo.getState().name());
                reportLine.addValue("startDate", (Object)new Date(deploymentTaskInfo.getStartDate(), "yyyy-MM-dd'T'HH:mm:ss.SSSZ").toString());
                reportLine.addValue("completionDate", (Object)new Date(deploymentTaskInfo.getCompletionDate(), "yyyy-MM-dd'T'HH:mm:ss.SSSZ").toString());
                reportLine.addValue("package", (Object)(deploymentTaskInfo.getApplicationName() + "/" + deploymentTaskInfo.getApplicationVersion()));
                reportLine.addValue("environment", (Object)deploymentTaskInfo.getEnvironment());
                TasksInDateRangeReport.this.fillDeploymentType(reportLine, deploymentTaskInfo);
            }
        });
        return report;
    }

    private void fillDeploymentType(Report.ReportLine reportLine, DeploymentTaskInfo deploymentTaskInfo) {
        String string = "Unknown";
        switch (deploymentTaskInfo.getDeploymentType()) {
            case INITIAL: {
                string = "Initial";
                break;
            }
            case UPGRADE: {
                string = "Upgrade";
                break;
            }
            case UNDEPLOY: {
                string = "Undeployment";
            }
        }
        reportLine.addValue("type", (Object)string);
    }
}

