/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.core.rest.api;

import com.xebialabs.deployit.core.api.UserProxy;
import com.xebialabs.deployit.core.api.dto.User;
import com.xebialabs.deployit.core.api.resteasy.http.tunnel.ResponseFactory;
import com.xebialabs.deployit.security.JcrUser;
import com.xebialabs.deployit.security.UserService;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;

@Controller
public class UserResource
implements UserProxy {
    @Autowired
    UserService userService;
    private static final Logger logger = LoggerFactory.getLogger(UserResource.class);

    public Response create(String string, User user) {
        this.sanityCheckUser(string, user);
        logger.debug("Creating user {}", (Object)string);
        this.userService.create(string, user.getPassword());
        JcrUser jcrUser = this.userService.read(string);
        logger.debug("Created user {}", (Object)jcrUser.getUsername());
        return ResponseFactory.created((Object)new User(jcrUser.getUsername(), jcrUser.isAdmin())).build();
    }

    public Response read(String string) {
        JcrUser jcrUser = this.userService.read(string);
        return ResponseFactory.ok((Object)new User(jcrUser.getUsername(), jcrUser.isAdmin())).build();
    }

    public Response modifyPassword(String string, User user) {
        this.sanityCheckUser(string, user);
        this.userService.modifyPassword(string, user.getPassword());
        return ResponseFactory.noContent().build();
    }

    public Response delete(String string) {
        this.userService.delete(string);
        return ResponseFactory.noContent().build();
    }

    private void sanityCheckUser(String string, User user) {
        if (user.getUsername() != null && !user.getUsername().equals(string)) {
            throw new IllegalArgumentException("Username in URL is " + string + " but username in POST data is " + user.getUsername());
        }
    }
}

