/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.core.rest.api;

import com.google.common.base.Preconditions;
import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.core.api.ReportProxy;
import com.xebialabs.deployit.core.api.dto.ConfigurationItemIds;
import com.xebialabs.deployit.core.api.dto.Report;
import com.xebialabs.deployit.core.api.resteasy.Date;
import com.xebialabs.deployit.core.api.resteasy.http.tunnel.ResponseFactory;
import com.xebialabs.deployit.core.rest.api.reports.AggregatedDeploymentsKeyIndicator;
import com.xebialabs.deployit.core.rest.api.reports.DeploymentsForEnvironmentReport;
import com.xebialabs.deployit.core.rest.api.reports.DeploymentsKeyIndicator;
import com.xebialabs.deployit.core.rest.api.reports.DeploymentsStateBreakdownReport;
import com.xebialabs.deployit.core.rest.api.reports.ReportFilterType;
import com.xebialabs.deployit.core.rest.api.reports.TasksInDateRangeReport;
import com.xebialabs.deployit.core.rest.api.reports.widgets.WidgetRegistry;
import com.xebialabs.deployit.task.TaskArchive;
import java.text.SimpleDateFormat;
import javax.ws.rs.core.Response;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;

@Controller
public class ReportResource
implements ReportProxy {
    @Autowired
    private TaskArchive taskArchive;

    public Response deploymentsForEnvironment(String string, Date date, String string2) {
        Checks.checkNotNull((Object)string, (String)"environment");
        Checks.checkNotNull((Object)date, (String)"date");
        Checks.checkNotNull((Object)date.getCalendar(), (String)"date");
        Report report = new DeploymentsForEnvironmentReport(this.taskArchive).report(string, date);
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMdd");
        return this.createResponse(report, String.format("deployments-%s-%s.csv", string.replaceAll("/", "_"), simpleDateFormat.format(date.getCalendar().getTime())), string2);
    }

    public Response tasksInDateRange(Date date, Date date2, String string) {
        Checks.checkNotNull((Object)date, (String)"begin");
        Checks.checkNotNull((Object)date.getCalendar(), (String)"begin");
        Checks.checkNotNull((Object)date2, (String)"end");
        Checks.checkNotNull((Object)date2.getCalendar(), (String)"end");
        Report report = new TasksInDateRangeReport(this.taskArchive).report(date, date2);
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMdd");
        return this.createResponse(report, String.format("tasks-%s-%s.csv", simpleDateFormat.format(date.getCalendar().getTime()), simpleDateFormat.format(date2.getCalendar().getTime())), string);
    }

    public Response deploymentsStateBreakdown(String string, Date date, Date date2, String string2, ConfigurationItemIds configurationItemIds) {
        Checks.checkNotNull((Object)string, (String)"filterType");
        Checks.checkNotNull((Object)date, (String)"begin");
        Checks.checkNotNull((Object)date.getCalendar(), (String)"begin");
        Checks.checkNotNull((Object)date2, (String)"end");
        Checks.checkNotNull((Object)date2.getCalendar(), (String)"end");
        Checks.checkNotNull((Object)configurationItemIds.getConfigurationItemIds(), (String)"configurationItemIds");
        ReportFilterType reportFilterType = ReportFilterType.valueOf(string.toUpperCase());
        Report report = new DeploymentsStateBreakdownReport(this.taskArchive).report(configurationItemIds.getConfigurationItemIds(), date, date2, reportFilterType);
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMdd");
        return this.createResponse(report, String.format("deployments-by-state-%s-%s.csv", simpleDateFormat.format(date.getCalendar().getTime()), simpleDateFormat.format(date2.getCalendar().getTime())), string2);
    }

    public Response deploymentsKeyIndicator(Date date, Date date2, String string) {
        Checks.checkNotNull((Object)date, (String)"begin");
        Checks.checkNotNull((Object)date.getCalendar(), (String)"begin");
        Checks.checkNotNull((Object)date2, (String)"end");
        Checks.checkNotNull((Object)date2.getCalendar(), (String)"end");
        Report report = new DeploymentsKeyIndicator(this.taskArchive).report(date, date2);
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMdd");
        return this.createResponse(report, String.format("deployments-key-indicator-%s-%s.csv", simpleDateFormat.format(date.getCalendar().getTime()), simpleDateFormat.format(date2.getCalendar().getTime())), string);
    }

    public Response deploymentsKeyIndicatorAggregatedByFilterType(String string, Date date, Date date2, String string2, ConfigurationItemIds configurationItemIds) {
        Checks.checkNotNull((Object)string, (String)"filterType");
        Checks.checkNotNull((Object)date, (String)"begin");
        Checks.checkNotNull((Object)date.getCalendar(), (String)"begin");
        Checks.checkNotNull((Object)date2, (String)"end");
        Checks.checkNotNull((Object)date2.getCalendar(), (String)"end");
        Checks.checkNotNull((Object)configurationItemIds.getConfigurationItemIds(), (String)"configurationItemIds");
        ReportFilterType reportFilterType = ReportFilterType.valueOf(string.toUpperCase());
        Report report = new AggregatedDeploymentsKeyIndicator(this.taskArchive).report(date, date2, reportFilterType, configurationItemIds.getConfigurationItemIds());
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMdd");
        return this.createResponse(report, String.format("aggregated-deployments-key-indicator-%s-%s-%s.csv", string, simpleDateFormat.format(date.getCalendar().getTime()), simpleDateFormat.format(date2.getCalendar().getTime())), string2);
    }

    public Response getDashboardWidgetReport(String string, Date date, Date date2) {
        Checks.checkNotNull((Object)string, (String)"widget");
        Checks.checkNotNull((Object)date, (String)"begin");
        Checks.checkNotNull((Object)date.getCalendar(), (String)"begin");
        Checks.checkNotNull((Object)date2, (String)"end");
        Checks.checkNotNull((Object)date2.getCalendar(), (String)"end");
        Preconditions.checkArgument((date.getCalendar().getTime().compareTo(date2.getCalendar().getTime()) <= 0 ? 1 : 0) != 0);
        return ResponseFactory.ok((Object)WidgetRegistry.valueOf(WidgetRegistry.class, string.toUpperCase()).getWidget(this.taskArchive).getReport(date, date2)).build();
    }

    private Response createResponse(Report report, String string, String string2) {
        Response.ResponseBuilder responseBuilder = ResponseFactory.ok((Object)report);
        if ("text/csv".equals(string2)) {
            responseBuilder.header("Content-Disposition", (Object)("attachment; filename=" + string));
        }
        return responseBuilder.build();
    }
}

