/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.core.rest.api;

import com.xebialabs.deployit.core.api.ReferenceDataProxy;
import com.xebialabs.deployit.core.api.dto.ConfigurationItemDescriptorDto;
import com.xebialabs.deployit.core.api.dto.ConfigurationItemDescriptorList;
import com.xebialabs.deployit.core.api.dto.Orchestrators;
import com.xebialabs.deployit.core.api.dto.Permissions;
import com.xebialabs.deployit.core.api.resteasy.http.tunnel.ResponseFactory;
import com.xebialabs.deployit.core.rest.api.DtoWriter;
import com.xebialabs.deployit.plugin.api.reflect.Descriptor;
import com.xebialabs.deployit.plugin.api.reflect.DescriptorRegistry;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.security.permission.Permission;
import com.xebialabs.deployit.server.api.orchestrator.OrchestratorRegistry;
import java.util.ArrayList;
import javax.ws.rs.PathParam;
import javax.ws.rs.core.Response;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;

@Controller
public class ReferenceDataResource
implements ReferenceDataProxy {
    @Autowired
    private DtoWriter dtoWriter;

    public Response list() {
        ConfigurationItemDescriptorList configurationItemDescriptorList = new ConfigurationItemDescriptorList();
        ArrayList<ConfigurationItemDescriptorDto> arrayList = new ArrayList<ConfigurationItemDescriptorDto>();
        for (Descriptor descriptor : DescriptorRegistry.getDescriptors()) {
            if (descriptor.isVirtual()) continue;
            ConfigurationItemDescriptorDto configurationItemDescriptorDto = this.dtoWriter.descriptorToDto(descriptor);
            arrayList.add(configurationItemDescriptorDto);
        }
        configurationItemDescriptorList.setDescriptors(arrayList);
        return ResponseFactory.ok((Object)configurationItemDescriptorList).build();
    }

    public Response find(@PathParam(value="type") String string) {
        Descriptor descriptor = DescriptorRegistry.getDescriptor((Type)Type.valueOf((String)string));
        ConfigurationItemDescriptorDto configurationItemDescriptorDto = this.dtoWriter.descriptorToDto(descriptor);
        return ResponseFactory.ok((Object)configurationItemDescriptorDto).build();
    }

    public Response permissionList() {
        return ResponseFactory.ok((Object)new Permissions(this.dtoWriter.writeReferenceDataPermissions(Permission.values()))).build();
    }

    public Response orchestrators() {
        return ResponseFactory.ok((Object)new Orchestrators(OrchestratorRegistry.all())).build();
    }
}

