/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.core.rest.resteasy;

import com.google.common.collect.Sets;
import com.google.common.io.Closeables;
import com.xebialabs.deployit.io.TemporaryFiles;
import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Set;
import org.apache.james.mime4j.storage.AbstractStorageProvider;
import org.apache.james.mime4j.storage.Storage;
import org.apache.james.mime4j.storage.StorageOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Mime4jStorageProvider
extends AbstractStorageProvider {
    private static final String DEFAULT_PREFIX = "m4j";
    private final String prefix;
    private final String suffix;
    private final File directory;
    private static final Logger logger = LoggerFactory.getLogger(Mime4jStorageProvider.class);

    public Mime4jStorageProvider() {
        this(DEFAULT_PREFIX, null, null);
    }

    public Mime4jStorageProvider(File file) {
        this(DEFAULT_PREFIX, null, file);
    }

    public Mime4jStorageProvider(String string, String string2, File file) {
        if (string == null || string.length() < 3) {
            throw new IllegalArgumentException("invalid prefix");
        }
        if (file != null && !file.isDirectory() && !file.mkdirs()) {
            throw new IllegalArgumentException("invalid directory");
        }
        this.prefix = string;
        this.suffix = string2;
        this.directory = file;
    }

    public StorageOutputStream createStorageOutputStream() throws IOException {
        File file = File.createTempFile(this.prefix, this.suffix, this.directory);
        file.deleteOnExit();
        return new TempFileStorageOutputStream(file);
    }

    public static final class Mime4jTempFile
    implements Storage,
    TemporaryFiles.TemporaryFile {
        private File file;
        private Set<InputStream> streamsOpened = Sets.newHashSet();

        public Mime4jTempFile(File file) {
            this.file = file;
            TemporaryFiles.register((TemporaryFiles.TemporaryFile)this);
            logger.debug("Registered temporary file: {}", (Object)this);
        }

        public void delete() {
            if (this.file == null) {
                return;
            }
            logger.debug("Deleting temporary file: {}", (Object)this);
            for (InputStream inputStream : this.streamsOpened) {
                Closeables.closeQuietly((Closeable)inputStream);
            }
            this.streamsOpened.clear();
            if (this.file != null && this.file.delete()) {
                this.file = null;
            }
        }

        public boolean deleteWithResponse() {
            this.delete();
            return this.file == null;
        }

        public InputStream getInputStream() throws IOException {
            if (this.file == null) {
                throw new IllegalStateException("temporary file has been deleted.");
            }
            BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(this.file));
            this.streamsOpened.add(bufferedInputStream);
            return bufferedInputStream;
        }

        public String toString() {
            return "Mime4jTempFile[" + (this.file == null ? null : this.file.toString()) + "]";
        }
    }

    private static final class TempFileStorageOutputStream
    extends StorageOutputStream {
        private File file;
        private OutputStream out;

        public TempFileStorageOutputStream(File file) throws IOException {
            this.file = file;
            this.out = new FileOutputStream(file);
        }

        public void close() throws IOException {
            super.close();
            this.out.close();
        }

        protected void write0(byte[] byArray, int n, int n2) throws IOException {
            this.out.write(byArray, n, n2);
        }

        protected Storage toStorage0() throws IOException {
            return new Mime4jTempFile(this.file);
        }
    }
}

